/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyUtils;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.ResetPasswordDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class ChangeMasterKeyDialog
extends DialogWrapper {
    private JPasswordField myOldPasswordPasswordField;
    private JPasswordField myNewPasswordPasswordField;
    private JPasswordField myConfirmNewPasswordPasswordField;
    private JPanel myPanel;
    private JCheckBox myEncryptMasterPasswordWithCheckBox;
    private static final int RESET_PASSWORD_CODE = 2;

    protected ChangeMasterKeyDialog(Project project, MasterKeyPasswordSafe safe, boolean passwordEncrypted, String error) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle("Change Master Password");
        this.setOKButtonText("Change Password");
        if (!safe.isOsProtectedPasswordSupported()) {
            this.myEncryptMasterPasswordWithCheckBox.setSelected(false);
            this.myEncryptMasterPasswordWithCheckBox.setVisible(false);
        } else {
            this.myEncryptMasterPasswordWithCheckBox.setSelected(passwordEncrypted);
        }
        MasterKeyUtils.matchPasswords(this.myConfirmNewPasswordPasswordField, this.myNewPasswordPasswordField, new Processor<String>(){

            public boolean process(String s) {
                ChangeMasterKeyDialog.this.setErrorText(s);
                ChangeMasterKeyDialog.this.setOKActionEnabled(s == null);
                return false;
            }
        });
        this.setErrorText(error);
        this.init();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, "Reset Password", 2), this.getCancelAction()};
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public static boolean changePassword(Project project, MasterKeyPasswordSafe safe) {
        String error = null;
        boolean encrypt = safe.isPasswordEncrypted();
        while (true) {
            ChangeMasterKeyDialog d = new ChangeMasterKeyDialog(project, safe, encrypt, error);
            d.show();
            encrypt = d.myEncryptMasterPasswordWithCheckBox.isSelected();
            switch (d.getExitCode()) {
                case 0: {
                    String o = new String(d.myOldPasswordPasswordField.getPassword());
                    String n = new String(d.myNewPasswordPasswordField.getPassword());
                    if (safe.changeMasterPassword(o, n, encrypt)) {
                        return true;
                    }
                    error = "Invalid old password was specified, please retry";
                    break;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return ResetPasswordDialog.resetPassword(project, safe);
                }
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPasswordField jPasswordField;
        JPasswordField jPasswordField2;
        JPasswordField jPasswordField3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Please specify old and new master passwords");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Old Password");
        jLabel2.setDisplayedMnemonic('O');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOldPasswordPasswordField = jPasswordField3 = new JPasswordField();
        jPanel.add((Component)jPasswordField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("New Password");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNewPasswordPasswordField = jPasswordField2 = new JPasswordField();
        jPanel.add((Component)jPasswordField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Confirm New Password");
        jLabel4.setDisplayedMnemonic('C');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfirmNewPasswordPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEncryptMasterPasswordWithCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Encrypt master password with user credentials");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setToolTipText("The master password will be stored in password database \nencrypted with user credentials using OS-specific mechanisms.\nIf this checkbox is selected, the master password will not be asked\nfrom user, on new session.");
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jPasswordField3);
        jLabel3.setLabelFor(jPasswordField2);
        jLabel4.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

