/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PasswordDatabase", storages={@Storage(id="PasswordDatabase", file="$APP_CONFIG$/security.xml")})
public class PasswordDatabase
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)PasswordDatabase.class.getName());
    private final transient Map<ByteArrayWrapper, byte[]> myDatabase = new HashMap<ByteArrayWrapper, byte[]>();
    private transient byte[] myMasterPasswordInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            this.myDatabase.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            return this.myDatabase.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] key, byte[] value) {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            this.myDatabase.put(new ByteArrayWrapper(key), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(Map<ByteArrayWrapper, byte[]> copy) {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            copy.putAll(this.myDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<ByteArrayWrapper, byte[]> copy) {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            this.myDatabase.putAll(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            return this.myDatabase.get(new ByteArrayWrapper(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] key) {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            this.myDatabase.remove(new ByteArrayWrapper(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        TreeMap<ByteArrayWrapper, byte[]> sorted;
        String pi;
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            pi = PasswordDatabase.toHex(this.myMasterPasswordInfo);
            sorted = new TreeMap<ByteArrayWrapper, byte[]>(this.myDatabase);
        }
        String[][] db = new String[2][sorted.size()];
        int i = 0;
        for (Map.Entry<ByteArrayWrapper, byte[]> e : sorted.entrySet()) {
            db[0][i] = PasswordDatabase.toHex(e.getKey().unwrap());
            db[1][i] = PasswordDatabase.toHex(e.getValue());
            ++i;
        }
        State s = new State();
        s.PASSWORDS = db;
        s.MASTER_PASSWORD_INFO = pi;
        return s;
    }

    @Nullable
    private static String toHex(byte[] bytes) {
        return bytes == null ? null : new String(Hex.encodeHex((byte[])bytes));
    }

    @Nullable
    private static byte[] fromHex(String hex) throws DecoderException {
        return hex == null ? null : Hex.decodeHex((char[])hex.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(State state) {
        String[][] db = state.PASSWORDS;
        String pi = state.MASTER_PASSWORD_INFO;
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            try {
                this.myMasterPasswordInfo = PasswordDatabase.fromHex(pi);
                if (this.myMasterPasswordInfo == null) {
                    this.myMasterPasswordInfo = new byte[0];
                }
            }
            catch (DecoderException e) {
                this.myMasterPasswordInfo = new byte[0];
            }
            this.myDatabase.clear();
            if (db[0].length != db[1].length) {
                LOG.warn("The password database is in inconsistent state, ignoring it: " + db[0].length + " != " + db[1].length);
            }
            int n = db[0].length;
            for (int i = 0; i < n; ++i) {
                try {
                    byte[] key = PasswordDatabase.fromHex(db[0][i]);
                    byte[] value = PasswordDatabase.fromHex(db[1][i]);
                    if (key == null || value == null) continue;
                    this.myDatabase.put(new ByteArrayWrapper(key), value);
                    continue;
                }
                catch (DecoderException e) {
                    // empty catch block
                }
            }
        }
    }

    Object getDbLock() {
        return this.myDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getPasswordInfo() {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            return this.myMasterPasswordInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordInfo(byte[] bytes) {
        Map<ByteArrayWrapper, byte[]> map = this.myDatabase;
        synchronized (map) {
            this.myMasterPasswordInfo = bytes;
        }
    }

    public static class State {
        public String MASTER_PASSWORD_INFO = "";
        public String[][] PASSWORDS = new String[0][];
    }
}

