/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.DirectoryChooserModuleTreeView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DirectoryChooserUtil {
    private DirectoryChooserUtil() {
    }

    public static PsiDirectory getOrChooseDirectory(IdeView view) {
        PsiDirectory[] dirs = view.getDirectories();
        if (dirs.length == 0) {
            return null;
        }
        if (dirs.length == 1) {
            return dirs[0];
        }
        Project project = dirs[0].getProject();
        return DirectoryChooserUtil.selectDirectory(project, dirs, null, "");
    }

    public static PsiDirectory selectDirectory(Project project, PsiDirectory[] packageDirectories, PsiDirectory defaultDirectory, String postfixToShow) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        ArrayList<PsiDirectory> possibleDirs = new ArrayList<PsiDirectory>();
        for (PsiDirectory dir : packageDirectories) {
            if (!dir.isValid() || !dir.isWritable() || possibleDirs.contains(dir) || !projectFileIndex.isInContent(dir.getVirtualFile())) continue;
            possibleDirs.add(dir);
        }
        if (possibleDirs.isEmpty()) {
            return null;
        }
        if (possibleDirs.size() == 1) {
            return (PsiDirectory)possibleDirs.get(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PsiDirectory)possibleDirs.get(0);
        }
        DirectoryChooser chooser = new DirectoryChooser(project);
        chooser.setTitle(IdeBundle.message((String)"title.choose.destination.directory", (Object[])new Object[0]));
        chooser.fillList(possibleDirs.toArray(new PsiDirectory[possibleDirs.size()]), defaultDirectory, project, postfixToShow);
        chooser.show();
        return chooser.isOK() ? chooser.getSelectedDirectory() : null;
    }

    @Nullable
    public static PsiDirectory chooseDirectory(PsiDirectory[] targetDirectories, @Nullable PsiDirectory initialDirectory, Project project, Map<PsiDirectory, String> relativePathsToCreate) {
        DirectoryChooser chooser = new DirectoryChooser(project, new DirectoryChooserModuleTreeView(project));
        chooser.setTitle(RefactoringBundle.message((String)"choose.destination.directory"));
        chooser.fillList(targetDirectories, initialDirectory, project, relativePathsToCreate);
        chooser.show();
        if (!chooser.isOK()) {
            return null;
        }
        return chooser.getSelectedDirectory();
    }
}

