/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionModel
implements ChooseByNameModel,
CustomMatcherModel {
    private final Project myProject;
    private final Component myContextComponent;
    private final ActionManager myActionManager = ActionManager.getInstance();
    private static final EmptyIcon EMPTY_ICON = new EmptyIcon(18, 18);
    private String myPattern;
    private Pattern myCompiledPattern;
    private final PatternMatcher myMatcher = new Perl5Matcher();

    public GotoActionModel(Project project, Component component) {
        this.myProject = project;
        this.myContextComponent = component;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoaction.enter.action", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.other.included", (Object[])new Object[0]);
    }

    public char getCheckBoxMnemonic() {
        return 'd';
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.menu.actions.found", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.actions.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return propertiesComponent.isTrueValue("GoToAction.allIncluded");
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue("GoToAction.allIncluded", Boolean.toString(state));
    }

    public ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.setOpaque(true);
                Color bg = isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
                panel.setBackground(bg);
                if (value instanceof Map.Entry) {
                    Map.Entry actionWithParentGroup = (Map.Entry)value;
                    AnAction anAction = (AnAction)actionWithParentGroup.getKey();
                    Presentation templatePresentation = anAction.getTemplatePresentation();
                    Icon icon = templatePresentation.getIcon();
                    DataContext dataContext = DataManager.getInstance().getDataContext(GotoActionModel.this.myContextComponent);
                    AnActionEvent event = GotoActionModel.this.updateActionBeforShow(anAction, dataContext);
                    Presentation presentation = event.getPresentation();
                    Color fg = GotoActionModel.this.defaultActionForeground(isSelected, presentation);
                    JLabel actionLabel = GotoActionModel.this.createActionLabel(anAction, templatePresentation.getText(), fg, bg, icon);
                    panel.add((Component)actionLabel, "West");
                    String groupName = (String)actionWithParentGroup.getValue();
                    if (groupName != null) {
                        JLabel groupLabel = new JLabel(groupName);
                        groupLabel.setBackground(bg);
                        groupLabel.setForeground(fg);
                        panel.add((Component)groupLabel, "East");
                    }
                }
                return panel;
            }
        };
    }

    protected String getActionId(@NotNull AnAction anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/gotoByName/GotoActionModel.getActionId must not be null");
        }
        return this.myActionManager.getId(anAction);
    }

    protected JLabel createActionLabel(AnAction anAction, String anActionName, Color fg, Color bg, Icon icon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon((Icon)EMPTY_ICON, 0);
        if (icon != null && icon.getIconWidth() <= EMPTY_ICON.getIconWidth() && icon.getIconHeight() <= EMPTY_ICON.getIconHeight()) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        Shortcut[] shortcutSet = KeymapManager.getInstance().getActiveKeymap().getShortcuts(this.getActionId(anAction));
        String actionName = anActionName + (shortcutSet != null && shortcutSet.length > 0 ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcutSet[0]) + ")" : "");
        JLabel actionLabel = new JLabel(actionName, (Icon)layeredIcon, 2);
        actionLabel.setBackground(bg);
        actionLabel.setForeground(fg);
        return actionLabel;
    }

    protected AnActionEvent updateActionBeforShow(AnAction anAction, DataContext dataContext) {
        AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate((AnAction)anAction, (AnActionEvent)event, (boolean)false);
        ActionUtil.performDumbAwareUpdate((AnAction)anAction, (AnActionEvent)event, (boolean)true);
        return event;
    }

    protected Color defaultActionForeground(boolean isSelected, Presentation presentation) {
        return isSelected ? UIUtil.getListSelectionForeground() : (presentation.isEnabled() && presentation.isVisible() ? UIUtil.getListForeground() : UIUtil.getInactiveTextColor());
    }

    public String[] getNames(boolean checkBoxState) {
        ArrayList<String> result = new ArrayList<String>();
        this.collectActionIds(result, (ActionGroup)this.myActionManager.getActionOrStub("MainMenu"));
        if (checkBoxState) {
            Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
            for (String id : ids) {
                AnAction anAction = this.myActionManager.getAction(id);
                if (anAction instanceof ActionGroup) continue;
                result.add(id);
            }
        }
        return ArrayUtil.toStringArray(result);
    }

    private void collectActionIds(Collection<String> result, ActionGroup group) {
        AnAction[] actions;
        for (AnAction action : actions = group.getChildren(null)) {
            if (action instanceof ActionGroup) {
                this.collectActionIds(result, (ActionGroup)action);
                continue;
            }
            if (action == null) continue;
            result.add(this.getActionId(action));
        }
    }

    public Object[] getElementsByName(String id, boolean checkBoxState, String pattern) {
        HashMap<AnAction, String> map = new HashMap<AnAction, String>();
        ActionGroup mainMenu = (ActionGroup)this.myActionManager.getActionOrStub("MainMenu");
        this.collectActions(id, map, mainMenu, mainMenu.getTemplatePresentation().getText());
        if (checkBoxState) {
            AnAction anAction;
            Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
            for (AnAction action : map.keySet()) {
                ids.remove(this.getActionId(action));
            }
            if (ids.contains(id) && !((anAction = this.myActionManager.getAction(id)) instanceof ActionGroup)) {
                map.put(anAction, null);
            }
        }
        return map.entrySet().toArray(new Map.Entry[map.size()]);
    }

    private void collectActions(String id, Map<AnAction, String> result, ActionGroup group, String containingGroupName) {
        AnAction[] actions;
        for (AnAction action : actions = group.getChildren(null)) {
            if (action == null) continue;
            if (action instanceof ActionGroup) {
                ActionGroup actionGroup;
                String groupName = (actionGroup = (ActionGroup)action).getTemplatePresentation().getText();
                this.collectActions(id, result, actionGroup, groupName != null ? groupName : containingGroupName);
                continue;
            }
            if (this.getActionId(action) != id) continue;
            String groupName = group.getTemplatePresentation().getText();
            result.put(action, groupName != null && groupName.length() > 0 ? groupName : containingGroupName);
        }
    }

    @Nullable
    public String getFullName(Object element) {
        return this.getElementName(element);
    }

    public String getHelpId() {
        return "procedures.navigating.goto.action";
    }

    @NotNull
    public String[] getSeparators() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/gotoByName/GotoActionModel.getSeparators must not return null");
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getElementName(Object element) {
        if (!(element instanceof Map.Entry)) {
            return null;
        }
        return ((AnAction)((Map.Entry)element).getKey()).getTemplatePresentation().getText();
    }

    @Override
    public boolean matches(@NotNull String name, @NotNull String pattern) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/gotoByName/GotoActionModel.matches must not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/gotoByName/GotoActionModel.matches must not be null");
        }
        AnAction anAction = this.myActionManager.getAction(name);
        if (!(anAction instanceof ActionGroup)) {
            Presentation presentation = anAction.getTemplatePresentation();
            String text = presentation.getText();
            String description = presentation.getDescription();
            Pattern compiledPattern = this.getPattern(pattern);
            if (text != null && this.myMatcher.matches(text, compiledPattern) || description != null && this.myMatcher.matches(description, compiledPattern)) {
                return true;
            }
        }
        return false;
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected Component getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    private Pattern getPattern(String pattern) {
        if (!Comparing.strEqual((String)pattern, (String)this.myPattern)) {
            this.myCompiledPattern = null;
            this.myPattern = pattern;
        }
        if (this.myCompiledPattern == null) {
            boolean allowToLower = true;
            int eol = pattern.indexOf(10);
            if (eol != -1) {
                pattern = pattern.substring(0, eol);
            }
            if (pattern.length() >= 80) {
                pattern = pattern.substring(0, 80);
            }
            StringBuffer buffer = new StringBuffer();
            if (GotoActionModel.containsOnlyUppercaseLetters(pattern)) {
                allowToLower = false;
            }
            if (allowToLower) {
                buffer.append(".*");
            }
            boolean firstIdentifierLetter = true;
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    if (Character.isUpperCase(c) || Character.isDigit(c)) {
                        if (!firstIdentifierLetter) {
                            buffer.append("[^A-Z]*");
                        }
                        buffer.append("[");
                        buffer.append(c);
                        if (allowToLower || i == 0) {
                            buffer.append('|');
                            buffer.append(Character.toLowerCase(c));
                        }
                        buffer.append("]");
                    } else if (Character.isLowerCase(c)) {
                        buffer.append('[');
                        buffer.append(c);
                        buffer.append('|');
                        buffer.append(Character.toUpperCase(c));
                        buffer.append(']');
                    } else {
                        buffer.append(c);
                    }
                    firstIdentifierLetter = false;
                    continue;
                }
                if (c == '*') {
                    buffer.append(".*");
                    firstIdentifierLetter = true;
                    continue;
                }
                if (c == '.') {
                    buffer.append("\\.");
                    firstIdentifierLetter = true;
                    continue;
                }
                if (c == ' ') {
                    buffer.append("[^A-Z]*\\ ");
                    firstIdentifierLetter = true;
                    continue;
                }
                firstIdentifierLetter = true;
                buffer.append("\\x");
                buffer.append(Integer.toHexString(c + 131072).substring(3));
            }
            buffer.append(".*");
            try {
                this.myCompiledPattern = new Perl5Compiler().compile(buffer.toString());
            }
            catch (MalformedPatternException e) {
                // empty catch block
            }
        }
        Pattern pattern2 = this.myCompiledPattern;
        if (pattern2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/gotoByName/GotoActionModel.getPattern must not return null");
        }
        return pattern2;
    }

    private static boolean containsOnlyUppercaseLetters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '*' || c == ' ' || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }
}

