/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.splitter.FoldingTransformation;
import com.intellij.openapi.diff.impl.splitter.Interval;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.diff.impl.splitter.Trapezium;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;

class DividerPoligon {
    private final Color myColor;
    private final int myStart1;
    private final int myStart2;
    private final int myEnd1;
    private final int myEnd2;

    public DividerPoligon(int start1, int start2, int end1, int end2, Color color) {
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myEnd1 = end1;
        this.myEnd2 = end2;
        this.myColor = color;
    }

    private void paint(Graphics2D g, int width) {
        g.setColor(this.myColor);
        g.fill(new Polygon(new int[]{0, 0, width, width}, new int[]{this.myStart1, this.myEnd1, this.myEnd2, this.myStart2}, 4));
        g.setColor(Color.GRAY);
        UIUtil.drawLine((Graphics)g, (int)0, (int)this.myStart1, (int)width, (int)this.myStart2);
        UIUtil.drawLine((Graphics)g, (int)0, (int)this.myEnd1, (int)width, (int)this.myEnd2);
    }

    public int hashCode() {
        return this.myStart1 ^ this.myStart2 ^ this.myEnd1 ^ this.myEnd2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DividerPoligon)) {
            return false;
        }
        DividerPoligon other = (DividerPoligon)obj;
        return this.myStart1 == other.myStart1 && this.myStart2 == other.myStart2 && this.myEnd1 == other.myEnd1 && this.myEnd2 == other.myEnd2 && Comparing.equal((Object)this.myColor, (Object)other.myColor);
    }

    public String toString() {
        return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myColor;
    }

    Color getColor() {
        return this.myColor;
    }

    public static void paintPoligons(ArrayList<DividerPoligon> poligons, Graphics2D g, int width) {
        for (DividerPoligon poligon : poligons) {
            poligon.paint(g, width);
        }
    }

    public static ArrayList<DividerPoligon> createVisiblePoligons(EditingSides sides, FragmentSide left) {
        Editor editor1 = sides.getEditor(left);
        Editor editor2 = sides.getEditor(left.otherSide());
        LineBlocks lineBlocks = sides.getLineBlocks();
        Trapezium visibleArea = new Trapezium(DividerPoligon.getVisibleInterval(editor1), DividerPoligon.getVisibleInterval(editor2));
        Interval indecies = lineBlocks.getVisibleIndecies(visibleArea);
        Transformation[] transformations = new Transformation[]{DividerPoligon.getTransformation(editor1), DividerPoligon.getTransformation(editor2)};
        ArrayList<DividerPoligon> poligons = new ArrayList<DividerPoligon>();
        for (int i = indecies.getStart(); i < indecies.getEnd(); ++i) {
            TextDiffType type;
            Trapezium trapezium = lineBlocks.getTrapezium(i);
            TextDiffTypeEnum diffTypeEnum = lineBlocks.getType(i);
            if (diffTypeEnum == null || (type = TextDiffType.create(diffTypeEnum)) == null) continue;
            Color color = type.getPoligonColor(editor1);
            poligons.add(DividerPoligon.createPoligon(transformations, trapezium, color, left));
        }
        return poligons;
    }

    private static Transformation getTransformation(Editor editor) {
        return new FoldingTransformation(editor);
    }

    private static DividerPoligon createPoligon(Transformation[] transformations, Trapezium trapezium, Color color, FragmentSide left) {
        Interval base1 = trapezium.getBase(left);
        Interval base2 = trapezium.getBase(left.otherSide());
        Transformation leftTransform = transformations[left.getIndex()];
        Transformation rightTransform = transformations[left.otherSide().getIndex()];
        int start1 = leftTransform.transform(base1.getStart());
        int end1 = leftTransform.transform(base1.getEnd());
        int start2 = rightTransform.transform(base2.getStart());
        int end2 = rightTransform.transform(base2.getEnd());
        return new DividerPoligon(start1, start2, end1, end2, color);
    }

    static Interval getVisibleInterval(Editor editor) {
        int offset = editor.getScrollingModel().getVerticalScrollOffset();
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(new Point(0, offset));
        int line = logicalPosition.line;
        return new Interval(line, editor.getComponent().getHeight() / editor.getLineHeight() + 1);
    }
}

