/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileNodeDescriptor
extends NodeDescriptor {
    private FileElement myFileElement;
    private final Icon myOriginalOpenIcon;
    private final Icon myOriginalClosedIcon;
    private final String myComment;

    public FileNodeDescriptor(Project project, @NotNull FileElement element, NodeDescriptor parentDescriptor, Icon openIcon, Icon closedIcon, String name, String comment) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileChooser/ex/FileNodeDescriptor.<init> must not be null");
        }
        super(project, parentDescriptor);
        this.myOriginalOpenIcon = openIcon;
        this.myOriginalClosedIcon = closedIcon;
        this.myComment = comment;
        this.myFileElement = element;
        this.myName = name;
    }

    public boolean update() {
        VirtualFile file;
        boolean changed = false;
        if (this.myName == null || this.myComment == null) {
            String newName = this.myFileElement.toString();
            if (!newName.equals(this.myName)) {
                changed = true;
            }
            this.myName = newName;
        }
        if ((file = this.myFileElement.getFile()) == null) {
            return true;
        }
        this.myOpenIcon = this.myOriginalOpenIcon;
        this.myClosedIcon = this.myOriginalClosedIcon;
        if (this.myFileElement.isHidden()) {
            this.myOpenIcon = IconLoader.getTransparentIcon((Icon)this.myOpenIcon);
            this.myClosedIcon = IconLoader.getTransparentIcon((Icon)this.myClosedIcon);
        }
        this.myColor = this.myFileElement.isHidden() ? SimpleTextAttributes.DARK_TEXT.getFgColor() : null;
        return changed;
    }

    @NotNull
    public final FileElement getElement() {
        FileElement fileElement = this.myFileElement;
        if (fileElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileChooser/ex/FileNodeDescriptor.getElement must not return null");
        }
        return fileElement;
    }

    protected final void setElement(FileElement descriptor) {
        this.myFileElement = descriptor;
    }

    public String getComment() {
        return this.myComment;
    }
}

