/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class RootFileElement
extends FileElement {
    private final VirtualFile[] myFiles;
    private final boolean myShowFileSystemRoots;
    private Object[] myChildren;

    public RootFileElement(VirtualFile[] files, String name, boolean showFileSystemRoots) {
        super(files.length == 1 ? files[0] : null, name);
        this.myFiles = files;
        this.myShowFileSystemRoots = showFileSystemRoots;
    }

    public Object[] getChildren() {
        if (this.myFiles.length <= 1 && this.myShowFileSystemRoots) {
            return RootFileElement.getFileSystemRoots();
        }
        if (this.myChildren == null) {
            this.myChildren = this.createFileElementArray();
        }
        return this.myChildren;
    }

    private Object[] createFileElementArray() {
        ArrayList<FileElement> roots = new ArrayList<FileElement>();
        for (VirtualFile file : this.myFiles) {
            if (file == null) continue;
            roots.add(new FileElement(file, file.getPresentableUrl()));
        }
        return ArrayUtil.toObjectArray(roots);
    }

    private static Object[] getFileSystemRoots() {
        File[] roots = File.listRoots();
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        HashSet<FileElement> rootChildren = new HashSet<FileElement>();
        for (File root : roots) {
            String path = root.getAbsolutePath();
            VirtualFile file = localFileSystem.findFileByPath(path = path.replace(File.separatorChar, '/'));
            if (file == null) continue;
            rootChildren.add(new FileElement(file, file.getPresentableUrl()));
        }
        return ArrayUtil.toObjectArray(rootChildren);
    }
}

