/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.io.InputStream;

public class ProgressStream
extends InputStream {
    private InputStream myInputStream;
    private ProgressIndicator myProgressIndicator;
    private long available;
    private long count;

    public ProgressStream(InputStream inputStream, ProgressIndicator progressIndicator) {
        this(0L, 0L, inputStream, progressIndicator);
    }

    public ProgressStream(long start, long available, InputStream inputStream, ProgressIndicator progressIndicator) {
        this.count = start;
        this.available = available;
        this.myInputStream = inputStream;
        this.myProgressIndicator = progressIndicator;
    }

    @Override
    public int read() throws IOException {
        if (this.myProgressIndicator != null) {
            if (this.myProgressIndicator.isCanceled()) {
                throw new RuntimeException(new InterruptedException());
            }
            if (this.available > 0L) {
                this.myProgressIndicator.setFraction((double)this.count++ / (double)this.available);
            } else {
                this.myProgressIndicator.setFraction(1.0 - 1.0 / (double)this.count++);
            }
        }
        return this.myInputStream.read();
    }
}

