/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BlockingProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.FocusTrackbackProvider;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class ProgressWindow
extends BlockingProgressIndicator
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressWindow");
    private static final int UPDATE_INTERVAL = 50;
    private MyDialog myDialog;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Alarm myInstallFunAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Alarm myShowWindowAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Project myProject;
    private final boolean myShouldShowCancel;
    private String myCancelText;
    private String myTitle = null;
    private boolean myStoppedAlready = false;
    protected final FocusTrackback myFocusTrackback;
    private boolean myStarted = false;
    private boolean myBackgrounded = false;
    private boolean myWasShown;
    private String myProcessId = "<unknown>";
    @Nullable
    private volatile Runnable myBackgroundHandler;

    public ProgressWindow(boolean shouldShowCancel, Project project) {
        this(shouldShowCancel, false, project);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project) {
        this(shouldShowCancel, shouldShowBackground, project, null);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, String cancelText) {
        this(shouldShowCancel, shouldShowBackground, project, null, cancelText);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, JComponent parentComponent, String cancelText) {
        this.myProject = project;
        this.myShouldShowCancel = shouldShowCancel;
        this.myCancelText = cancelText;
        this.setModalityProgress(shouldShowBackground ? null : this);
        this.myFocusTrackback = new FocusTrackback((Object)this, WindowManager.getInstance().suggestParentWindow(project), false);
        Container parent = parentComponent;
        if (parent == null && project == null) {
            parent = JOptionPane.getRootFrame();
        }
        this.myDialog = parent != null ? new MyDialog(shouldShowBackground, parent, this.myCancelText) : new MyDialog(shouldShowBackground, this.myProject, this.myCancelText);
        Disposer.register((Disposable)this, (Disposable)this.myDialog);
        this.myFocusTrackback.registerFocusComponent(this.myDialog.getPanel());
    }

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning());
        LOG.assertTrue(!this.myStoppedAlready);
        super.start();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.prepareShowDialog();
        }
        this.myStarted = true;
    }

    private synchronized boolean isStarted() {
        return this.myStarted;
    }

    protected void prepareShowDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.myShowWindowAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (ProgressWindow.this.isRunning()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DialogWrapper popup;
                                    if (ProgressWindow.this.myDialog != null && (popup = ProgressWindow.this.myDialog.myPopup) != null) {
                                        ProgressWindow.this.myFocusTrackback.registerFocusComponent(new FocusTrackback.ComponentQuery(){

                                            @Override
                                            public Component getComponent() {
                                                return popup.getPreferredFocusedComponent();
                                            }
                                        });
                                        if (popup.isShowing()) {
                                            ProgressWindow.this.myWasShown = true;
                                        }
                                    }
                                }
                            });
                            ProgressWindow.this.showDialog();
                        } else {
                            Disposer.dispose((Disposable)ProgressWindow.this);
                        }
                    }
                }, 300, ProgressWindow.this.getModalityState());
            }
        });
    }

    @Override
    public void startBlocking() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(!this.isRunning());
        LOG.assertTrue(!this.myStoppedAlready);
        this.enterModality();
        IdeEventQueue.getInstance().pumpEventsForHierarchy(this.myDialog.myPanel, new Condition<AWTEvent>(){

            public boolean value(AWTEvent object) {
                if (ProgressWindow.this.myShouldShowCancel && object instanceof KeyEvent && object.getID() == 401 && ((KeyEvent)object).getKeyCode() == 27 && ((KeyEvent)object).getModifiers() == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgressWindow.this.cancel();
                        }
                    });
                }
                return ProgressWindow.this.isStarted() && !ProgressWindow.this.isRunning();
            }
        });
        this.exitModality();
    }

    public String getProcessId() {
        return this.myProcessId;
    }

    public void setProcessId(String processId) {
        this.myProcessId = processId;
    }

    protected void showDialog() {
        if (!this.isRunning() || this.isCanceled()) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            Runnable installer = new Runnable(){

                @Override
                public void run() {
                    JComponent cmp;
                    if (ProgressWindow.this.isRunning() && !ProgressWindow.this.isCanceled() && ProgressWindow.this.getFraction() < 0.15 && ProgressWindow.this.myDialog != null && (cmp = ProgressManager.getInstance().getProvidedFunComponent(ProgressWindow.this.myProject, ProgressWindow.this.getProcessId())) != null) {
                        ProgressWindow.this.setFunComponent(cmp);
                    }
                }
            };
            this.myInstallFunAlarm.addRequest(installer, 3000, this.getModalityState());
        }
        this.myWasShown = true;
        this.myDialog.show();
        if (this.myDialog != null) {
            this.myDialog.myRepaintRunnable.run();
        }
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.update();
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(!this.myStoppedAlready);
        this.myInstallFunAlarm.cancelAllRequests();
        super.stop();
        if (this.myDialog != null) {
            this.myDialog.hide();
            if (this.myDialog.wasShown()) {
                this.myFocusTrackback.restoreFocus();
            } else {
                this.myFocusTrackback.consume();
            }
        }
        this.myStoppedAlready = true;
        Disposer.dispose((Disposable)this);
        SwingUtilities.invokeLater(EmptyRunnable.INSTANCE);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.myDialog != null) {
            this.myDialog.cancel();
        }
    }

    public void background() {
        Runnable backgroundHandler = this.myBackgroundHandler;
        if (backgroundHandler != null) {
            backgroundHandler.run();
            return;
        }
        if (this.myDialog != null) {
            this.myBackgrounded = true;
            this.myDialog.background();
            if (this.myDialog.wasShown()) {
                this.myFocusTrackback.restoreFocus();
            } else {
                this.myFocusTrackback.consume();
            }
            this.myDialog = null;
        }
    }

    public boolean isBackgrounded() {
        return this.myBackgrounded;
    }

    @Override
    public void setText(String text) {
        if (!Comparing.equal((String)text, (String)this.getText())) {
            super.setText(text);
            this.update();
        }
    }

    @Override
    public void setFraction(double fraction) {
        if (fraction != this.getFraction()) {
            super.setFraction(fraction);
            this.update();
        }
    }

    @Override
    public void setText2(String text) {
        if (!Comparing.equal((String)text, (String)this.getText2())) {
            super.setText2(text);
            this.update();
        }
    }

    private void update() {
        if (this.myDialog != null) {
            this.myDialog.update();
        }
    }

    public void setTitle(String title) {
        if (!Comparing.equal((String)title, (String)this.myTitle)) {
            this.myTitle = title;
            this.update();
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    protected static int getPercentage(double fraction) {
        return (int)(fraction * 99.0 + 0.5);
    }

    public void setBackgroundHandler(@Nullable Runnable backgroundHandler) {
        this.myBackgroundHandler = backgroundHandler;
        this.myDialog.setShouldShowBackground(backgroundHandler != null);
    }

    public void setCancelButtonText(String text) {
        if (this.myDialog != null) {
            this.myDialog.changeCancelButtonText(text);
        } else {
            this.myCancelText = text;
        }
    }

    private void setFunComponent(JComponent c) {
        this.myDialog.myFunPanel.removeAll();
        if (c != null) {
            this.myDialog.myFunPanel.add((Component)new JSeparator(), "North");
            this.myDialog.myFunPanel.add((Component)c, "Center");
        }
        if (this.myDialog.myPopup != null && !(this.myDialog.myPopup.getPeer() instanceof GlassPaneDialogWrapperPeer)) {
            Window wnd = SwingUtilities.windowForComponent(this.myDialog.myPanel);
            if (wnd != null) {
                wnd.pack();
            }
        } else if (this.myDialog.myPopup != null) {
            this.myDialog.myPopup.validate();
        }
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void dispose() {
    }

    protected class MyDialog
    implements Disposable {
        private long myLastTimeDrawn = -1L;
        private volatile boolean myShouldShowBackground;
        private final Runnable myRepaintRunnable;
        private final Runnable myUpdateRequest;
        private JPanel myPanel;
        private JLabel myTextLabel;
        private JLabel myPercentLabel;
        private JLabel myText2Label;
        private JButton myCancelButton;
        private JButton myBackgroundButton;
        private JProgressBar myProgressBar;
        private boolean myRepaintedFlag;
        private JPanel myFunPanel;
        private TitlePanel myTitlePanel;
        private DialogWrapper myPopup;
        private final Window myParentWindow;
        private Point myLastClicked;

        private String getTitle2Text(String fullText, int labelWidth) {
            if (fullText == null || fullText.length() == 0) {
                return " ";
            }
            while (this.myText2Label.getFontMetrics(this.myText2Label.getFont()).stringWidth(fullText) > labelWidth) {
                int sep = fullText.indexOf(File.separatorChar, 4);
                if (sep < 0) {
                    return fullText;
                }
                fullText = "..." + fullText.substring(sep);
            }
            return fullText;
        }

        public MyDialog(boolean shouldShowBackground, Project project, String cancelText) {
            this.$$$setupUI$$$();
            this.myRepaintRunnable = new Runnable(){

                @Override
                public void run() {
                    String text = ProgressWindow.this.getText();
                    double fraction = ProgressWindow.this.getFraction();
                    String text2 = ProgressWindow.this.getText2();
                    MyDialog.this.myTextLabel.setText(text != null && text.length() > 0 ? text : " ");
                    if (!ProgressWindow.this.isIndeterminate() && fraction > 0.0) {
                        MyDialog.this.myPercentLabel.setText(ProgressWindow.getPercentage(fraction) + "%");
                    } else {
                        MyDialog.this.myPercentLabel.setText(" ");
                    }
                    if (MyDialog.this.myProgressBar.isShowing()) {
                        int perc = (int)(fraction * 100.0);
                        MyDialog.this.myProgressBar.setIndeterminate(perc == 0 || ProgressWindow.this.isIndeterminate());
                        MyDialog.this.myProgressBar.setValue(perc);
                    }
                    MyDialog.this.myText2Label.setText(MyDialog.this.getTitle2Text(text2, MyDialog.this.myText2Label.getWidth()));
                    MyDialog.this.myTitlePanel.setText(ProgressWindow.this.myTitle != null && ProgressWindow.this.myTitle.length() > 0 ? ProgressWindow.this.myTitle : " ");
                    MyDialog.this.myLastTimeDrawn = System.currentTimeMillis();
                    MyDialog.this.myRepaintedFlag = true;
                }
            };
            this.myUpdateRequest = new Runnable(){

                @Override
                public void run() {
                    MyDialog.this.update();
                }
            };
            this.myRepaintedFlag = true;
            Window parentWindow = WindowManager.getInstance().suggestParentWindow(project);
            if (parentWindow == null) {
                parentWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
            }
            this.myParentWindow = parentWindow;
            this.initDialog(shouldShowBackground, cancelText);
        }

        public MyDialog(boolean shouldShowBackground, Component parent, String cancelText) {
            this.$$$setupUI$$$();
            this.myRepaintRunnable = new /* invalid duplicate definition of identical inner class */;
            this.myUpdateRequest = new /* invalid duplicate definition of identical inner class */;
            this.myRepaintedFlag = true;
            this.myParentWindow = parent instanceof Window ? (Window)parent : (Window)SwingUtilities.getAncestorOfClass(Window.class, parent);
            this.initDialog(shouldShowBackground, cancelText);
        }

        private void initDialog(boolean shouldShowBackground, String cancelText) {
            this.myFunPanel.setLayout(new BorderLayout());
            this.myCancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyDialog.this.doCancelAction();
                }
            });
            this.myCancelButton.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyDialog.this.myCancelButton.isEnabled()) {
                        MyDialog.this.doCancelAction();
                    }
                }
            }, KeyStroke.getKeyStroke(27, 0), 1);
            this.myShouldShowBackground = shouldShowBackground;
            if (cancelText != null) {
                ProgressWindow.this.setCancelButtonText(cancelText);
            }
            this.myProgressBar.setMaximum(100);
            this.createCenterPanel();
            this.myTitlePanel.setActive(true);
            this.myTitlePanel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Point titleOffset = RelativePoint.getNorthWestOf((JComponent)MyDialog.this.myTitlePanel).getScreenPoint();
                    MyDialog.this.myLastClicked = new RelativePoint(e).getScreenPoint();
                    ((MyDialog)MyDialog.this).myLastClicked.x -= titleOffset.x;
                    ((MyDialog)MyDialog.this).myLastClicked.y -= titleOffset.y;
                }
            });
            this.myTitlePanel.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (MyDialog.this.myLastClicked == null) {
                        return;
                    }
                    Point draggedTo = new RelativePoint(e).getScreenPoint();
                    draggedTo.x -= ((MyDialog)MyDialog.this).myLastClicked.x;
                    draggedTo.y -= ((MyDialog)MyDialog.this).myLastClicked.y;
                    if (MyDialog.this.myPopup != null) {
                        MyDialog.this.myPopup.setLocation(draggedTo);
                    }
                }
            });
        }

        public void dispose() {
            UIUtil.disposeProgress((JProgressBar)this.myProgressBar);
            UIUtil.dispose((Component)this.myTitlePanel);
        }

        public JPanel getPanel() {
            return this.myPanel;
        }

        public void setShouldShowBackground(final boolean shouldShowBackground) {
            this.myShouldShowBackground = shouldShowBackground;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyDialog.this.myBackgroundButton.setVisible(shouldShowBackground);
                    MyDialog.this.myPanel.revalidate();
                }
            });
        }

        public void changeCancelButtonText(String text) {
            this.myCancelButton.setText(text);
        }

        public void doCancelAction() {
            if (ProgressWindow.this.myShouldShowCancel) {
                ProgressWindow.this.cancel();
            }
        }

        public void cancel() {
            if (ProgressWindow.this.myShouldShowCancel) {
                this.myCancelButton.setEnabled(false);
            }
        }

        private void createCenterPanel() {
            if (ProgressWindow.this.myCancelText != null) {
                this.myCancelButton.setText(ProgressWindow.this.myCancelText);
            }
            this.myCancelButton.setVisible(ProgressWindow.this.myShouldShowCancel);
            this.myBackgroundButton.setVisible(this.myShouldShowBackground);
            this.myBackgroundButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyDialog.this.myShouldShowBackground) {
                        ProgressWindow.this.background();
                    }
                }
            });
            int width = this.myPercentLabel.getFontMetrics(this.myPercentLabel.getFont()).stringWidth("1000%");
            this.myPercentLabel.setPreferredSize(new Dimension(width, this.myPercentLabel.getPreferredSize().height));
            this.myPercentLabel.setHorizontalAlignment(4);
        }

        private synchronized void update() {
            if (this.myRepaintedFlag) {
                if (System.currentTimeMillis() > this.myLastTimeDrawn + 50L) {
                    this.myRepaintedFlag = false;
                    SwingUtilities.invokeLater(this.myRepaintRunnable);
                } else if (ProgressWindow.this.myUpdateAlarm.getActiveRequestCount() == 0) {
                    ProgressWindow.this.myUpdateAlarm.addRequest(this.myUpdateRequest, 500, ProgressWindow.this.getModalityState());
                }
            }
        }

        public synchronized void background() {
            if (this.myShouldShowBackground) {
                this.myBackgroundButton.setEnabled(false);
            }
            this.hide();
        }

        public void hide() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MyDialog.this.myPopup != null) {
                        MyDialog.this.myPopup.close(1);
                        MyDialog.this.myPopup = null;
                    }
                }
            });
        }

        public void show() {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            if (this.myParentWindow == null) {
                return;
            }
            if (this.myPopup != null) {
                this.myPopup.close(1);
            }
            this.myPopup = this.myParentWindow.isShowing() ? new MyDialogWrapper(this.myParentWindow, ProgressWindow.this.myShouldShowCancel) : new MyDialogWrapper(ProgressWindow.this.myProject, ProgressWindow.this.myShouldShowCancel);
            this.myPopup.setUndecorated(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MyDialog.this.myPopup != null) {
                        FocusTrackback focusTrackback;
                        if (MyDialog.this.myPopup.getPeer() instanceof FocusTrackbackProvider && (focusTrackback = ((FocusTrackbackProvider)MyDialog.this.myPopup.getPeer()).getFocusTrackback()) != null) {
                            focusTrackback.consume();
                        }
                        ProgressWindow.this.getFocusManager().requestFocus((Component)MyDialog.this.myCancelButton, true);
                    }
                }
            });
            this.myPopup.show();
        }

        public boolean wasShown() {
            return ProgressWindow.this.myWasShown;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TitlePanel titlePanel;
            JPanel jPanel;
            JButton jButton;
            JButton jButton2;
            JProgressBar jProgressBar;
            JLabel jLabel;
            JLabel jLabel2;
            JLabel jLabel3;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
            jPanel3.setOpaque(false);
            jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 2, null, new Dimension(450, -1), null));
            this.myTextLabel = jLabel3 = new JLabel();
            jLabel3.setText(" ");
            jPanel4.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 7, 0, new Dimension(0, -1), null, null));
            this.myText2Label = jLabel2 = new JLabel();
            jLabel2.setText("");
            jPanel4.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 1, 7, 0, new Dimension(0, -1), null, null));
            Spacer spacer = new Spacer();
            jPanel4.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myPercentLabel = jLabel = new JLabel();
            jLabel.setText(" ");
            jPanel5.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myProgressBar = jProgressBar = new JProgressBar();
            jPanel5.add((Component)jProgressBar, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel4.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 1, 2, null, null, null));
            this.myCancelButton = jButton2 = new JButton();
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/CommonBundle").getString("button.cancel"));
            jButton2.setFocusPainted(true);
            ((Component)jButton2).setEnabled(true);
            jPanel6.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myBackgroundButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/CommonBundle").getString("button.background"));
            jButton.setFocusPainted(true);
            jPanel6.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel6.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            Spacer spacer4 = new Spacer();
            jPanel6.add((Component)spacer4, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myFunPanel = jPanel = new JPanel();
            jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
            this.myTitlePanel = titlePanel = new TitlePanel();
            jPanel2.add((Component)titlePanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }

        private class MyDialogWrapper
        extends DialogWrapper {
            private boolean myIsCancellable;

            public MyDialogWrapper(Project project, boolean cancellable) {
                super(project, false);
                this.init();
                this.myIsCancellable = cancellable;
            }

            public MyDialogWrapper(Component parent, boolean cancellable) {
                super(parent, false);
                this.init();
                this.myIsCancellable = cancellable;
            }

            public void doCancelAction() {
                if (this.myIsCancellable) {
                    super.doCancelAction();
                }
            }

            protected DialogWrapperPeer createPeer(Component parent, boolean canBeParent) {
                if (System.getProperty("vintage.progress") == null) {
                    try {
                        return new GlassPaneDialogWrapperPeer((DialogWrapper)this, parent, canBeParent);
                    }
                    catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                        return super.createPeer(parent, canBeParent);
                    }
                }
                return super.createPeer(parent, canBeParent);
            }

            protected DialogWrapperPeer createPeer(boolean canBeParent, boolean toolkitModalIfPossible) {
                if (System.getProperty("vintage.progress") == null) {
                    try {
                        return new GlassPaneDialogWrapperPeer(this, canBeParent);
                    }
                    catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                        return super.createPeer(canBeParent, toolkitModalIfPossible);
                    }
                }
                return super.createPeer(canBeParent, toolkitModalIfPossible);
            }

            protected DialogWrapperPeer createPeer(Project project, boolean canBeParent) {
                if (System.getProperty("vintage.progress") == null) {
                    try {
                        return new GlassPaneDialogWrapperPeer((DialogWrapper)this, project, canBeParent);
                    }
                    catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                        return super.createPeer(project, canBeParent);
                    }
                }
                return super.createPeer(project, canBeParent);
            }

            protected void init() {
                super.init();
                this.setUndecorated(true);
                MyDialog.this.myPanel.setBorder((Border)PopupBorder.Factory.create((boolean)true));
            }

            protected boolean isProgressDialog() {
                return true;
            }

            protected JComponent createCenterPanel() {
                return MyDialog.this.myPanel;
            }

            @Nullable
            protected JComponent createSouthPanel() {
                return null;
            }

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }
        }
    }
}

