/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.conversion.impl.ConversionResultImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaProjectManagerImpl
extends ProjectManagerImpl {
    public IdeaProjectManagerImpl(VirtualFileManagerEx virtualFileManagerEx) {
        super(virtualFileManagerEx);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static ConversionResult convertProject(String filePath) throws ProcessCanceledException {
        ConversionResult conversionResult;
        String fp = IdeaProjectManagerImpl.canonicalize(filePath);
        File f = new File(fp);
        if (fp != null && f.exists() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            conversionResult = ConversionService.getInstance().convert(fp);
            if (conversionResult == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/IdeaProjectManagerImpl.convertProject must not return null");
            return conversionResult;
        }
        conversionResult = ConversionResultImpl.CONVERSION_NOT_NEEDED;
        if (conversionResult != null) return conversionResult;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/IdeaProjectManagerImpl.convertProject must not return null");
    }

    @Override
    @Nullable
    protected Project convertAndLoadProject(String filePath, boolean convert) throws IOException {
        Project project;
        ConversionResult conversionResult;
        if (convert) {
            conversionResult = IdeaProjectManagerImpl.convertProject(filePath);
            if (conversionResult.openingIsCanceled()) {
                return null;
            }
        } else {
            conversionResult = null;
        }
        if ((project = this.loadProjectWithProgress(filePath)) == null) {
            return null;
        }
        if (conversionResult != null && !conversionResult.conversionNotNeeded()) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    conversionResult.postStartupActivity(project);
                }
            });
        }
        return project;
    }
}

