/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactTypeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;

public class ArtifactConfigurable
extends ProjectStructureElementConfigurable<Artifact> {
    private final Artifact myOriginalArtifact;
    private final ArtifactsStructureConfigurableContext myArtifactsStructureContext;
    private final ArtifactEditorImpl myEditor;
    private boolean myIsInUpdateName;
    private ProjectStructureElement myProjectStructureElement;

    public ArtifactConfigurable(Artifact originalArtifact, ArtifactsStructureConfigurableContextImpl artifactsStructureContext, Runnable updateTree) {
        super(true, updateTree);
        this.myOriginalArtifact = originalArtifact;
        this.myArtifactsStructureContext = artifactsStructureContext;
        this.myEditor = artifactsStructureContext.getOrCreateEditor(originalArtifact);
        this.myProjectStructureElement = this.myArtifactsStructureContext.getOrCreateArtifactElement(this.myOriginalArtifact);
    }

    public void setDisplayName(String name) {
        String oldName = this.getArtifact().getName();
        if (name != null && !name.equals(oldName) && !this.myIsInUpdateName) {
            this.myArtifactsStructureContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.myOriginalArtifact).setName(name);
            this.myEditor.updateOutputPath(oldName, name);
        }
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateName() {
        this.myIsInUpdateName = true;
        try {
            super.updateName();
        }
        finally {
            this.myIsInUpdateName = false;
        }
    }

    private Artifact getArtifact() {
        return this.myArtifactsStructureContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
    }

    public Artifact getEditableObject() {
        return this.getArtifact();
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"banner.slogan.artifact.0", (Object[])new Object[]{this.getDisplayName()});
    }

    public JComponent createOptionsPanel() {
        return this.myEditor.createMainComponent();
    }

    @Nls
    public String getDisplayName() {
        return this.getArtifact().getName();
    }

    public Icon getIcon() {
        return this.getArtifact().getArtifactType().getIcon();
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.artifacts";
    }

    protected JComponent createTopRightComponent() {
        final ComboBox artifactTypeBox = new ComboBox();
        for (ArtifactType type : ArtifactType.getAllTypes()) {
            artifactTypeBox.addItem((Object)type);
        }
        artifactTypeBox.setRenderer((ListCellRenderer)new ArtifactTypeCellRenderer());
        artifactTypeBox.setSelectedItem((Object)this.getArtifact().getArtifactType());
        artifactTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArtifactType selected = (ArtifactType)artifactTypeBox.getSelectedItem();
                if (selected != null && !Comparing.equal((Object)selected, (Object)ArtifactConfigurable.this.getArtifact().getArtifactType())) {
                    ArtifactConfigurable.this.myEditor.setArtifactType(selected);
                }
            }
        });
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(new JLabel("Type: "));
        panel.add((Component)artifactTypeBox);
        return panel;
    }

    public boolean isModified() {
        return this.myEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myEditor.apply();
    }

    public void reset() {
    }

    public void disposeUIResources() {
    }
}

