/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectLibrariesConfigurable.UI", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class ProjectLibrariesConfigurable
extends BaseLibrariesConfigurable {
    public ProjectLibrariesConfigurable(Project project) {
        super(project);
        this.myLevel = "project";
    }

    @Nls
    public String getDisplayName() {
        return "Libraries";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NonNls
    public String getId() {
        return "project.libraries";
    }

    @Override
    public LibraryTableModifiableModelProvider getModelProvider(boolean editable) {
        return this.myContext.getProjectLibrariesProvider(editable);
    }

    @Override
    public BaseLibrariesConfigurable getOppositeGroup() {
        return GlobalLibrariesConfigurable.getInstance(this.myProject);
    }

    public static ProjectLibrariesConfigurable getInstance(Project project) {
        return (ProjectLibrariesConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, ProjectLibrariesConfigurable.class);
    }

    @Override
    protected String getAddText() {
        return ProjectBundle.message((String)"add.new.project.library.text", (Object[])new Object[0]);
    }
}

