/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AsyncUpdateAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsAction
extends AsyncUpdateAction<VcsContext>
implements DumbAware {
    public static Collection<AbstractVcs> getActiveVcses(VcsContext dataContext) {
        HashSet result = new HashSet();
        Project project = dataContext.getProject();
        if (project != null) {
            Collections.addAll(result, ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss());
        }
        return result;
    }

    @NotNull
    protected static FilePath[] filterDescindingFiles(@NotNull FilePath[] roots, Project project) {
        if (roots == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/actions/AbstractVcsAction.filterDescindingFiles must not be null");
        }
        FilePath[] filePathArray = DescindingFilesFilter.filterDescindingFiles(roots, project, null);
        if (filePathArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/actions/AbstractVcsAction.filterDescindingFiles must not return null");
        }
        return filePathArray;
    }

    protected VcsContext prepareDataFromContext(AnActionEvent e) {
        return this.forceSyncUpdate(e) ? VcsContextWrapper.createInstanceOn(e) : VcsContextWrapper.createCachedInstanceOn(e);
    }

    protected void performUpdate(final Presentation presentation, final VcsContext data) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                AbstractVcsAction.this.update(data, presentation);
            }
        });
    }

    public final void actionPerformed(AnActionEvent e) {
        this.actionPerformed(VcsContextWrapper.createCachedInstanceOn(e));
    }

    protected abstract void actionPerformed(VcsContext var1);

    protected abstract void update(VcsContext var1, Presentation var2);
}

