/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.NewChangelistDialog;

public class AddChangeListAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        NewChangelistDialog dlg = new NewChangelistDialog(project);
        dlg.show();
        if (dlg.getExitCode() == 0) {
            String name = dlg.getName();
            if (name.length() == 0) {
                name = AddChangeListAction.getUniqueName(project);
            }
            LocalChangeList list = ChangeListManager.getInstance((Project)project).addChangeList(name, dlg.getDescription());
            if (dlg.isNewChangelistActive()) {
                ChangeListManager.getInstance((Project)project).setDefaultChangeList(list);
            }
            dlg.getPanel().changelistCreatedOrChanged(list);
        }
    }

    private static String getUniqueName(Project project) {
        int unnamedcount = 0;
        for (LocalChangeList list : ChangeListManagerImpl.getInstanceImpl(project).getChangeListsCopy()) {
            if (!list.getName().startsWith("Unnamed")) continue;
            ++unnamedcount;
        }
        return unnamedcount == 0 ? "Unnamed" : "Unnamed (" + unnamedcount + ")";
    }

    public void update(AnActionEvent e) {
        if (e.getPlace().equals("ChangesViewPopup")) {
            ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
            e.getPresentation().setVisible(lists != null && lists.length > 0);
        }
    }
}

