/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.SelectedFilesHelper;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MoveChangesToAnotherListAction
extends AnAction
implements DumbAware {
    public MoveChangesToAnotherListAction() {
        super(ActionsBundle.actionText((String)"ChangesView.Move"), ActionsBundle.actionDescription((String)"ChangesView.Move"), IconLoader.getIcon((String)"/actions/fileStatus.png"));
    }

    public void update(AnActionEvent e) {
        boolean isEnabled = MoveChangesToAnotherListAction.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(isEnabled);
        } else {
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        List unversionedFiles = (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
            return true;
        }
        boolean hasChangedOrUnversionedFiles = SelectedFilesHelper.hasChangedOrUnversionedFiles(project, e);
        if (hasChangedOrUnversionedFiles) {
            return true;
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        return changes != null && changes.length > 0;
    }

    @Nullable
    private static Change[] getChangesForSelectedFiles(Project project, Change[] changes, List<VirtualFile> unversionedFiles, @Nullable List<VirtualFile> changedFiles, AnActionEvent e) {
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length == 0) {
            return null;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFiles != null) {
            ArrayList<Change> changesInFiles = new ArrayList<Change>();
            for (VirtualFile vFile : virtualFiles) {
                Change change = ChangeListManager.getInstance((Project)project).getChange(vFile);
                if (change == null) continue;
                if (change.getFileStatus().equals(FileStatus.UNKNOWN)) {
                    unversionedFiles.add(vFile);
                    if (changedFiles == null) continue;
                    changedFiles.add(vFile);
                    continue;
                }
                changesInFiles.add(change);
                if (changedFiles == null) continue;
                changedFiles.add(vFile);
            }
            if (changesInFiles.size() > 0 || unversionedFiles.size() > 0) {
                changes = changesInFiles.toArray(new Change[changesInFiles.size()]);
            }
        }
        return changes;
    }

    public void actionPerformed(AnActionEvent e) {
        ToolWindow window;
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        ArrayList<VirtualFile> unversionedFiles = (ArrayList<VirtualFile>)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        final ArrayList<VirtualFile> changedFiles = new ArrayList<VirtualFile>();
        boolean activateChangesView = false;
        if (project != null && changes == null && unversionedFiles == null) {
            unversionedFiles = new ArrayList<VirtualFile>();
            changes = MoveChangesToAnotherListAction.getChangesForSelectedFiles(project, changes, unversionedFiles, changedFiles, e);
            activateChangesView = true;
        }
        if (changes == null) {
            return;
        }
        if (!MoveChangesToAnotherListAction.askAndMove(project, changes, (List<VirtualFile>)unversionedFiles)) {
            return;
        }
        if (activateChangesView && !(window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID)).isVisible()) {
            window.activate(new Runnable(){

                @Override
                public void run() {
                    if (changedFiles.size() > 0) {
                        ChangesViewManager.getInstance(project).selectFile((VirtualFile)changedFiles.get(0));
                    }
                }
            });
        }
    }

    public static boolean askAndMove(Project project, Change[] changes, List<VirtualFile> unversionedFiles) {
        ChangeListManagerImpl listManager = ChangeListManagerImpl.getInstanceImpl(project);
        List<LocalChangeList> lists = listManager.getChangeLists();
        ChangeListChooser chooser = new ChangeListChooser(project, MoveChangesToAnotherListAction.getPreferredLists(lists, changes, true), MoveChangesToAnotherListAction.guessPreferredList(lists, changes), VcsBundle.message((String)"changes.changelist.chooser.title", (Object[])new Object[0]), null);
        chooser.show();
        LocalChangeList resultList = chooser.getSelectedList();
        if (resultList != null) {
            listManager.moveChangesTo(resultList, changes);
            if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
                listManager.addUnversionedFiles(resultList, unversionedFiles);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static ChangeList guessPreferredList(List<LocalChangeList> lists, Change[] changes) {
        List<LocalChangeList> preferredLists = MoveChangesToAnotherListAction.getPreferredLists(lists, changes, false);
        for (LocalChangeList preferredList : preferredLists) {
            if (!preferredList.getChanges().isEmpty()) continue;
            return preferredList;
        }
        if (preferredLists.size() > 0) {
            return (ChangeList)preferredLists.get(0);
        }
        return null;
    }

    private static List<LocalChangeList> getPreferredLists(List<LocalChangeList> lists, Change[] changes, boolean includeDefaultIfEmpty) {
        ArrayList<LocalChangeList> preferredLists = new ArrayList<LocalChangeList>(lists);
        THashSet changesAsSet = new THashSet(Arrays.asList(changes));
        block0: for (LocalChangeList list : lists) {
            for (Change change : list.getChanges()) {
                if (!changesAsSet.contains(change)) continue;
                preferredLists.remove(list);
                continue block0;
            }
        }
        if (preferredLists.isEmpty() && includeDefaultIfEmpty) {
            for (LocalChangeList list : lists) {
                if (!list.isDefault()) continue;
                preferredLists.add(list);
            }
        }
        return preferredLists;
    }
}

