/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManagerQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CachesHolder;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.changes.committed.ChangesCacheFile;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedListsSequencesZipper;
import com.intellij.openapi.vcs.changes.committed.CompositeCommittedChangesProvider;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipperAdapter;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="CommittedChangesCache", roamingType=RoamingType.DISABLED, storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class CommittedChangesCache
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.CommittedChangesCache");
    private final Project myProject;
    private final MessageBus myBus;
    private final ProgressManagerQueue myTaskQueue;
    private boolean myRefreshingIncomingChanges = false;
    private int myPendingUpdateCount = 0;
    private State myState = new State();
    private ScheduledFuture myFuture;
    private List<CommittedChangeList> myCachedIncomingChangeLists;
    private final Set<CommittedChangeList> myNewIncomingChanges = new LinkedHashSet<CommittedChangeList>();
    private final ProjectLevelVcsManager myVcsManager;
    public static final Change[] ALL_CHANGES = new Change[0];
    private MyRefreshRunnable myRefresnRunnable;
    private final Map<String, Pair<Long, List<CommittedChangeList>>> myExternallyLoadedChangeLists;
    private final CachesHolder myCachesHolder;
    private final RepositoryLocationCache myLocationCache;
    public static final Topic<CommittedChangesListener> COMMITTED_TOPIC = new Topic("committed changes updates", CommittedChangesListener.class);

    public static CommittedChangesCache getInstance(Project project) {
        return (CommittedChangesCache)project.getComponent(CommittedChangesCache.class);
    }

    public CommittedChangesCache(Project project, MessageBus bus, ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myBus = bus;
        this.myLocationCache = new RepositoryLocationCache(project);
        this.myCachesHolder = new CachesHolder(project, this.myLocationCache);
        this.myTaskQueue = new ProgressManagerQueue(project, VcsBundle.message((String)"committed.changes.refresh.progress", (Object[])new Object[0]));
        this.myVcsManager = vcsManager;
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                CommittedChangesCache.this.cancelRefreshTimer();
            }
        });
        this.myExternallyLoadedChangeLists = new ConcurrentHashMap();
    }

    public MessageBus getMessageBus() {
        return this.myBus;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
        this.updateRefreshTimer();
    }

    @Nullable
    public CommittedChangesProvider getProviderForProject() {
        AbstractVcs[] vcss = this.myVcsManager.getAllActiveVcss();
        ArrayList<AbstractVcs> vcsWithProviders = new ArrayList<AbstractVcs>();
        for (AbstractVcs vcs : vcss) {
            if (vcs.getCommittedChangesProvider() == null) continue;
            vcsWithProviders.add(vcs);
        }
        if (vcsWithProviders.isEmpty()) {
            return null;
        }
        if (vcsWithProviders.size() == 1) {
            return ((AbstractVcs)vcsWithProviders.get(0)).getCommittedChangesProvider();
        }
        return new CompositeCommittedChangesProvider(this.myProject, vcsWithProviders.toArray(new AbstractVcs[vcsWithProviders.size()]));
    }

    public boolean isMaxCountSupportedForProject() {
        for (AbstractVcs vcs : this.myVcsManager.getAllActiveVcss()) {
            CachingCommittedChangesProvider cachingProvider;
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (!(provider instanceof CachingCommittedChangesProvider) || (cachingProvider = (CachingCommittedChangesProvider)provider).isMaxCountSupported()) continue;
            return false;
        }
        return true;
    }

    public void getProjectChangesAsync(ChangeBrowserSettings settings, int maxCount, boolean cacheOnly, Consumer<List<CommittedChangeList>> consumer, Consumer<List<VcsException>> errorConsumer) {
        MyProjectChangesLoader loader = new MyProjectChangesLoader(settings, maxCount, cacheOnly, consumer, errorConsumer);
        this.myTaskQueue.run((Object)loader);
    }

    @Nullable
    public List<CommittedChangeList> getChanges(ChangeBrowserSettings settings, VirtualFile file, @NotNull AbstractVcs vcs, int maxCount, boolean cacheOnly, CommittedChangesProvider provider, RepositoryLocation location) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vcs/changes/committed/CommittedChangesCache.getChanges must not be null");
        }
        if (settings instanceof CompositeCommittedChangesProvider.CompositeChangeBrowserSettings) {
            settings = ((CompositeCommittedChangesProvider.CompositeChangeBrowserSettings)settings).get(vcs);
        }
        if (provider instanceof CachingCommittedChangesProvider) {
            try {
                if (cacheOnly) {
                    ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, file, location);
                    if (!cacheFile.isEmpty()) {
                        return cacheFile.readChanges(settings, maxCount);
                    }
                    return null;
                }
                if (this.canGetFromCache(vcs, settings, file, location, maxCount)) {
                    return this.getChangesWithCaching(vcs, settings, file, location, maxCount);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return provider.getCommittedChanges(settings, location, maxCount);
    }

    private boolean canGetFromCache(AbstractVcs vcs, ChangeBrowserSettings settings, VirtualFile root, RepositoryLocation location, int maxCount) throws IOException {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        if (cacheFile.isEmpty()) {
            return true;
        }
        if (settings.USE_DATE_BEFORE_FILTER && !settings.USE_DATE_AFTER_FILTER) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_CHANGE_BEFORE_FILTER && !settings.USE_CHANGE_AFTER_FILTER) {
            return cacheFile.hasCompleteHistory();
        }
        boolean hasDateFilter = settings.USE_DATE_AFTER_FILTER || settings.USE_DATE_BEFORE_FILTER || settings.USE_CHANGE_AFTER_FILTER || settings.USE_CHANGE_BEFORE_FILTER;
        boolean hasNonDateFilter = settings.isNonDateFilterSpecified();
        if (!hasDateFilter && hasNonDateFilter) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_DATE_AFTER_FILTER && settings.getDateAfter().getTime() < cacheFile.getFirstCachedDate().getTime()) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_CHANGE_AFTER_FILTER && settings.getChangeAfterFilter() < cacheFile.getFirstCachedChangelist()) {
            return cacheFile.hasCompleteHistory();
        }
        return true;
    }

    public void hasCachesForAnyRoot(final @Nullable Consumer<Boolean> continuation) {
        this.myTaskQueue.run((Object)new Runnable(){

            @Override
            public void run() {
                final Ref success = new Ref();
                try {
                    success.set((Object)CommittedChangesCache.this.hasCachesWithEmptiness(false));
                }
                catch (ProcessCanceledException e) {
                    success.set((Object)true);
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        continuation.consume(success.get());
                    }
                }, CommittedChangesCache.this.myProject.getDisposed());
            }
        });
    }

    public boolean hasEmptyCaches() {
        try {
            return this.hasCachesWithEmptiness(true);
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    private boolean hasCachesWithEmptiness(final boolean emptiness) {
        final Ref resultRef = new Ref((Object)Boolean.FALSE);
        this.myCachesHolder.iterateAllCaches(new NotNullFunction<ChangesCacheFile, Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @NotNull
            public Boolean fun(ChangesCacheFile changesCacheFile) {
                Boolean bl;
                block6: {
                    Boolean bl2;
                    try {
                        if (changesCacheFile.isEmpty() != emptiness) break block6;
                        resultRef.set((Object)true);
                        bl2 = true;
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                        break block6;
                    }
                    bl = bl2;
                    if (bl2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/CommittedChangesCache$3.fun must not return null");
                    return bl;
                }
                if ((bl = Boolean.valueOf(false)) != null) return bl;
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/CommittedChangesCache$3.fun must not return null");
            }
        });
        return (Boolean)resultRef.get();
    }

    @Nullable
    public Iterator<ChangesBunch> getBackBunchedIterator(AbstractVcs vcs, VirtualFile root, RepositoryLocation location, int bunchSize) {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        try {
            if (!cacheFile.isEmpty()) {
                return cacheFile.getBackBunchedIterator(bunchSize);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private List<CommittedChangeList> getChangesWithCaching(AbstractVcs vcs, ChangeBrowserSettings settings, VirtualFile root, RepositoryLocation location, int maxCount) throws VcsException, IOException {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        if (cacheFile.isEmpty()) {
            List<CommittedChangeList> changes = this.initCache(cacheFile);
            if (this.canGetFromCache(vcs, settings, root, location, maxCount)) {
                settings.filterChanges(changes);
                return CommittedChangesCache.trimToSize(changes, maxCount);
            }
            return cacheFile.getProvider().getCommittedChanges(settings, location, maxCount);
        }
        List<CommittedChangeList> changes = cacheFile.readChanges(settings, maxCount);
        List<CommittedChangeList> newChanges = this.refreshCache(cacheFile);
        settings.filterChanges(newChanges);
        changes.addAll(newChanges);
        return CommittedChangesCache.trimToSize(changes, maxCount);
    }

    public void refreshAllCaches() throws IOException, VcsException {
        List<ChangesCacheFile> files = this.myCachesHolder.getAllCaches();
        for (ChangesCacheFile file : files) {
            if (file.isEmpty()) {
                this.initCache(file);
                continue;
            }
            this.refreshCache(file);
        }
    }

    private List<CommittedChangeList> initCache(ChangesCacheFile cacheFile) throws VcsException, IOException {
        CommittedChangesCache.debug("Initializing cache for " + cacheFile.getLocation());
        CachingCommittedChangesProvider provider = cacheFile.getProvider();
        RepositoryLocation location = cacheFile.getLocation();
        ChangeBrowserSettings settings = provider.createDefaultSettings();
        int maxCount = 0;
        if (this.isMaxCountSupportedForProject()) {
            maxCount = this.myState.getInitialCount();
        } else {
            settings.USE_DATE_AFTER_FILTER = true;
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -this.myState.getInitialDays());
            settings.setDateAfter(calendar.getTime());
        }
        List changes = provider.getCommittedChanges(settings, location, maxCount);
        CommittedChangesCache.writeChangesInReadAction(cacheFile, changes);
        if (maxCount > 0 && changes.size() < this.myState.getInitialCount()) {
            cacheFile.setHaveCompleteHistory(true);
        }
        if (changes.size() > 0) {
            ((CommittedChangesListener)this.myBus.syncPublisher(COMMITTED_TOPIC)).changesLoaded(location, changes);
        }
        return changes;
    }

    private List<CommittedChangeList> refreshCache(ChangesCacheFile cacheFile) throws VcsException, IOException {
        ArrayList<CommittedChangeList> newLists = new ArrayList<CommittedChangeList>();
        CachingCommittedChangesProvider provider = cacheFile.getProvider();
        RepositoryLocation location = cacheFile.getLocation();
        Pair<Long, List<CommittedChangeList>> externalLists = this.myExternallyLoadedChangeLists.get(location.getKey());
        long latestChangeList = this.getLatestListForFile(cacheFile);
        if (externalLists != null && latestChangeList == (Long)externalLists.first) {
            newLists.addAll(this.appendLoadedChanges(cacheFile, location, (List)externalLists.second));
            this.myExternallyLoadedChangeLists.clear();
        }
        ChangeBrowserSettings defaultSettings = provider.createDefaultSettings();
        int maxCount = 0;
        if (provider.refreshCacheByNumber()) {
            long number = cacheFile.getLastCachedChangelist();
            CommittedChangesCache.debug("Refreshing cache for " + location + " since #" + number);
            if (number >= 0L) {
                defaultSettings.CHANGE_AFTER = Long.toString(number);
                defaultSettings.USE_CHANGE_AFTER_FILTER = true;
            } else {
                maxCount = this.myState.getInitialCount();
            }
        } else {
            Date date = cacheFile.getLastCachedDate();
            CommittedChangesCache.debug("Refreshing cache for " + location + " since " + date);
            defaultSettings.setDateAfter(date);
            defaultSettings.USE_DATE_AFTER_FILTER = true;
        }
        List newChanges = provider.getCommittedChanges(defaultSettings, location, maxCount);
        CommittedChangesCache.debug("Loaded " + newChanges.size() + " new changelists");
        newLists.addAll(this.appendLoadedChanges(cacheFile, location, newChanges));
        return newLists;
    }

    private static void debug(@NonNls String message) {
        LOG.debug(message);
    }

    private List<CommittedChangeList> appendLoadedChanges(ChangesCacheFile cacheFile, RepositoryLocation location, List<CommittedChangeList> newChanges) throws IOException {
        List<CommittedChangeList> savedChanges = CommittedChangesCache.writeChangesInReadAction(cacheFile, newChanges);
        if (savedChanges.size() > 0) {
            ((CommittedChangesListener)this.myBus.syncPublisher(COMMITTED_TOPIC)).changesLoaded(location, savedChanges);
        }
        return savedChanges;
    }

    private static List<CommittedChangeList> writeChangesInReadAction(final ChangesCacheFile cacheFile, final List<CommittedChangeList> newChanges) throws IOException {
        for (CommittedChangeList changeList : newChanges) {
            changeList.getChanges();
        }
        final Ref ref = new Ref();
        List savedChanges = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<CommittedChangeList>>(){

            public List<CommittedChangeList> compute() {
                try {
                    return cacheFile.writeChanges(newChanges);
                }
                catch (IOException e) {
                    ref.set((Object)e);
                    return null;
                }
            }
        });
        if (!ref.isNull()) {
            throw (IOException)ref.get();
        }
        return savedChanges;
    }

    private static List<CommittedChangeList> trimToSize(List<CommittedChangeList> changes, int maxCount) {
        if (maxCount > 0) {
            while (changes.size() > maxCount) {
                changes.remove(0);
            }
        }
        return changes;
    }

    private List<CommittedChangeList> loadIncomingChanges(boolean inBackground) {
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        List<ChangesCacheFile> caches = this.myCachesHolder.getAllCaches();
        MultiMap byVcs = new MultiMap();
        for (ChangesCacheFile cache : caches) {
            try {
                if (inBackground && !cache.getVcs().isVcsBackgroundOperationsAllowed(cache.getRootPath().getVirtualFile()) || cache.isEmpty()) continue;
                CommittedChangesCache.debug("Loading incoming changes for " + cache.getLocation());
                List<CommittedChangeList> incomingChanges = cache.loadIncomingChanges();
                byVcs.putValue((Object)cache.getVcs(), (Object)new Pair((Object)cache.getLocation(), incomingChanges));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        for (AbstractVcs vcs : byVcs.keySet()) {
            CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
            VcsCommittedListsZipper vcsZipper = committedChangesProvider.getZipper();
            if (vcsZipper != null) {
                IncomingListsZipper incomingZipper = new IncomingListsZipper(vcsZipper);
                CommittedListsSequencesZipper zipper = new CommittedListsSequencesZipper((VcsCommittedListsZipper)incomingZipper);
                for (Pair pair : byVcs.get((Object)vcs)) {
                    zipper.add((RepositoryLocation)pair.getFirst(), (List)pair.getSecond());
                }
                result.addAll(zipper.execute());
                continue;
            }
            for (Pair pair : byVcs.get((Object)vcs)) {
                result.addAll((Collection)pair.getSecond());
            }
        }
        this.myCachedIncomingChangeLists = result;
        CommittedChangesCache.debug("Incoming changes loaded");
        this.notifyIncomingChangesUpdated(null);
        return result;
    }

    public void loadIncomingChangesAsync(final @Nullable Consumer<List<CommittedChangeList>> consumer, final boolean inBackground) {
        CommittedChangesCache.debug("Loading incoming changes");
        Runnable task = new Runnable(){

            @Override
            public void run() {
                List list = CommittedChangesCache.this.loadIncomingChanges(inBackground);
                if (consumer != null) {
                    consumer.consume(new ArrayList(list));
                }
            }
        };
        this.myTaskQueue.run((Object)task);
    }

    @Nullable
    public List<CommittedChangeList> getCachedIncomingChanges() {
        return this.myCachedIncomingChangeLists;
    }

    public void processUpdatedFiles(final UpdatedFiles updatedFiles) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                CommittedChangesCache.debug("Processing updated files");
                List<ChangesCacheFile> caches = CommittedChangesCache.this.myCachesHolder.getAllCaches();
                for (ChangesCacheFile cache : caches) {
                    CommittedChangesCache.this.myPendingUpdateCount++;
                    try {
                        if (cache.isEmpty()) {
                            CommittedChangesCache.this.pendingUpdateProcessed();
                            continue;
                        }
                        CommittedChangesCache.debug("Processing updated files in " + cache.getLocation());
                        boolean needRefresh = cache.processUpdatedFiles(updatedFiles, CommittedChangesCache.this.myNewIncomingChanges);
                        if (needRefresh) {
                            CommittedChangesCache.debug("Found unaccounted files, requesting refresh");
                            CommittedChangesCache.this.processUpdatedFilesAfterRefresh(cache, updatedFiles);
                            continue;
                        }
                        CommittedChangesCache.debug("Clearing cached incoming changelists");
                        CommittedChangesCache.this.myCachedIncomingChangeLists = null;
                        CommittedChangesCache.this.pendingUpdateProcessed();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        };
        this.myTaskQueue.run((Object)task);
    }

    private void pendingUpdateProcessed() {
        --this.myPendingUpdateCount;
        if (this.myPendingUpdateCount == 0) {
            this.notifyIncomingChangesUpdated(this.myNewIncomingChanges);
            this.myNewIncomingChanges.clear();
        }
    }

    private void processUpdatedFilesAfterRefresh(final ChangesCacheFile cache, final UpdatedFiles updatedFiles) {
        this.refreshCacheAsync(cache, false, new RefreshResultConsumer(){

            @Override
            public void receivedChanges(List<CommittedChangeList> committedChangeLists) {
                try {
                    CommittedChangesCache.debug("Processing updated files after refresh in " + cache.getLocation());
                    boolean result = true;
                    if (committedChangeLists.size() > 0) {
                        result = cache.processUpdatedFiles(updatedFiles, CommittedChangesCache.this.myNewIncomingChanges);
                    }
                    CommittedChangesCache.debug(result ? "Still have unaccounted files" : "No more unaccounted files");
                    if (result) {
                        cache.refreshIncomingChanges();
                        CommittedChangesCache.debug("Clearing cached incoming changelists");
                        CommittedChangesCache.this.myCachedIncomingChangeLists = null;
                    }
                    CommittedChangesCache.this.pendingUpdateProcessed();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (VcsException e) {
                    CommittedChangesCache.this.notifyRefreshError(e);
                }
            }

            @Override
            public void receivedError(VcsException ex) {
                CommittedChangesCache.this.notifyRefreshError(ex);
            }
        });
    }

    private void notifyIncomingChangesUpdated(@Nullable Collection<CommittedChangeList> receivedChanges) {
        ArrayList<CommittedChangeList> listCopy = receivedChanges == null ? null : new ArrayList<CommittedChangeList>(receivedChanges);
        ((CommittedChangesListener)this.myBus.syncPublisher(COMMITTED_TOPIC)).incomingChangesUpdated(listCopy);
    }

    private void notifyRefreshError(VcsException e) {
        ((CommittedChangesListener)this.myBus.syncPublisher(COMMITTED_TOPIC)).refreshErrorStatusChanged(e);
    }

    public boolean isRefreshingIncomingChanges() {
        return this.myRefreshingIncomingChanges;
    }

    public boolean refreshIncomingChanges() {
        boolean hasChanges = false;
        List<ChangesCacheFile> caches = this.myCachesHolder.getAllCaches();
        for (ChangesCacheFile file : caches) {
            try {
                if (file.isEmpty()) continue;
                CommittedChangesCache.debug("Refreshing incoming changes for " + file.getLocation());
                boolean changesForCache = file.refreshIncomingChanges();
                hasChanges |= changesForCache;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (VcsException e) {
                this.notifyRefreshError(e);
            }
        }
        return hasChanges;
    }

    public void refreshIncomingChangesAsync() {
        CommittedChangesCache.debug("Refreshing incoming changes in background");
        this.myRefreshingIncomingChanges = true;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                CommittedChangesCache.this.refreshIncomingChanges();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommittedChangesCache.this.myRefreshingIncomingChanges = false;
                        CommittedChangesCache.debug("Incoming changes refresh complete, clearing cached incoming changes");
                        CommittedChangesCache.this.notifyReloadIncomingChanges();
                    }
                }, ModalityState.NON_MODAL);
            }
        };
        this.myTaskQueue.run((Object)task);
    }

    public void refreshAllCachesAsync(final boolean initIfEmpty, final boolean inBackground) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                final List<ChangesCacheFile> files = CommittedChangesCache.this.myCachesHolder.getAllCaches();
                RefreshResultConsumer notifyConsumer = new RefreshResultConsumer(){
                    private VcsException myError = null;
                    private int myCount = 0;

                    @Override
                    public void receivedChanges(List<CommittedChangeList> changes) {
                        if (changes.size() > 0) {
                            CommittedChangesCache.this.notifyReloadIncomingChanges();
                        } else {
                            ((CommittedChangesTreeBrowser.CommittedChangesReloadListener)CommittedChangesCache.this.myProject.getMessageBus().syncPublisher(CommittedChangesTreeBrowser.ITEMS_RELOADED)).emptyRefresh();
                        }
                        this.checkDone();
                    }

                    @Override
                    public void receivedError(VcsException ex) {
                        this.myError = ex;
                        this.checkDone();
                    }

                    private void checkDone() {
                        ++this.myCount;
                        if (this.myCount == files.size()) {
                            CommittedChangesCache.this.notifyRefreshError(this.myError);
                        }
                    }
                };
                for (ChangesCacheFile file : files) {
                    if (inBackground && !file.getVcs().isVcsBackgroundOperationsAllowed(file.getRootPath().getVirtualFile())) continue;
                    CommittedChangesCache.this.refreshCacheAsync(file, initIfEmpty, notifyConsumer, false);
                }
            }
        };
        this.myTaskQueue.run((Object)task);
    }

    private void notifyReloadIncomingChanges() {
        this.myCachedIncomingChangeLists = null;
        this.notifyIncomingChangesUpdated(null);
    }

    private void refreshCacheAsync(ChangesCacheFile cache, boolean initIfEmpty, @Nullable RefreshResultConsumer consumer) {
        this.refreshCacheAsync(cache, initIfEmpty, consumer, true);
    }

    private void refreshCacheAsync(final ChangesCacheFile cache, final boolean initIfEmpty, final @Nullable RefreshResultConsumer consumer, boolean asynch) {
        try {
            if (!initIfEmpty && cache.isEmpty()) {
                return;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        List list = initIfEmpty && cache.isEmpty() ? CommittedChangesCache.this.initCache(cache) : CommittedChangesCache.this.refreshCache(cache);
                        if (consumer != null) {
                            consumer.receivedChanges(list);
                        }
                    }
                    catch (ProcessCanceledException ex) {
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (VcsException e) {
                        if (consumer == null) break block5;
                        consumer.receivedError(e);
                    }
                }
            }
        };
        if (asynch) {
            this.myTaskQueue.run((Object)task);
        } else {
            task.run();
        }
    }

    private void updateRefreshTimer() {
        this.cancelRefreshTimer();
        if (this.myState.isRefreshEnabled()) {
            this.myRefresnRunnable = new MyRefreshRunnable(this);
            this.myFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(this.myRefresnRunnable, this.myState.getRefreshInterval() * 60, this.myState.getRefreshInterval() * 60, TimeUnit.SECONDS);
        }
    }

    private void cancelRefreshTimer() {
        if (this.myRefresnRunnable != null) {
            this.myRefresnRunnable.cancel();
            this.myRefresnRunnable = null;
        }
        if (this.myFuture != null) {
            this.myFuture.cancel(false);
            this.myFuture = null;
        }
    }

    @Nullable
    public Pair<CommittedChangeList, Change> getIncomingChangeList(VirtualFile file) {
        if (this.myCachedIncomingChangeLists != null) {
            File ioFile = new File(file.getPath());
            for (CommittedChangeList changeList : this.myCachedIncomingChangeLists) {
                for (Change change : changeList.getChanges()) {
                    if (!change.affectsFile(ioFile)) continue;
                    return Pair.create((Object)changeList, (Object)change);
                }
            }
        }
        return null;
    }

    private long getLatestListForFile(ChangesCacheFile file) {
        try {
            if (file == null || file.isEmpty()) {
                return -1L;
            }
            return file.getLastCachedChangelist();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public CachesHolder getCachesHolder() {
        return this.myCachesHolder;
    }

    public void submitExternallyLoaded(RepositoryLocation location, long myLastCl, List<CommittedChangeList> lists) {
        this.myExternallyLoadedChangeLists.put(location.getKey(), (Pair<Long, List<CommittedChangeList>>)new Pair((Object)myLastCl, lists));
    }

    public RepositoryLocationCache getLocationCache() {
        return this.myLocationCache;
    }

    private static class MyRefreshRunnable
    implements Runnable {
        private CommittedChangesCache myCache;

        private MyRefreshRunnable(CommittedChangesCache cache) {
            this.myCache = cache;
        }

        private void cancel() {
            this.myCache = null;
        }

        @Override
        public void run() {
            CommittedChangesCache cache = this.myCache;
            if (cache == null) {
                return;
            }
            cache.refreshAllCachesAsync(false, true);
            List<ChangesCacheFile> list = cache.getCachesHolder().getAllCaches();
            for (ChangesCacheFile file : list) {
                if (!file.getVcs().isVcsBackgroundOperationsAllowed(file.getRootPath().getVirtualFile()) || !file.getProvider().refreshIncomingWithCommitted()) continue;
                cache.refreshIncomingChangesAsync();
                break;
            }
        }
    }

    private static interface RefreshResultConsumer {
        public void receivedChanges(List<CommittedChangeList> var1);

        public void receivedError(VcsException var1);
    }

    private class IncomingListsZipper
    extends VcsCommittedListsZipperAdapter {
        private final VcsCommittedListsZipper myVcsZipper;

        private IncomingListsZipper(VcsCommittedListsZipper vcsZipper) {
            super(null);
            this.myVcsZipper = vcsZipper;
        }

        public Pair<List<RepositoryLocationGroup>, List<RepositoryLocation>> groupLocations(List<RepositoryLocation> in) {
            return this.myVcsZipper.groupLocations(in);
        }

        public CommittedChangeList zip(RepositoryLocationGroup group, List<CommittedChangeList> lists) {
            if (lists.size() == 1) {
                return lists.get(0);
            }
            CommittedChangeList victim = lists.get(0) instanceof ReceivedChangeList ? ((ReceivedChangeList)lists.get(0)).getBaseList() : lists.get(0);
            ReceivedChangeList result = new ReceivedChangeList(victim);
            result.setForcePartial(false);
            HashSet baseChanges = new HashSet();
            for (CommittedChangeList list : lists) {
                baseChanges.addAll(list instanceof ReceivedChangeList ? ((ReceivedChangeList)list).getBaseList().getChanges() : list.getChanges());
                Collection changes = list.getChanges();
                for (Change change : changes) {
                    if (result.getChanges().contains(change)) continue;
                    result.addChange(change);
                }
            }
            result.setForcePartial(baseChanges.size() != result.getChanges().size());
            return result;
        }

        public long getNumber(CommittedChangeList list) {
            return this.myVcsZipper.getNumber(list);
        }
    }

    private class MyProjectChangesLoader
    implements Runnable {
        private final ChangeBrowserSettings mySettings;
        private final int myMaxCount;
        private final boolean myCacheOnly;
        private final Consumer<List<CommittedChangeList>> myConsumer;
        private final Consumer<List<VcsException>> myErrorConsumer;
        private final LinkedHashSet<CommittedChangeList> myResult = new LinkedHashSet();
        private final List<VcsException> myExceptions = new ArrayList<VcsException>();
        private boolean myDisposed = false;

        private MyProjectChangesLoader(ChangeBrowserSettings settings, int maxCount, boolean cacheOnly, Consumer<List<CommittedChangeList>> consumer, Consumer<List<VcsException>> errorConsumer) {
            this.mySettings = settings;
            this.myMaxCount = maxCount;
            this.myCacheOnly = cacheOnly;
            this.myConsumer = consumer;
            this.myErrorConsumer = errorConsumer;
        }

        @Override
        public void run() {
            for (AbstractVcs vcs : CommittedChangesCache.this.myVcsManager.getAllActiveVcss()) {
                CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
                if (provider == null) continue;
                VcsCommittedListsZipper vcsZipper = provider.getZipper();
                CommittedListsSequencesZipper zipper = null;
                if (vcsZipper != null) {
                    zipper = new CommittedListsSequencesZipper(vcsZipper);
                }
                boolean zipSupported = zipper != null;
                Map<VirtualFile, RepositoryLocation> map = CommittedChangesCache.this.myCachesHolder.getAllRootsUnderVcs(vcs);
                for (VirtualFile root : map.keySet()) {
                    if (CommittedChangesCache.this.myProject.isDisposed()) {
                        return;
                    }
                    RepositoryLocation location = map.get(root);
                    try {
                        List<CommittedChangeList> lists = CommittedChangesCache.this.getChanges(this.mySettings, root, vcs, this.myMaxCount, this.myCacheOnly, provider, location);
                        if (lists == null) continue;
                        if (zipSupported) {
                            zipper.add(location, lists);
                            continue;
                        }
                        this.myResult.addAll(lists);
                    }
                    catch (VcsException e) {
                        this.myExceptions.add(e);
                    }
                    catch (ProcessCanceledException e) {
                        this.myDisposed = true;
                    }
                }
                if (!zipSupported) continue;
                this.myResult.addAll(zipper.execute());
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    LOG.info("FINISHED CommittedChangesCache.getProjectChangesAsync - execution in queue");
                    if (CommittedChangesCache.this.myProject.isDisposed()) {
                        return;
                    }
                    if (MyProjectChangesLoader.this.myExceptions.size() > 0) {
                        MyProjectChangesLoader.this.myErrorConsumer.consume((Object)MyProjectChangesLoader.this.myExceptions);
                    } else if (!MyProjectChangesLoader.this.myDisposed) {
                        MyProjectChangesLoader.this.myConsumer.consume(new ArrayList(MyProjectChangesLoader.this.myResult));
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public static class State {
        private int myInitialCount = 500;
        private int myInitialDays = 90;
        private int myRefreshInterval = 30;
        private boolean myRefreshEnabled = false;

        public int getInitialCount() {
            return this.myInitialCount;
        }

        public void setInitialCount(int initialCount) {
            this.myInitialCount = initialCount;
        }

        public int getInitialDays() {
            return this.myInitialDays;
        }

        public void setInitialDays(int initialDays) {
            this.myInitialDays = initialDays;
        }

        public int getRefreshInterval() {
            return this.myRefreshInterval;
        }

        public void setRefreshInterval(int refreshInterval) {
            this.myRefreshInterval = refreshInterval;
        }

        public boolean isRefreshEnabled() {
            return this.myRefreshEnabled;
        }

        public void setRefreshEnabled(boolean refreshEnabled) {
            this.myRefreshEnabled = refreshEnabled;
        }
    }
}

