/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileStatusManagerImpl
extends FileStatusManager
implements ProjectComponent {
    private final Map<VirtualFile, FileStatus> myCachedStatuses = Collections.synchronizedMap(new HashMap());
    private final Project myProject;
    private final List<FileStatusListener> myListeners = ContainerUtil.createEmptyCOWList();
    private FileStatusProvider myFileStatusProvider;
    private final NotNullLazyValue<FileStatusProvider[]> myExtensions = new NotNullLazyValue<FileStatusProvider[]>(){

        @NotNull
        protected FileStatusProvider[] compute() {
            FileStatusProvider[] fileStatusProviderArray = (FileStatusProvider[])Extensions.getExtensions(FileStatusProvider.EP_NAME, (AreaInstance)FileStatusManagerImpl.this.myProject);
            if (fileStatusProviderArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/impl/FileStatusManagerImpl$1.compute must not return null");
            }
            return fileStatusProviderArray;
        }
    };

    public FileStatusManagerImpl(Project project, StartupManager startupManager) {
        this.myProject = project;
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                FileStatusManagerImpl.this.fileStatusesChanged();
            }
        });
    }

    public void setFileStatusProvider(FileStatusProvider fileStatusProvider) {
        this.myFileStatusProvider = fileStatusProvider;
    }

    public FileStatus calcStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/impl/FileStatusManagerImpl.calcStatus must not be null");
        }
        if (virtualFile.isInLocalFileSystem() && this.myFileStatusProvider != null) {
            for (FileStatusProvider extension : (FileStatusProvider[])this.myExtensions.getValue()) {
                FileStatus status = extension.getFileStatus(virtualFile);
                if (status == null) continue;
                return status;
            }
            return this.myFileStatusProvider.getFileStatus(virtualFile);
        }
        return FileStatus.NOT_CHANGED;
    }

    public void projectClosed() {
    }

    public void projectOpened() {
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
                if (file != null) {
                    FileStatusManagerImpl.this.refreshFileStatusFromDocument(file, event.getDocument());
                }
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this.myProject);
    }

    public void disposeComponent() {
        this.myCachedStatuses.clear();
    }

    @NotNull
    public String getComponentName() {
        if ("FileStatusManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/impl/FileStatusManagerImpl.getComponentName must not return null");
        }
        return "FileStatusManager";
    }

    public void initComponent() {
    }

    public void addFileStatusListener(FileStatusListener listener) {
        this.myListeners.add(listener);
    }

    public void addFileStatusListener(final FileStatusListener listener, Disposable parentDisposable) {
        this.addFileStatusListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FileStatusManagerImpl.this.removeFileStatusListener(listener);
            }
        });
    }

    public void fileStatusesChanged() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                public void run() {
                    FileStatusManagerImpl.this.fileStatusesChanged();
                }
            }, ModalityState.NON_MODAL);
            return;
        }
        this.myCachedStatuses.clear();
        for (FileStatusListener listener : this.myListeners) {
            listener.fileStatusesChanged();
        }
    }

    public void fileStatusChanged(final VirtualFile file) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && !application.isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                public void run() {
                    FileStatusManagerImpl.this.fileStatusChanged(file);
                }
            });
            return;
        }
        if (file == null || !file.isValid()) {
            return;
        }
        FileStatus cachedStatus = this.getCachedStatus(file);
        if (cachedStatus == null) {
            return;
        }
        FileStatus newStatus = this.calcStatus(file);
        if (cachedStatus == newStatus) {
            return;
        }
        this.myCachedStatuses.put(file, newStatus);
        for (FileStatusListener listener : this.myListeners) {
            listener.fileStatusChanged(file);
        }
    }

    public FileStatus getStatus(VirtualFile file) {
        FileStatus status = this.getCachedStatus(file);
        if (status == null) {
            status = this.calcStatus(file);
            this.myCachedStatuses.put(file, status);
        }
        return status;
    }

    public FileStatus getCachedStatus(VirtualFile file) {
        return this.myCachedStatuses.get(file);
    }

    public void removeFileStatusListener(FileStatusListener listener) {
        this.myListeners.remove(listener);
    }

    public void refreshFileStatusFromDocument(VirtualFile file, Document doc) {
        if (this.myFileStatusProvider != null) {
            this.myFileStatusProvider.refreshFileStatusFromDocument(file, doc);
        }
    }
}

