/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsFileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LineStatusTrackerManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
    private final Project myProject;
    private HashMap<Document, LineStatusTracker> myLineStatusTrackers = new HashMap();
    private final HashMap<Document, Alarm> myLineStatusUpdateAlarms = new HashMap();
    private final Object TRACKERS_LOCK = new Object();
    private boolean myIsDisposed = false;
    @NonNls
    protected static final String IGNORE_CHANGEMARKERS_KEY = "idea.ignore.changemarkers";
    private final ProjectLevelVcsManagerImpl myVcsManager;
    private final VcsFileStatusProvider myStatusProvider;

    public static LineStatusTrackerManager getInstance(Project project) {
        return (LineStatusTrackerManager)project.getComponent(LineStatusTrackerManager.class);
    }

    public LineStatusTrackerManager(Project project, ProjectLevelVcsManagerImpl vcsManager, VcsFileStatusProvider statusProvider) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myStatusProvider = statusProvider;
        project.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(Document doc) {
                LineStatusTracker tracker = LineStatusTrackerManager.this.getLineStatusTracker(doc);
                if (tracker != null) {
                    tracker.startBulkUpdate();
                }
            }

            @Override
            public void updateFinished(Document doc) {
                LineStatusTracker tracker = LineStatusTrackerManager.this.getLineStatusTracker(doc);
                if (tracker != null) {
                    tracker.finishBulkUpdate();
                }
            }
        });
    }

    public void projectOpened() {
        this.trackAwtThread();
        final MyFileStatusListener fileStatusListener = new MyFileStatusListener();
        MyEditorFactoryListener editorFactoryListener = new MyEditorFactoryListener();
        MyVirtualFileListener virtualFileListener = new MyVirtualFileListener();
        EditorColorsListener editorColorsListener = new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                LineStatusTrackerManager.this.resetTrackersForOpenFiles();
            }
        };
        this.myLineStatusTrackers = new HashMap();
        final FileStatusManager fsManager = FileStatusManager.getInstance((Project)this.myProject);
        fsManager.addFileStatusListener((FileStatusListener)fileStatusListener, (Disposable)this.myProject);
        final EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.addEditorFactoryListener((EditorFactoryListener)editorFactoryListener);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        virtualFileManager.addVirtualFileListener((VirtualFileListener)virtualFileListener, (Disposable)this.myProject);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        editorColorsManager.addEditorColorsListener(editorColorsListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable((EditorFactoryListener)editorFactoryListener, virtualFileManager, virtualFileListener, editorColorsManager, editorColorsListener){
            final /* synthetic */ EditorFactoryListener val$editorFactoryListener;
            final /* synthetic */ VirtualFileManager val$virtualFileManager;
            final /* synthetic */ MyVirtualFileListener val$virtualFileListener;
            final /* synthetic */ EditorColorsManager val$editorColorsManager;
            final /* synthetic */ EditorColorsListener val$editorColorsListener;
            {
                this.val$editorFactoryListener = editorFactoryListener;
                this.val$virtualFileManager = virtualFileManager;
                this.val$virtualFileListener = myVirtualFileListener;
                this.val$editorColorsManager = editorColorsManager;
                this.val$editorColorsListener = editorColorsListener;
            }

            public void dispose() {
                LineStatusTrackerManager.this.trackAwtThread();
                fsManager.removeFileStatusListener((FileStatusListener)fileStatusListener);
                editorFactory.removeEditorFactoryListener(this.val$editorFactoryListener);
                this.val$virtualFileManager.removeVirtualFileListener((VirtualFileListener)this.val$virtualFileListener);
                this.val$editorColorsManager.removeEditorColorsListener(this.val$editorColorsListener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        try {
            this.trackAwtThread();
            this.dispose();
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("LineStatusTrackerManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/impl/LineStatusTrackerManager.getComponentName must not return null");
        }
        return "LineStatusTrackerManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void dispose() {
        LineStatusTracker[] lineStatusTrackers;
        Collection trackers = this.myLineStatusTrackers.values();
        for (LineStatusTracker tracker : lineStatusTrackers = trackers.toArray(new LineStatusTracker[trackers.size()])) {
            this.releaseTracker(tracker.getDocument());
        }
        this.myLineStatusTrackers = null;
    }

    public LineStatusTracker getLineStatusTracker(Document document) {
        this.trackAwtThread();
        if (this.myLineStatusTrackers == null) {
            return null;
        }
        return (LineStatusTracker)this.myLineStatusTrackers.get((Object)document);
    }

    public LineStatusTracker setUpToDateContent(Document document, String lastUpToDateContent) {
        this.trackAwtThread();
        LineStatusTracker result = (LineStatusTracker)this.myLineStatusTrackers.get((Object)document);
        if (result == null) {
            result = LineStatusTracker.createOn(document, lastUpToDateContent, this.myProject);
            this.myLineStatusTrackers.put((Object)document, (Object)result);
        }
        return result;
    }

    private LineStatusTracker createTrackerForDocument(Document document, VirtualFile vf) {
        LOG.assertTrue(!this.myLineStatusTrackers.containsKey((Object)document));
        LineStatusTracker result = LineStatusTracker.createOn(document, this.myProject);
        this.myLineStatusTrackers.put((Object)document, (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTracker(VirtualFile virtualFile) {
        if (System.getProperty(IGNORE_CHANGEMARKERS_KEY) != null) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping resetTracker() because no cached document for " + virtualFile.getPath());
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("resetting tracker for file " + virtualFile.getPath());
        }
        Object object = this.TRACKERS_LOCK;
        synchronized (object) {
            LineStatusTracker tracker = (LineStatusTracker)this.myLineStatusTrackers.get((Object)document);
            if (tracker != null) {
                this.resetTracker(tracker);
            } else if (Arrays.asList(FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()).contains(virtualFile)) {
                this.installTracker(virtualFile, document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseTracker(Document document) {
        Object object = this.TRACKERS_LOCK;
        synchronized (object) {
            this.releaseUpdateAlarms(document);
            if (this.myLineStatusTrackers == null) {
                return false;
            }
            if (!this.myLineStatusTrackers.containsKey((Object)document)) {
                return false;
            }
            LineStatusTracker tracker = (LineStatusTracker)this.myLineStatusTrackers.remove((Object)document);
            tracker.release();
            return true;
        }
    }

    private void releaseUpdateAlarms(Document document) {
        if (this.myLineStatusUpdateAlarms.containsKey((Object)document)) {
            Alarm alarm = (Alarm)this.myLineStatusUpdateAlarms.get((Object)document);
            if (alarm != null) {
                alarm.cancelAllRequests();
            }
            this.myLineStatusUpdateAlarms.remove((Object)document);
        }
    }

    public void resetTracker(final LineStatusTracker tracker) {
        this.trackAwtThread();
        if (tracker != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LineStatusTrackerManager.this.myIsDisposed) {
                        return;
                    }
                    if (LineStatusTrackerManager.this.releaseTracker(tracker.getDocument())) {
                        LineStatusTrackerManager.this.installTracker(tracker.getVirtualFile(), tracker.getDocument());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installTracker(final VirtualFile virtualFile, final Document document) {
        if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed() || this.myLineStatusTrackers == null) {
            return;
        }
        FileStatusManager statusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (statusManager == null) {
            return;
        }
        FileStatus status = statusManager.getStatus(virtualFile);
        Object object = this.TRACKERS_LOCK;
        synchronized (object) {
            Alarm alarm;
            if (this.myLineStatusTrackers.containsKey((Object)document)) {
                return;
            }
            if (status == FileStatus.NOT_CHANGED || status == FileStatus.ADDED || status == FileStatus.UNKNOWN || status == FileStatus.IGNORED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("installTracker() for file " + virtualFile.getPath() + " failed: status=" + status);
                }
                return;
            }
            AbstractVcs activeVcs = this.myVcsManager.getVcsFor(virtualFile);
            if (activeVcs == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("installTracker() for file " + virtualFile.getPath() + " failed: no active VCS");
                }
                return;
            }
            if (!virtualFile.isInLocalFileSystem()) {
                return;
            }
            if (System.getProperty(IGNORE_CHANGEMARKERS_KEY) != null) {
                return;
            }
            if (this.myLineStatusUpdateAlarms.containsKey((Object)document)) {
                alarm = (Alarm)this.myLineStatusUpdateAlarms.get((Object)document);
                alarm.cancelAllRequests();
            } else {
                alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
                this.myLineStatusUpdateAlarms.put((Object)document, (Object)alarm);
            }
            final LineStatusTracker tracker = this.createTrackerForDocument(document, virtualFile);
            alarm.addRequest(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        alarm.cancelAllRequests();
                        if (!virtualFile.isValid()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("installTracker() for file " + virtualFile.getPath() + " failed: virtual file not valid");
                            }
                            return;
                        }
                        final String lastUpToDateContent = LineStatusTrackerManager.this.myStatusProvider.getBaseVersionContent(virtualFile);
                        if (lastUpToDateContent == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("installTracker() for file " + virtualFile.getPath() + " failed: no up to date content");
                            }
                            return;
                        }
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!LineStatusTrackerManager.this.myProject.isDisposed()) {
                                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug("initializing tracker for file " + virtualFile.getPath());
                                            }
                                            Object object = LineStatusTrackerManager.this.TRACKERS_LOCK;
                                            synchronized (object) {
                                                tracker.initialize(lastUpToDateContent);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                    finally {
                        LineStatusTrackerManager.this.myLineStatusUpdateAlarms.remove((Object)document);
                    }
                }
            }, 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTrackersForOpenFiles() {
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
        Object object = this.TRACKERS_LOCK;
        synchronized (object) {
            for (VirtualFile openFile : openFiles) {
                this.resetTracker(openFile);
            }
        }
    }

    private void trackAwtThread() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            LOG.info("NOT dispatch thread: " + Thread.currentThread().getName(), new Throwable());
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void beforeContentsChange(VirtualFileEvent event) {
            LineStatusTrackerManager.this.trackAwtThread();
            if (event.isFromRefresh()) {
                LineStatusTrackerManager.this.resetTracker(event.getFile());
            }
        }
    }

    private class MyEditorFactoryListener
    extends EditorFactoryAdapter {
        private MyEditorFactoryListener() {
        }

        public void editorCreated(EditorFactoryEvent event) {
            Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != LineStatusTrackerManager.this.myProject) {
                return;
            }
            Document document = editor.getDocument();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            LineStatusTrackerManager.this.installTracker(virtualFile, document);
        }

        public void editorReleased(EditorFactoryEvent event) {
            LineStatusTrackerManager.this.trackAwtThread();
            Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != LineStatusTrackerManager.this.myProject) {
                return;
            }
            Document doc = editor.getDocument();
            Editor[] editors = event.getFactory().getEditors(doc, LineStatusTrackerManager.this.myProject);
            if (editors.length == 0) {
                LineStatusTrackerManager.this.releaseTracker(doc);
            }
        }
    }

    private class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            if (LineStatusTrackerManager.this.myProject.isDisposed()) {
                return;
            }
            LOG.debug("LineStatusTrackerManager: fileStatusesChanged");
            LineStatusTrackerManager.this.trackAwtThread();
            LineStatusTrackerManager.this.resetTrackersForOpenFiles();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener.fileStatusChanged must not be null");
            }
            LineStatusTrackerManager.this.trackAwtThread();
            LineStatusTrackerManager.this.resetTracker(virtualFile);
        }
    }
}

