/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class FileOrDirectoryTreeNode
extends AbstractTreeNode
implements VirtualFilePointerListener,
Disposable {
    private static final Map<FileStatus, SimpleTextAttributes> myFileStatusToAttributeMap = new HashMap();
    private final SimpleTextAttributes myInvalidAttributes;
    private final Project myProject;
    protected final File myFile;
    private final String myName;

    protected FileOrDirectoryTreeNode(@NotNull String path, SimpleTextAttributes invalidAttributes, Project project, String parentPath) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/update/FileOrDirectoryTreeNode.<init> must not be null");
        }
        String preparedPath = path.replace(File.separatorChar, '/');
        String url = VirtualFileManager.constructUrl((String)LocalFileSystem.getInstance().getProtocol(), (String)preparedPath);
        this.setUserObject(VirtualFilePointerManager.getInstance().create(url, (Disposable)this, (VirtualFilePointerListener)this));
        this.myFile = new File(this.getFilePath());
        this.myInvalidAttributes = invalidAttributes;
        this.myProject = project;
        this.myName = parentPath == null ? this.myFile.getAbsolutePath() : this.myFile.getName();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    protected String getFilePath() {
        return this.getFilePointer().getPresentableUrl();
    }

    public void beforeValidityChanged(VirtualFilePointer[] pointers) {
    }

    public void validityChanged(VirtualFilePointer[] pointers) {
        if (!this.getFilePointer().isValid()) {
            AbstractTreeNode parent = (AbstractTreeNode)this.getParent();
            if (parent != null && parent.getSupportsDeletion()) {
                this.getTreeModel().removeNodeFromParent(this);
            } else if (this.getTree() != null) {
                this.getTree().repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserObject(Object userObject) {
        Object oldObject = this.getUserObject();
        try {
            super.setUserObject(userObject);
        }
        finally {
            if (oldObject instanceof VirtualFilePointer) {
                VirtualFilePointer pointer = (VirtualFilePointer)oldObject;
                VirtualFilePointerManager.getInstance().kill(pointer, (VirtualFilePointerListener)this);
            }
        }
    }

    public VirtualFilePointer getFilePointer() {
        return (VirtualFilePointer)this.getUserObject();
    }

    @Override
    public SimpleTextAttributes getAttributes() {
        if (!this.getFilePointer().isValid()) {
            return this.myInvalidAttributes;
        }
        VirtualFile file = this.getFilePointer().getFile();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        FileStatus status = fileStatusManager.getStatus(file);
        return FileOrDirectoryTreeNode.getAttributesFor(status);
    }

    private static SimpleTextAttributes getAttributesFor(FileStatus status) {
        Color color = status.getColor();
        if (color == null) {
            color = Color.black;
        }
        if (!myFileStatusToAttributeMap.containsKey(status)) {
            myFileStatusToAttributeMap.put(status, new SimpleTextAttributes(0, color));
        }
        return myFileStatusToAttributeMap.get(status);
    }

    @Override
    public boolean getSupportsDeletion() {
        AbstractTreeNode parent = (AbstractTreeNode)this.getParent();
        return parent != null && parent.getSupportsDeletion();
    }

    public void dispose() {
    }
}

