/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingTo;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseFileEncodingAction
extends ComboBoxAction {
    private final VirtualFile myVirtualFile;
    public static final Charset NO_ENCODING = new Charset("NO_ENCODING", null){

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return null;
        }
    };

    public ChooseFileEncodingAction(VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public void update(AnActionEvent e) {
        boolean enabled = ChooseFileEncodingAction.isEnabled(this.myVirtualFile);
        if (this.myVirtualFile != null) {
            Charset charset = ChooseFileEncodingAction.charsetFromContent(this.myVirtualFile);
            String prefix = charset == null ? "" : "Encoding:";
            if (charset == null) {
                charset = this.myVirtualFile.getCharset();
            }
            e.getPresentation().setText(prefix + " " + charset.toString());
        }
        e.getPresentation().setEnabled(enabled);
    }

    public static boolean isEnabled(VirtualFile virtualFile) {
        boolean enabled = true;
        if (virtualFile != null) {
            FileType fileType;
            Charset charset = ChooseFileEncodingAction.charsetFromContent(virtualFile);
            if (charset != null) {
                enabled = false;
            } else if (!virtualFile.isDirectory() && ((fileType = FileTypeManager.getInstance().getFileTypeByFile(virtualFile)).isBinary() || fileType == StdFileTypes.GUI_DESIGNER_FORM || fileType == StdFileTypes.IDEA_MODULE || fileType == StdFileTypes.IDEA_PROJECT || fileType == StdFileTypes.IDEA_WORKSPACE || fileType == StdFileTypes.PATCH || fileType == StdFileTypes.PROPERTIES || fileType == StdFileTypes.XML || fileType == StdFileTypes.JSPX)) {
                enabled = false;
            }
        }
        return enabled;
    }

    @Nullable(value="returns null if charset set cannot be determined from content")
    public static Charset charsetFromContent(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        return EncodingManager.getInstance().getCachedCharsetFromContent(document);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup defaultActionGroup = this.createGroup(true);
        if (defaultActionGroup == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction.createPopupActionGroup must not return null");
        }
        return defaultActionGroup;
    }

    private void fillCharsetActions(DefaultActionGroup group, VirtualFile virtualFile, List<Charset> charsets) {
        for (Charset slave : charsets) {
            ChangeFileEncodingTo action = new ChangeFileEncodingTo(virtualFile, slave){

                protected void chosen(VirtualFile file, Charset charset) {
                    ChooseFileEncodingAction.this.chosen(file, charset);
                }
            };
            group.add((AnAction)action);
        }
    }

    protected abstract void chosen(VirtualFile var1, Charset var2);

    public DefaultActionGroup createGroup(boolean showClear) {
        DefaultActionGroup group = new DefaultActionGroup();
        ArrayList<Charset> favorites = new ArrayList<Charset>(EncodingManager.getInstance().getFavorites());
        Collections.sort(favorites);
        Charset current = this.myVirtualFile == null ? null : ChooseFileEncodingAction.charsetFromContent(this.myVirtualFile);
        favorites.remove(current);
        if (showClear) {
            group.add((AnAction)new ClearThisFileEncodingAction(this.myVirtualFile));
        }
        this.fillCharsetActions(group, this.myVirtualFile, favorites);
        DefaultActionGroup more = new DefaultActionGroup("more", true);
        group.add((AnAction)more);
        this.fillCharsetActions(more, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()));
        return group;
    }

    private class ClearThisFileEncodingAction
    extends AnAction {
        private final VirtualFile myFile;

        private ClearThisFileEncodingAction(VirtualFile file) {
            super("<Clear>", "Clear " + (file == null ? "default" : "file '" + file.getName() + "'") + " encoding.", null);
            this.myFile = file;
        }

        public void actionPerformed(AnActionEvent e) {
            ChooseFileEncodingAction.this.chosen(this.myFile, NO_ENCODING);
        }
    }
}

