/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.openapi.wm.impl.status.StatusBarTooltipper;
import com.intellij.ui.UIBundle;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ToggleReadOnlyAttributePanel
extends JLabel
implements StatusBarPatch {
    private static final Icon myLockedIcon = IconLoader.getIcon((String)"/nodes/lockedSingle.png");
    private static final Icon myUnlockedIcon = myLockedIcon == null ? null : new EmptyIcon(myLockedIcon.getIconWidth(), myLockedIcon.getIconHeight());

    public ToggleReadOnlyAttributePanel(StatusBar statusBar) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ToggleReadOnlyAttributePanel.this.processDoubleClick();
                }
            }
        });
        this.setIconTextGap(0);
        StatusBarTooltipper.install(this, statusBar);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String updateStatusBar(Editor selected, JComponent componentSelected) {
        boolean isWritable = selected == null || selected.getDocument().isWritable();
        this.setIcon(isWritable ? myUnlockedIcon : myLockedIcon);
        return this.isReadonlyApplicable() ? UIBundle.message((String)"read.only.attr.panel.double.click.to.toggle.attr.tooltip.text", (Object[])new Object[0]) : null;
    }

    @Override
    public void clear() {
        this.setIcon(myUnlockedIcon);
    }

    private boolean isReadonlyApplicable() {
        Project project = this.getProject();
        if (project == null) {
            return false;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        if (editorManager == null) {
            return false;
        }
        VirtualFile[] selectedFiles = editorManager.getSelectedFiles();
        return ToggleReadOnlyAttributePanel.isReadOnlyApplicable(selectedFiles);
    }

    private void processDoubleClick() {
        final Project project = this.getProject();
        if (project == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        final VirtualFile[] files = editorManager.getSelectedFiles();
        if (!ToggleReadOnlyAttributePanel.isReadOnlyApplicable(files)) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)files[0], (boolean)files[0].isWritable());
                }
                catch (IOException e) {
                    Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                }
            }
        });
    }

    private static boolean isReadOnlyApplicable(VirtualFile[] files) {
        return files.length > 0 && !files[0].getFileSystem().isReadOnly();
    }

    private Project getProject() {
        return (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
    }
}

