/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.BackwardDependenciesBuilder;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class BackwardDependenciesHandler {
    private final Project myProject;
    private final List<AnalysisScope> myScopes;
    private final AnalysisScope myScopeOfInterest;
    private final Set<PsiFile> myExcluded;

    public BackwardDependenciesHandler(Project project, AnalysisScope scope, AnalysisScope selectedScope) {
        this(project, Collections.singletonList(scope), selectedScope, new HashSet<PsiFile>());
    }

    public BackwardDependenciesHandler(Project project, List<AnalysisScope> scopes, AnalysisScope scopeOfInterest, Set<PsiFile> excluded) {
        this.myProject = project;
        this.myScopes = scopes;
        this.myScopeOfInterest = scopeOfInterest;
        this.myExcluded = excluded;
    }

    public void analyze() {
        final ArrayList<BackwardDependenciesBuilder> builders = new ArrayList<BackwardDependenciesBuilder>();
        for (AnalysisScope scope : this.myScopes) {
            builders.add(new BackwardDependenciesBuilder(this.myProject, scope, this.myScopeOfInterest));
        }
        Runnable process = new Runnable(){

            @Override
            public void run() {
                for (DependenciesBuilder builder : builders) {
                    builder.analyze();
                }
            }
        };
        Runnable successRunnable = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DependenciesPanel panel = new DependenciesPanel(BackwardDependenciesHandler.this.myProject, builders, BackwardDependenciesHandler.this.myExcluded);
                        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, AnalysisScopeBundle.message((String)"backward.dependencies.toolwindow.title", (Object[])new Object[]{((DependenciesBuilder)builders.get(0)).getScope().getDisplayName()}), false);
                        content.setDisposer((Disposable)panel);
                        panel.setContent(content);
                        ((DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)BackwardDependenciesHandler.this.myProject)).addContent(content);
                    }
                });
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(this.myProject, AnalysisScopeBundle.message((String)"backward.dependencies.progress.text", (Object[])new Object[0]), process, successRunnable, null, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(this.myProject));
    }
}

