/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;

class InjectedSelfElementInfo
extends SelfElementInfo {
    private DocumentWindow myDocument;

    InjectedSelfElementInfo(PsiElement anchor) {
        super(anchor);
        assert (this.myFile.getContext() != null);
    }

    @Override
    protected TextRange getPersistentAnchorRange(PsiElement anchor, Document document) {
        TextRange textRange = super.getPersistentAnchorRange(anchor, document);
        if (!(document instanceof DocumentWindow)) {
            return textRange;
        }
        this.myDocument = (DocumentWindow)document;
        return this.myDocument.injectedToHost(textRange);
    }

    @Override
    protected int getSyncEndOffset() {
        int syncEndOffset = super.getSyncEndOffset();
        return this.myDocument == null ? syncEndOffset : this.myDocument.hostToInjected(syncEndOffset);
    }

    @Override
    protected int getSyncStartOffset() {
        int syncStartOffset = super.getSyncStartOffset();
        return this.myDocument == null ? syncStartOffset : this.myDocument.hostToInjected(syncStartOffset);
    }
}

