/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.lang.ASTFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.source.ParsingContext;
import com.intellij.psi.impl.source.parsing.TokenProcessor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;

public abstract class DefaultWhiteSpaceTokenProcessorImpl
implements TokenProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.DefaultWhiteSpaceTokenProcessorImpl");

    @Override
    public boolean isTokenValid(IElementType tokenType) {
        return tokenType != null && this.isInSet(tokenType);
    }

    @Override
    public TreeElement process(Lexer lexer, ParsingContext context) {
        LeafElement first = null;
        TreeElement last = null;
        while (this.isTokenValid(lexer.getTokenType())) {
            LeafElement tokenElement = ASTFactory.leaf(lexer.getTokenType(), context.tokenText(lexer));
            IElementType type = lexer.getTokenType();
            if (!this.isInSet(type)) {
                LOG.error("Missed token should be white space or comment:" + tokenElement);
                throw new RuntimeException();
            }
            if (last != null) {
                last.setTreeNext(tokenElement);
                tokenElement.setTreePrev(last);
                last = tokenElement;
            } else {
                last = tokenElement;
                first = last;
            }
            lexer.advance();
        }
        return first;
    }

    protected abstract boolean isInSet(IElementType var1);
}

