/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.quickFix.CreateClassOrPackageFix;
import com.intellij.codeInsight.lookup.LookupElementFactoryImpl;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.GenericReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReference
extends GenericReference
implements PsiJavaReference,
QuickFixProvider,
LocalQuickFixProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference");
    protected final int myIndex;
    private TextRange myRange;
    private final String myText;
    private final boolean myInStaticImport;
    private final JavaClassReferenceSet myJavaClassReferenceSet;

    public JavaClassReference(JavaClassReferenceSet referenceSet, TextRange range, int index, String text, boolean staticImport) {
        super(referenceSet.getProvider());
        this.myInStaticImport = staticImport;
        LOG.assertTrue(range.getEndOffset() <= referenceSet.getElement().getTextLength());
        this.myIndex = index;
        this.myRange = range;
        this.myText = text;
        this.myJavaClassReferenceSet = referenceSet;
    }

    @Override
    @Nullable
    public PsiElement getContext() {
        PsiReference contextRef = this.getContextReference();
        return contextRef != null ? contextRef.resolve() : null;
    }

    @Override
    public void processVariants(final PsiScopeProcessor processor) {
        Map<CustomizableReferenceProvider.CustomizationKey, Object> options;
        if (processor instanceof JavaCompletionProcessor && (options = this.getOptions()) != null && (JavaClassReferenceProvider.EXTEND_CLASS_NAMES.getValue(options) != null || JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(options) || JavaClassReferenceProvider.CONCRETE.getBooleanValue(options))) {
            ((JavaCompletionProcessor)processor).setCompletionElements(this.getVariants());
            return;
        }
        PsiScopeProcessor processorToUse = processor;
        if (this.myInStaticImport) {
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        } else {
            if (this.isDefinitelyStatic()) {
                processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
            }
            processorToUse = new PsiScopeProcessor(){

                public boolean execute(PsiElement element, ResolveState state) {
                    return !(element instanceof PsiClass) && !(element instanceof PsiPackage) || processor.execute(element, state);
                }

                public <V> V getHint(Key<V> hintKey) {
                    return (V)processor.getHint(hintKey);
                }

                public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
                    processor.handleEvent(event, associated);
                }
            };
        }
        super.processVariants(processorToUse);
    }

    private boolean isDefinitelyStatic() {
        String s = this.getElement().getText();
        return this.isStaticClassReference(s, true);
    }

    private boolean isStaticClassReference(String s, boolean strict) {
        if (this.myIndex == 0) {
            return false;
        }
        char c = s.charAt(this.getRangeInElement().getStartOffset() - 1);
        return this.myJavaClassReferenceSet.isStaticSeparator(c, strict);
    }

    @Override
    @Nullable
    public PsiReference getContextReference() {
        return this.myIndex > 0 ? this.myJavaClassReferenceSet.getReference(this.myIndex - 1) : null;
    }

    private boolean canReferencePackage() {
        return this.myJavaClassReferenceSet.canReferencePackage(this.myIndex);
    }

    public PsiElement getElement() {
        return this.myJavaClassReferenceSet.getElement();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return (element instanceof PsiClass || element instanceof PsiPackage) && super.isReferenceTo(element);
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    public String getCanonicalText() {
        return this.myText;
    }

    @Override
    public boolean isSoft() {
        return this.myJavaClassReferenceSet.isSoft();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator<PsiElement> manipulator = JavaClassReference.getManipulator(this.getElement());
        if (manipulator != null) {
            PsiElement element = manipulator.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
            this.myRange = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newElementName.length());
            return element;
        }
        throw new IncorrectOperationException("Manipulator for this element is not defined: " + this.getElement());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String newName;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.bindToElement must not be null");
        }
        if (this.isReferenceTo(element)) {
            return this.getElement();
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            boolean jvmFormat = Boolean.TRUE.equals(JavaClassReferenceProvider.JVM_FORMAT.getValue(this.getOptions()));
            newName = jvmFormat ? ClassUtil.getJVMClassName((PsiClass)psiClass) : psiClass.getQualifiedName();
        } else if (element instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)element;
            newName = psiPackage.getQualifiedName();
        } else {
            throw new IncorrectOperationException("Cannot bind to " + element);
        }
        assert (newName != null);
        TextRange range = new TextRange(this.myJavaClassReferenceSet.getReference(0).getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset());
        ElementManipulator<PsiElement> manipulator = JavaClassReference.getManipulator(this.getElement());
        if (manipulator != null) {
            PsiElement finalElement = manipulator.handleContentChange(this.getElement(), range, newName);
            range = new TextRange(range.getStartOffset(), range.getStartOffset() + newName.length());
            this.myJavaClassReferenceSet.reparse(finalElement, range);
            return finalElement;
        }
        return element;
    }

    @Override
    public PsiElement resolveInner() {
        return this.advancedResolve(true).getElement();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        PsiElement context = this.getContext();
        if (context == null) {
            context = JavaPsiFacade.getInstance((Project)this.getElement().getProject()).findPackage("");
        }
        if (context instanceof PsiPackage) {
            String[] extendClasses = this.getExtendClassNames();
            if (!(extendClasses != null ? (objectArray = this.getSubclassVariants((PsiPackage)context, extendClasses)) != null : (objectArray = this.processPackage((PsiPackage)context)) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.getVariants must not return null");
            return objectArray;
        }
        if (context instanceof PsiClass) {
            PsiClass aClass = (PsiClass)context;
            if (this.myInStaticImport) {
                objectArray = ArrayUtil.mergeArrays((Object[])aClass.getInnerClasses(), (Object[])aClass.getFields(), Object.class);
                if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.getVariants must not return null");
                return objectArray;
            }
            if (this.isDefinitelyStatic()) {
                PsiClass[] psiClasses = aClass.getInnerClasses();
                ArrayList<PsiClass> staticClasses = new ArrayList<PsiClass>(psiClasses.length);
                for (PsiClass c : psiClasses) {
                    if (!c.hasModifierProperty("static")) continue;
                    staticClasses.add(c);
                }
                objectArray = staticClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : staticClasses.toArray(new PsiClass[staticClasses.size()]);
                if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.getVariants must not return null");
                return objectArray;
            }
        }
        objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        if (ArrayUtil.EMPTY_OBJECT_ARRAY != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.getVariants must not return null");
    }

    public String[] getExtendClassNames() {
        return JavaClassReferenceProvider.EXTEND_CLASS_NAMES.getValue(this.getOptions());
    }

    private Object[] processPackage(PsiPackage aPackage) {
        ArrayList<Object> list = new ArrayList<Object>();
        int startOffset = StringUtil.isEmpty((String)aPackage.getName()) ? 0 : aPackage.getQualifiedName().length() + 1;
        GlobalSearchScope scope = this.getScope();
        for (PsiPackage subPackage : aPackage.getSubPackages(scope)) {
            String shortName = subPackage.getQualifiedName().substring(startOffset);
            if (!JavaPsiFacade.getInstance((Project)subPackage.getProject()).getNameHelper().isIdentifier(shortName)) continue;
            list.add(subPackage);
        }
        PsiClass[] classes = aPackage.getClasses(scope);
        Map<CustomizableReferenceProvider.CustomizationKey, Object> options = this.getOptions();
        if (options != null) {
            boolean instantiatable = JavaClassReferenceProvider.INSTANTIATABLE.getBooleanValue(options);
            boolean concrete = JavaClassReferenceProvider.CONCRETE.getBooleanValue(options);
            boolean notInterface = JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(options);
            boolean notEnum = JavaClassReferenceProvider.NOT_ENUM.getBooleanValue(options);
            for (PsiClass clazz : classes) {
                if (!JavaClassReference.isClassAccepted(clazz, instantiatable, concrete, notInterface, notEnum)) continue;
                list.add(clazz);
            }
        } else {
            list.addAll(Arrays.asList(classes));
        }
        return list.toArray();
    }

    private static boolean isClassAccepted(PsiClass clazz, boolean instantiatable, boolean concrete, boolean notInterface, boolean notEnum) {
        if (instantiatable) {
            if (PsiUtil.isInstantiatable((PsiClass)clazz)) {
                return true;
            }
        } else if (concrete) {
            if (!clazz.hasModifierProperty("abstract") && !clazz.isInterface()) {
                return true;
            }
        } else if (notInterface) {
            if (!clazz.isInterface()) {
                return true;
            }
        } else if (notEnum) {
            if (!clazz.isEnum()) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        PsiManager manager = this.getElement().getManager();
        if (manager instanceof PsiManagerImpl) {
            javaResolveResult = (JavaResolveResult)((PsiManagerImpl)manager).getResolveCache().resolveWithCaching(this, MyResolver.INSTANCE, false, false)[0];
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.advancedResolve must not return null");
            return javaResolveResult;
        }
        javaResolveResult = this.doAdvancedResolve();
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.advancedResolve must not return null");
    }

    private JavaResolveResult doAdvancedResolve() {
        JavaResolveResult resolveResult;
        String defaultPackage;
        int endOffset;
        PsiElement psiElement = this.getElement();
        if (!psiElement.isValid()) {
            return JavaResolveResult.EMPTY;
        }
        String elementText = psiElement.getText();
        PsiElement context = this.getContext();
        if (context instanceof PsiClass) {
            if (this.isStaticClassReference(elementText, false)) {
                PsiClass psiClass = ((PsiClass)context).findInnerClassByName(this.getCanonicalText(), false);
                if (psiClass != null) {
                    return new ClassCandidateInfo((PsiElement)psiClass, PsiSubstitutor.EMPTY, false, psiElement);
                }
                PsiElement member = JavaClassReference.doResolveMember((PsiClass)context, this.myText);
                return member == null ? JavaResolveResult.EMPTY : new CandidateInfo(member, PsiSubstitutor.EMPTY, false, false, psiElement);
            }
            if (!this.myInStaticImport && this.myJavaClassReferenceSet.isAllowDollarInNames()) {
                return JavaResolveResult.EMPTY;
            }
        }
        LOG.assertTrue((endOffset = this.getRangeInElement().getEndOffset()) <= elementText.length(), (Object)elementText);
        int startOffset = this.myJavaClassReferenceSet.getReference(0).getRangeInElement().getStartOffset();
        String qName = elementText.substring(startOffset, endOffset);
        if (!qName.contains(".") && StringUtil.isNotEmpty((String)(defaultPackage = JavaClassReferenceProvider.DEFAULT_PACKAGE.getValue(this.getOptions()))) && (resolveResult = this.advancedResolveInner(psiElement, defaultPackage + "." + qName)) != JavaResolveResult.EMPTY) {
            return resolveResult;
        }
        return this.advancedResolveInner(psiElement, qName);
    }

    private JavaResolveResult advancedResolveInner(PsiElement psiElement, String qName) {
        PsiFile containingFile;
        PsiPackage resolveResult;
        PsiManager manager = psiElement.getManager();
        GlobalSearchScope scope = this.getScope();
        if (this.myIndex == this.myJavaClassReferenceSet.getReferences().length - 1) {
            PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, scope);
            if (aClass != null) {
                return new ClassCandidateInfo((PsiElement)aClass, PsiSubstitutor.EMPTY, false, psiElement);
            }
            if (!JavaClassReferenceProvider.ADVANCED_RESOLVE.getBooleanValue(this.getOptions())) {
                return JavaResolveResult.EMPTY;
            }
        }
        if ((resolveResult = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(qName)) == null) {
            resolveResult = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, scope);
        }
        if (this.myInStaticImport && resolveResult == null) {
            resolveResult = JavaClassReference.resolveMember(qName, manager, this.getElement().getResolveScope());
        }
        if (resolveResult == null && (containingFile = psiElement.getContainingFile()) instanceof PsiJavaFile) {
            if (containingFile instanceof JspFile && (containingFile = containingFile.getViewProvider().getPsi(StdLanguages.JAVA)) == null) {
                return JavaResolveResult.EMPTY;
            }
            ClassResolverProcessor processor = new ClassResolverProcessor(this.getCanonicalText(), psiElement);
            containingFile.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, psiElement);
            if (processor.getResult().length == 1) {
                JavaResolveResult javaResolveResult = processor.getResult()[0];
                if (javaResolveResult != JavaResolveResult.EMPTY && this.getOptions() != null) {
                    String qualifiedName;
                    Boolean value = JavaClassReferenceProvider.RESOLVE_QUALIFIED_CLASS_NAME.getValue(this.getOptions());
                    PsiClass psiClass = (PsiClass)javaResolveResult.getElement();
                    if (value != null && value.booleanValue() && psiClass != null && !qName.equals(qualifiedName = psiClass.getQualifiedName())) {
                        return JavaResolveResult.EMPTY;
                    }
                }
                return javaResolveResult;
            }
        }
        return resolveResult != null ? new CandidateInfo((PsiElement)resolveResult, PsiSubstitutor.EMPTY, false, false, psiElement) : JavaResolveResult.EMPTY;
    }

    private GlobalSearchScope getScope() {
        GlobalSearchScope scope = this.myJavaClassReferenceSet.getProvider().getScope();
        if (scope == null) {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
            if (module != null) {
                return module.getModuleWithDependenciesAndLibrariesScope(true);
            }
            return GlobalSearchScope.allScope((Project)this.getElement().getProject());
        }
        return scope;
    }

    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myJavaClassReferenceSet.getOptions();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult javaResolveResult = this.advancedResolve(incompleteCode);
        if (javaResolveResult.getElement() == null) {
            javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            if (JavaResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = new JavaResolveResult[]{javaResolveResult};
        if (javaResolveResultArray != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.multiResolve must not return null");
    }

    public void registerQuickfix(HighlightInfo info, PsiReference reference) {
        this.registerFixes(info);
    }

    @Nullable
    private List<? extends LocalQuickFix> registerFixes(HighlightInfo info) {
        ClassKind kind;
        List<LocalQuickFix> list = OrderEntryFix.registerFixes(new QuickFixActionRegistrarImpl(info), this);
        String[] extendClasses = this.getExtendClassNames();
        String extendClass = extendClasses != null && extendClasses.length > 0 ? extendClasses[0] : null;
        JavaClassReference[] references = this.getJavaClassReferenceSet().getAllReferences();
        PsiPackage contextPackage = null;
        for (int i = this.myIndex; i >= 0; --i) {
            PsiElement context = references[i].getContext();
            if (context == null) continue;
            if (!(context instanceof PsiPackage)) break;
            contextPackage = (PsiPackage)context;
            break;
        }
        boolean createJavaClass = !this.canReferencePackage();
        ClassKind classKind = kind = createJavaClass ? JavaClassReferenceProvider.CLASS_KIND.getValue(this.getOptions()) : null;
        if (createJavaClass && kind == null) {
            kind = ClassKind.CLASS;
        }
        String templateName = JavaClassReferenceProvider.CLASS_TEMPLATE.getValue(this.getOptions());
        TextRange range = new TextRange(references[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset());
        String qualifiedName = range.substring(this.getElement().getText());
        CreateClassOrPackageFix action = CreateClassOrPackageFix.createFix(qualifiedName, this.getScope(), this.getElement(), contextPackage, kind, extendClass, templateName);
        if (action != null) {
            QuickFixAction.registerQuickFixAction(info, action);
            if (list == null) {
                return Arrays.asList(action);
            }
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(list.size() + 1);
            fixes.addAll(list);
            fixes.add(action);
            return fixes;
        }
        return list;
    }

    @NotNull
    private Object[] getSubclassVariants(@NotNull PsiPackage context, @NotNull String[] extendClasses) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.getSubclassVariants must not be null");
        }
        if (extendClasses == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.getSubclassVariants must not be null");
        }
        HashSet lookups = new HashSet();
        GlobalSearchScope packageScope = PackageScope.packageScope((PsiPackage)context, (boolean)true);
        GlobalSearchScope scope = this.myJavaClassReferenceSet.getProvider().getScope();
        if (scope != null) {
            packageScope = packageScope.intersectWith(scope);
        }
        GlobalSearchScope allScope = ProjectScope.getAllScope((Project)context.getProject());
        boolean instantiatable = JavaClassReferenceProvider.INSTANTIATABLE.getBooleanValue(this.getOptions());
        boolean notInterface = JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(this.getOptions());
        boolean notEnum = JavaClassReferenceProvider.NOT_ENUM.getBooleanValue(this.getOptions());
        boolean concrete = JavaClassReferenceProvider.CONCRETE.getBooleanValue(this.getOptions());
        for (String extendClassName : extendClasses) {
            PsiClass extendClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(extendClassName, allScope);
            if (extendClass == null) continue;
            if (packageScope.contains(extendClass.getContainingFile().getVirtualFile()) && JavaClassReference.isClassAccepted(extendClass, instantiatable, concrete, notInterface, notEnum)) {
                ContainerUtil.addIfNotNull((Object)JavaClassReference.createSubclassLookupValue(context, extendClass), lookups);
            }
            for (PsiClass clazz : ClassInheritorsSearch.search((PsiClass)extendClass, (SearchScope)packageScope, (boolean)true)) {
                if (!JavaClassReference.isClassAccepted(clazz, instantiatable, concrete, notInterface, notEnum)) continue;
                ContainerUtil.addIfNotNull((Object)JavaClassReference.createSubclassLookupValue(context, clazz), lookups);
            }
        }
        Object[] objectArray = lookups.toArray();
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.getSubclassVariants must not return null");
        }
        return objectArray;
    }

    @Nullable
    private static Object createSubclassLookupValue(@NotNull PsiPackage context, @NotNull PsiClass clazz) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.createSubclassLookupValue must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference.createSubclassLookupValue must not be null");
        }
        String name = clazz.getQualifiedName();
        if (name == null) {
            return null;
        }
        String pack = context.getQualifiedName();
        if (pack.length() > 0) {
            if (name.startsWith(pack)) {
                name = name.substring(pack.length() + 1);
            } else {
                return null;
            }
        }
        MutableLookupElement lookup = LookupElementFactoryImpl.getInstance().createLookupElement(clazz, name);
        lookup.addLookupStrings(new String[]{clazz.getName()});
        return JavaCompletionUtil.setShowFQN((LookupItem)lookup).setTailType(TailType.NONE);
    }

    public LocalQuickFix[] getQuickFixes() {
        List<? extends LocalQuickFix> list = this.registerFixes(null);
        return list == null ? LocalQuickFix.EMPTY_ARRAY : list.toArray(new LocalQuickFix[list.size()]);
    }

    @Nullable
    public static PsiElement resolveMember(String fqn, PsiManager manager, GlobalSearchScope resolveScope) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(fqn, resolveScope);
        if (aClass != null) {
            return aClass;
        }
        int i = fqn.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        String memberName = fqn.substring(i + 1);
        fqn = fqn.substring(0, i);
        aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(fqn, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaClassReference.doResolveMember(aClass, memberName);
    }

    @Nullable
    private static PsiElement doResolveMember(PsiClass aClass, String memberName) {
        PsiField member = aClass.findFieldByName(memberName, true);
        if (member != null) {
            return member;
        }
        PsiMethod[] methods = aClass.findMethodsByName(memberName, true);
        return methods.length == 0 ? null : methods[0];
    }

    public JavaClassReferenceSet getJavaClassReferenceSet() {
        return this.myJavaClassReferenceSet;
    }

    public String getUnresolvedMessagePattern() {
        return this.myJavaClassReferenceSet.getUnresolvedMessagePattern(this.myIndex);
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantResolver<JavaClassReference> {
        private static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @Override
        public JavaResolveResult[] resolve(JavaClassReference javaClassReference, boolean incompleteCode) {
            return new JavaResolveResult[]{javaClassReference.doAdvancedResolve()};
        }
    }
}

