/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ICodeFragmentElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.java.PsiCodeBlockImpl;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IErrorCounterReparseableElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;

public interface JavaElementType {
    public static final IFileElementType JAVA_FILE = JavaStubElementTypes.FILE;
    public static final IElementType CLASS = JavaStubElementTypes.CLASS;
    public static final IElementType ANONYMOUS_CLASS = JavaStubElementTypes.ANONYMOUS_CLASS;
    public static final IElementType ENUM_CONSTANT_INITIALIZER = JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER;
    public static final IElementType TYPE_PARAMETER_LIST = JavaStubElementTypes.TYPE_PARAMETER_LIST;
    public static final IElementType TYPE_PARAMETER = JavaStubElementTypes.TYPE_PARAMETER;
    public static final IElementType IMPORT_LIST = JavaStubElementTypes.IMPORT_LIST;
    public static final IElementType IMPORT_STATEMENT = JavaStubElementTypes.IMPORT_STATEMENT;
    public static final IElementType IMPORT_STATIC_STATEMENT = JavaStubElementTypes.IMPORT_STATIC_STATEMENT;
    public static final IElementType MODIFIER_LIST = JavaStubElementTypes.MODIFIER_LIST;
    public static final IElementType ANNOTATION = JavaStubElementTypes.ANNOTATION;
    public static final TokenSet ANNOTATIONS = TokenSet.create((IElementType[])new IElementType[]{ANNOTATION});
    public static final IElementType EXTENDS_LIST = JavaStubElementTypes.EXTENDS_LIST;
    public static final IElementType IMPLEMENTS_LIST = JavaStubElementTypes.IMPLEMENTS_LIST;
    public static final IElementType FIELD = JavaStubElementTypes.FIELD;
    public static final IElementType ENUM_CONSTANT = JavaStubElementTypes.ENUM_CONSTANT;
    public static final IElementType METHOD = JavaStubElementTypes.METHOD;
    public static final IElementType ANNOTATION_METHOD = JavaStubElementTypes.ANNOTATION_METHOD;
    public static final IElementType CLASS_INITIALIZER = JavaStubElementTypes.CLASS_INITIALIZER;
    public static final IElementType PARAMETER = JavaStubElementTypes.PARAMETER;
    public static final IElementType PARAMETER_LIST = JavaStubElementTypes.PARAMETER_LIST;
    public static final IElementType EXTENDS_BOUND_LIST = JavaStubElementTypes.EXTENDS_BOUND_LIST;
    public static final IElementType THROWS_LIST = JavaStubElementTypes.THROWS_LIST;
    public static final IElementType IMPORT_STATIC_REFERENCE = new IJavaElementType("IMPORT_STATIC_REFERENCE");
    public static final IElementType TYPE = new IJavaElementType("TYPE");
    public static final IElementType REFERENCE_PARAMETER_LIST = new IJavaElementType("REFERENCE_PARAMETER_LIST");
    public static final IElementType JAVA_CODE_REFERENCE = new IJavaElementType("JAVA_CODE_REFERENCE");
    public static final IElementType PACKAGE_STATEMENT = new IJavaElementType("PACKAGE_STATEMENT");
    public static final IElementType LOCAL_VARIABLE = new IJavaElementType("LOCAL_VARIABLE");
    public static final IElementType REFERENCE_EXPRESSION = new IJavaElementType("REFERENCE_EXPRESSION");
    public static final IElementType LITERAL_EXPRESSION = new IJavaElementType("LITERAL_EXPRESSION");
    public static final IElementType THIS_EXPRESSION = new IJavaElementType("THIS_EXPRESSION");
    public static final IElementType SUPER_EXPRESSION = new IJavaElementType("SUPER_EXPRESSION");
    public static final IElementType PARENTH_EXPRESSION = new IJavaElementType("PARENTH_EXPRESSION");
    public static final IElementType METHOD_CALL_EXPRESSION = new IJavaElementType("METHOD_CALL_EXPRESSION");
    public static final IElementType TYPE_CAST_EXPRESSION = new IJavaElementType("TYPE_CAST_EXPRESSION");
    public static final IElementType PREFIX_EXPRESSION = new IJavaElementType("PREFIX_EXPRESSION");
    public static final IElementType POSTFIX_EXPRESSION = new IJavaElementType("POSTFIX_EXPRESSION");
    public static final IElementType BINARY_EXPRESSION = new IJavaElementType("BINARY_EXPRESSION");
    public static final IElementType CONDITIONAL_EXPRESSION = new IJavaElementType("CONDITIONAL_EXPRESSION");
    public static final IElementType ASSIGNMENT_EXPRESSION = new IJavaElementType("ASSIGNMENT_EXPRESSION");
    public static final IElementType NEW_EXPRESSION = new IJavaElementType("NEW_EXPRESSION");
    public static final IElementType ARRAY_ACCESS_EXPRESSION = new IJavaElementType("ARRAY_ACCESS_EXPRESSION");
    public static final IElementType ARRAY_INITIALIZER_EXPRESSION = new IJavaElementType("ARRAY_INITIALIZER_EXPRESSION");
    public static final IElementType INSTANCE_OF_EXPRESSION = new IJavaElementType("INSTANCE_OF_EXPRESSION");
    public static final IElementType CLASS_OBJECT_ACCESS_EXPRESSION = new IJavaElementType("CLASS_OBJECT_ACCESS_EXPRESSION");
    public static final IElementType EMPTY_EXPRESSION = new IJavaElementType("EMPTY_EXPRESSION");
    public static final IElementType EXPRESSION_LIST = new IJavaElementType("EXPRESSION_LIST");
    public static final IElementType EMPTY_STATEMENT = new IJavaElementType("EMPTY_STATEMENT");
    public static final IElementType BLOCK_STATEMENT = new IJavaElementType("BLOCK_STATEMENT");
    public static final IElementType EXPRESSION_STATEMENT = new IJavaElementType("EXPRESSION_STATEMENT");
    public static final IElementType EXPRESSION_LIST_STATEMENT = new IJavaElementType("EXPRESSION_LIST_STATEMENT");
    public static final IElementType DECLARATION_STATEMENT = new IJavaElementType("DECLARATION_STATEMENT");
    public static final IElementType IF_STATEMENT = new IJavaElementType("IF_STATEMENT");
    public static final IElementType WHILE_STATEMENT = new IJavaElementType("WHILE_STATEMENT");
    public static final IElementType FOR_STATEMENT = new IJavaElementType("FOR_STATEMENT");
    public static final IElementType FOREACH_STATEMENT = new IJavaElementType("FOREACH_STATEMENT");
    public static final IElementType DO_WHILE_STATEMENT = new IJavaElementType("DO_WHILE_STATEMENT");
    public static final IElementType SWITCH_STATEMENT = new IJavaElementType("SWITCH_STATEMENT");
    public static final IElementType SWITCH_LABEL_STATEMENT = new IJavaElementType("SWITCH_LABEL_STATEMENT");
    public static final IElementType BREAK_STATEMENT = new IJavaElementType("BREAK_STATEMENT");
    public static final IElementType CONTINUE_STATEMENT = new IJavaElementType("CONTINUE_STATEMENT");
    public static final IElementType RETURN_STATEMENT = new IJavaElementType("RETURN_STATEMENT");
    public static final IElementType THROW_STATEMENT = new IJavaElementType("THROW_STATEMENT");
    public static final IElementType SYNCHRONIZED_STATEMENT = new IJavaElementType("SYNCHRONIZED_STATEMENT");
    public static final IElementType TRY_STATEMENT = new IJavaElementType("TRY_STATEMENT");
    public static final IElementType LABELED_STATEMENT = new IJavaElementType("LABELED_STATEMENT");
    public static final IElementType ASSERT_STATEMENT = new IJavaElementType("ASSERT_STATEMENT");
    public static final IElementType CATCH_SECTION = new IJavaElementType("CATCH_SECTION");
    public static final IElementType ANNOTATION_ARRAY_INITIALIZER = new IJavaElementType("ANNOTATION_ARRAY_INITIALIZER");
    public static final IElementType NAME_VALUE_PAIR = new IJavaElementType("NAME_VALUE_PAIR");
    public static final IElementType ANNOTATION_PARAMETER_LIST = new IJavaElementType("ANNOTATION_PARAMETER_LIST");
    public static final IElementType METHOD_RECEIVER = new IJavaElementType("METHOD_RECEIVER");
    public static final ILazyParseableElementType CODE_BLOCK = new IErrorCounterReparseableElementType("CODE_BLOCK", StdLanguages.JAVA){

        public ASTNode createNode(CharSequence text) {
            return new PsiCodeBlockImpl(text);
        }

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence seq = chameleon.getChars();
            ASTNode original = (ASTNode)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED);
            ASTNode context = original != null ? original : chameleon.getTreeParent();
            PsiManager manager = context.getPsi().getManager();
            CharTable table = SharedImplUtil.findCharTableByTree(context);
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)TreeUtil.getFileElement((TreeElement)context).getPsi());
            JavaParsingContext parsingContext = new JavaParsingContext(table, languageLevel);
            return parsingContext.getStatementParsing().parseCodeBlockText(manager, (Lexer)new JavaLexer(languageLevel), seq, 0, seq.length(), 0).getFirstChildNode();
        }

        @Override
        public int getErrorsCount(CharSequence seq, Project project) {
            IElementType type;
            JavaLexer lexer = new JavaLexer(LanguageLevel.HIGHEST);
            lexer.start(seq);
            if (lexer.getTokenType() != JavaTokenType.LBRACE) {
                return Integer.MIN_VALUE;
            }
            lexer.advance();
            int balance = 1;
            while ((type = lexer.getTokenType()) != null) {
                if (balance == 0) {
                    return Integer.MIN_VALUE;
                }
                if (type == JavaTokenType.LBRACE) {
                    ++balance;
                } else if (type == JavaTokenType.RBRACE) {
                    --balance;
                }
                lexer.advance();
            }
            return balance;
        }
    };
    public static final IElementType STATEMENTS = new ICodeFragmentElementType("STATEMENTS", StdLanguages.JAVA){

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence chars = chameleon.getChars();
            PsiManagerEx manager = ((FileElement)chameleon).getManager();
            CharTable table = SharedImplUtil.findCharTableByTree(chameleon);
            JavaParsingContext context = new JavaParsingContext(table, LanguageLevel.HIGHEST);
            return context.getStatementParsing().parseStatements(manager, null, chars, 0, chars.length(), 0);
        }
    };
    public static final IElementType EXPRESSION_TEXT = new ICodeFragmentElementType("EXPRESSION_TEXT", StdLanguages.JAVA){

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence chars = chameleon.getChars();
            PsiManagerEx manager = ((FileElement)chameleon).getManager();
            JavaParsingContext context = new JavaParsingContext(SharedImplUtil.findCharTableByTree(chameleon), LanguageLevel.HIGHEST);
            return context.getExpressionParsing().parseExpressionTextFragment(manager, chars, 0, chars.length(), 0);
        }
    };
    public static final IElementType REFERENCE_TEXT = new ICodeFragmentElementType("REFERENCE_TEXT", StdLanguages.JAVA){

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence chars = chameleon.getChars();
            return Parsing.parseJavaCodeReferenceText(((FileElement)chameleon).getManager(), chars, 0, chars.length(), SharedImplUtil.findCharTableByTree(chameleon), true);
        }
    };
    public static final IElementType TYPE_TEXT = new ICodeFragmentElementType("TYPE_TEXT", StdLanguages.JAVA){

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence chars = chameleon.getChars();
            return Parsing.parseTypeText(((FileElement)chameleon).getManager(), null, chars, 0, chars.length(), 0, SharedImplUtil.findCharTableByTree(chameleon));
        }
    };
}

