/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.jsp.JspContextManager;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.RowIcon;
import com.intellij.util.CharTable;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiLocalVariableImpl
extends CompositePsiElement
implements PsiLocalVariable,
PsiVariableEx,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl");
    private volatile String myCachedName = null;

    public PsiLocalVariableImpl() {
        super(LOCAL_VARIABLE);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedName = null;
    }

    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public final String getName() {
        String cachedName = this.myCachedName;
        if (cachedName == null) {
            this.myCachedName = cachedName = this.getNameIdentifier().getText();
        }
        String string = cachedName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getName must not return null");
        }
        return string;
    }

    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    @NotNull
    public final PsiType getType() {
        PsiType psiType = JavaSharedImplUtil.getType(this);
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getType must not return null");
        }
        return psiType;
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        ASTNode first = this.getTreeParent().findChildByType(LOCAL_VARIABLE);
        PsiTypeElement psiTypeElement = (PsiTypeElement)SourceTreeToPsiMap.treeElementToPsi(first.findChildByType(TYPE));
        if (psiTypeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getTypeElement must not return null");
        }
        return psiTypeElement;
    }

    public PsiModifierList getModifierList() {
        CompositeElement parent = this.getTreeParent();
        if (parent == null) {
            return null;
        }
        CompositeElement first = (CompositeElement)parent.findChildByType(LOCAL_VARIABLE);
        return (PsiModifierList)first.findChildByRoleAsPsiElement(8);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    public PsiExpression getInitializer() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(21);
    }

    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    public Object computeConstantValue() {
        return this.computeConstantValue((Set<PsiVariable>)new THashSet());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiType type = this.getType();
        if (!(type instanceof PsiPrimitiveType) && !type.equalsToText("java.lang.String")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    @Override
    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        CompositeElement statement = this.getTreeParent();
        PsiElement[] variables = ((PsiDeclarationStatement)SourceTreeToPsiMap.treeElementToPsi(statement)).getDeclaredElements();
        if (variables.length > 1) {
            CompositeElement last = statement;
            for (int i = 1; i < variables.length; ++i) {
                ASTNode typeCopy = this.getTypeElement().copy().getNode();
                ASTNode modifierListCopy = this.getModifierList().copy().getNode();
                CompositeElement variable = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(variables[i]);
                ASTNode comma = TreeUtil.skipElementsBack(variable.getTreePrev(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET);
                if (comma != null && comma.getElementType() == JavaTokenType.COMMA) {
                    CodeEditUtil.removeChildren(statement, comma, variable.getTreePrev());
                }
                CodeEditUtil.removeChild(statement, variable);
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(statement);
                CompositeElement statement1 = Factory.createCompositeElement(DECLARATION_STATEMENT, charTableByTree, this.getManager());
                statement1.addChild(variable, null);
                LeafElement space = Factory.createSingleLeafElement(JavaTokenType.WHITE_SPACE, " ", 0, 1, treeCharTab, this.getManager());
                variable.addChild(space, variable.getFirstChildNode());
                variable.addChild(typeCopy, variable.getFirstChildNode());
                if (modifierListCopy.getTextLength() > 0) {
                    space = Factory.createSingleLeafElement(JavaTokenType.WHITE_SPACE, " ", 0, 1, treeCharTab, this.getManager());
                    variable.addChild(space, variable.getFirstChildNode());
                }
                variable.addChild(modifierListCopy, variable.getFirstChildNode());
                LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, treeCharTab, this.getManager());
                SourceTreeToPsiMap.psiElementToTree(variables[i - 1]).addChild((ASTNode)semicolon, null);
                CodeEditUtil.addChild(statement.getTreeParent(), statement1, last.getTreeNext());
                last = statement1;
            }
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode eq;
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.deleteChildInternal must not be null");
        }
        if (this.getChildRole(child) == 21 && (eq = this.findChildByRole(20)) != null) {
            this.deleteChildInternal(eq);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
            case 10: {
                return this.findChildByType(TYPE);
            }
            case 9: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 20: {
                return this.findChildByType(JavaTokenType.EQ);
            }
            case 21: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == MODIFIER_LIST) {
            return 8;
        }
        if (i == TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i == JavaTokenType.EQ) {
            return this.getChildRole(child, 20);
        }
        if (i == JavaTokenType.SEMICOLON) {
            return this.getChildRole(child, 22);
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 21;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLocalVariable((PsiLocalVariable)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.processDeclarations must not be null");
        }
        if (lastParent == null) {
            return true;
        }
        if (lastParent.getContext() instanceof JavaDummyHolder) {
            return processor.execute((PsiElement)this, state);
        }
        if (lastParent.getParent() != this) {
            return true;
        }
        ASTNode lastParentTree = SourceTreeToPsiMap.psiElementToTree(lastParent);
        return this.getChildRole(lastParentTree) != 21 || processor.execute((PsiElement)this, state);
    }

    @Override
    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getVariablePresentation(this);
    }

    @Override
    public String toString() {
        return "PsiLocalVariable:" + this.getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope;
        if (JspPsiUtil.isInJspFile((PsiElement)this) && this.getTreeParent().getElementType() == JavaElementType.DECLARATION_STATEMENT && this.getTreeParent().getTreeParent() instanceof JspCodeBlock && this.getTreeParent().getTreeParent().getTreeParent().getElementType() == JspElementType.HOLDER_METHOD) {
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)this);
            JspContextManager contextManager = JspContextManager.getInstance(this.getProject());
            if (contextManager == null) {
                localSearchScope = super.getUseScope();
                if (localSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getUseScope must not return null");
                return localSearchScope;
            } else {
                THashSet allIncluded = new THashSet(10);
                JspFile rootContext = contextManager.getRootContextFile(jspFile);
                allIncluded.add(rootContext);
                JspSpiUtil.visitAllIncludedFilesRecursively(rootContext, new Processor<JspFile>((Set)allIncluded){
                    final /* synthetic */ Set val$allIncluded;
                    {
                        this.val$allIncluded = set;
                    }

                    public boolean process(JspFile file) {
                        this.val$allIncluded.add(file);
                        return true;
                    }
                });
                localSearchScope = new LocalSearchScope((PsiElement[])allIncluded.toArray(new PsiFile[allIncluded.size()]));
                if (localSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getUseScope must not return null");
                return localSearchScope;
            }
        }
        PsiElement parentElement = this.getParent();
        if (parentElement instanceof PsiDeclarationStatement) {
            localSearchScope = new LocalSearchScope(parentElement.getParent());
            if (localSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getUseScope must not return null");
            return localSearchScope;
        }
        localSearchScope = this.getManager().getFileManager().getUseScope(this);
        if (localSearchScope != null) return localSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getUseScope must not return null");
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = PsiLocalVariableImpl.createLayeredIcon((Icon)Icons.VARIABLE_ICON, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    public PsiType getTypeNoResolve() {
        return this.getType();
    }
}

