/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ConstructorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.parsing.ExpressionParsing;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.SourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceExpressionImpl
extends ExpressionPsiElement
implements PsiReferenceExpression,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl");
    private volatile String myCachedQName = null;
    private volatile String myCachedTextSkipWhiteSpaceAndComments = null;
    @NonNls
    private static final String LENGTH = "length";
    private final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiReferenceExpressionImpl() {
        super(JavaElementType.REFERENCE_EXPRESSION);
    }

    public PsiExpression getQualifierExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        boolean doImportStatic;
        if (qualifierClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.bindToElementViaStaticImport must not be null");
        }
        String qualifiedName = qualifierClass.getQualifiedName();
        if (qualifiedName == null) {
            throw new IncorrectOperationException();
        }
        if (this.getQualifierExpression() != null) {
            throw new IncorrectOperationException("Reference is qualified: " + this.getText());
        }
        if (!this.isPhysical()) {
            return this;
        }
        String staticName = this.getReferenceName();
        PsiFile containingFile = this.getContainingFile();
        PsiImportList importList = null;
        if (containingFile instanceof PsiJavaFile) {
            String qName;
            importList = ((PsiJavaFile)containingFile).getImportList();
            PsiImportStatementBase singleImportStatement = importList.findSingleImportStatement(staticName);
            boolean bl = doImportStatic = singleImportStatement == null;
            if (singleImportStatement instanceof PsiImportStaticStatement && (qName = qualifierClass.getQualifiedName() + "." + staticName).equals(singleImportStatement.getImportReference().getQualifiedName())) {
                return this;
            }
        } else {
            doImportStatic = false;
        }
        if (doImportStatic) {
            this.bindToElementViaStaticImport(qualifierClass, staticName, importList);
        } else {
            PsiManager manager = this.getManager();
            PsiReferenceExpression classRef = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createReferenceExpression(qualifierClass);
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, treeCharTab, manager);
            this.addInternal(dot, dot, SourceTreeToPsiMap.psiElementToTree((PsiElement)this.getParameterList()), Boolean.TRUE);
            this.addBefore((PsiElement)classRef, SourceTreeToPsiMap.treeElementToPsi(dot));
        }
        return this;
    }

    public void bindToElementViaStaticImport(PsiClass qualifierClass, String staticName, PsiImportList importList) throws IncorrectOperationException {
        String qualifiedName = qualifierClass.getQualifiedName();
        List<PsiJavaCodeReferenceElement> refs = PsiReferenceExpressionImpl.getImportsFromClass(importList, qualifiedName);
        if (refs.size() < CodeStyleSettingsManager.getSettings((Project)this.getProject()).NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) {
            importList.add((PsiElement)JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createImportStaticStatement(qualifierClass, staticName));
        } else {
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiImportStaticStatement importStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStaticStatement.class);
                if (importStatement == null) continue;
                importStatement.delete();
            }
            importList.add((PsiElement)JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createImportStaticStatement(qualifierClass, "*"));
        }
    }

    private static List<PsiJavaCodeReferenceElement> getImportsFromClass(@NotNull PsiImportList importList, String className) {
        if (importList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getImportsFromClass must not be null");
        }
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !Comparing.strEqual((String)psiClass.getQualifiedName(), (String)className)) continue;
            array.add(staticStatement.getImportReference());
        }
        return array;
    }

    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        PsiExpression oldQualifier = this.getQualifierExpression();
        if (newQualifier == null) {
            if (oldQualifier != null) {
                this.deleteChildInternal(oldQualifier.getNode());
            }
        } else if (oldQualifier != null) {
            oldQualifier.replace((PsiElement)newQualifier);
        } else {
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            TreeElement dot = (TreeElement)this.findChildByRole(55);
            if (dot == null) {
                dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, treeCharTab, this.getManager());
                dot = this.addInternal(dot, dot, this.getFirstChildNode(), Boolean.TRUE);
            }
            this.addBefore((PsiElement)newQualifier, dot.getPsi());
        }
    }

    @Override
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public void clearCaches() {
        this.myCachedQName = null;
        this.myCachedTextSkipWhiteSpaceAndComments = null;
        super.clearCaches();
    }

    private JavaResolveResult[] resolve(IElementType parentType) {
        if (parentType == null) {
            IElementType iElementType = parentType = this.getTreeParent() != null ? this.getTreeParent().getElementType() : null;
        }
        if (parentType == JavaElementType.REFERENCE_EXPRESSION) {
            JavaResolveResult[] result = this.resolveToVariable();
            if (result.length > 0) {
                return result;
            }
            PsiElement classNameElement = this.getReferenceNameElement();
            if (!(classNameElement instanceof PsiIdentifier)) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
            result = this.resolveToClass(classNameElement);
            if (result.length > 0) {
                return result;
            }
            return this.resolveToPackage();
        }
        if (parentType == JavaElementType.METHOD_CALL_EXPRESSION) {
            return this.resolveToMethod();
        }
        return this.resolveToVariable();
    }

    private JavaResolveResult[] resolveToMethod() {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.getParent();
        MethodResolverProcessor processor = new MethodResolverProcessor(methodCall);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, (PsiCallExpression)methodCall, false);
        }
        catch (MethodProcessorSetupFailedException e) {
            return JavaResolveResult.EMPTY_ARRAY;
        }
        return processor.getResult();
    }

    private JavaResolveResult[] resolveToPackage() {
        String packageName = this.getCachedTextSkipWhiteSpaceAndComments();
        PsiManager manager = this.getManager();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(packageName);
        if (aPackage == null) {
            return JavaPsiFacade.getInstance((Project)manager.getProject()).isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
        }
        return new JavaResolveResult[]{new CandidateInfo((PsiElement)aPackage, PsiSubstitutor.EMPTY)};
    }

    private JavaResolveResult[] resolveToClass(PsiElement classNameElement) {
        String className = classNameElement.getText();
        ClassResolverProcessor processor = new ClassResolverProcessor(className, this);
        PsiScopesUtil.resolveAndWalk(processor, (PsiJavaCodeReferenceElement)this, null);
        return processor.getResult();
    }

    private JavaResolveResult[] resolveToVariable() {
        VariableResolverProcessor processor = new VariableResolverProcessor((PsiJavaCodeReferenceElement)this);
        PsiScopesUtil.resolveAndWalk(processor, (PsiJavaCodeReferenceElement)this, null);
        return processor.getResult();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        PsiManager manager = this.getManager();
        if (manager == null) {
            LOG.error("getManager() == null!");
            javaResolveResultArray = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.multiResolve must not return null");
        } else {
            ResolveResult[] results = manager.getResolveCache().resolveWithCaching(this, OurGenericsResolver.INSTANCE, true, incompleteCode);
            javaResolveResultArray = (JavaResolveResult[])results;
            if (javaResolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.multiResolve must not return null");
            return javaResolveResultArray;
        }
    }

    public String getCanonicalText() {
        PsiElement element = this.resolve();
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        return this.getCachedTextSkipWhiteSpaceAndComments();
    }

    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    public String getReferenceName() {
        PsiElement element = this.getReferenceNameElement();
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, this.ourTypeEvaluator);
    }

    public boolean isReferenceTo(PsiElement element) {
        IElementType i = this.getLastChildNode().getElementType();
        if (i == JavaTokenType.IDENTIFIER) {
            if (!(element instanceof PsiPackage)) {
                if (!(element instanceof PsiNamedElement)) {
                    return false;
                }
                String name = ((PsiNamedElement)element).getName();
                if (name == null) {
                    return false;
                }
                if (!name.equals(this.getLastChildNode().getText())) {
                    return false;
                }
            }
        } else if (i == JavaTokenType.SUPER_KEYWORD || i == JavaTokenType.THIS_KEYWORD) {
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            if (!((PsiMethod)element).isConstructor()) {
                return false;
            }
        }
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public void processVariants(PsiScopeProcessor processor) {
        OrFilter filter = new OrFilter();
        filter.addFilter(ElementClassFilter.CLASS);
        filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
        filter.addFilter(new AndFilter((ElementFilter)ElementClassFilter.METHOD, (ElementFilter)new NotFilter(new ConstructorFilter())));
        filter.addFilter(ElementClassFilter.VARIABLE);
        FilterScopeProcessor proc = new FilterScopeProcessor(filter, processor){
            private final Set<String> myVarNames;
            {
                this.myVarNames = new THashSet();
            }

            @Override
            public boolean execute(PsiElement element, ResolveState state) {
                if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                    this.myVarNames.add(((PsiVariable)element).getName());
                } else if (element instanceof PsiField && this.myVarNames.contains(((PsiVariable)element).getName())) {
                    return true;
                }
                return super.execute(element, state);
            }
        };
        PsiScopesUtil.resolveAndWalk(proc, (PsiJavaCodeReferenceElement)this, null, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            javaResolveResult = results[0];
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.advancedResolve must not return null");
            return javaResolveResult;
        }
        javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.advancedResolve must not return null");
    }

    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        return refName == null ? super.getTextOffset() : refName.getStartOffset();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.getQualifierExpression() != null) {
            return this.renameDirectly(newElementName);
        }
        JavaResolveResult resolveResult = this.advancedResolve(false);
        if (resolveResult.getElement() == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
        if (!(currentFileResolveScope instanceof PsiImportStaticStatement) || ((PsiImportStaticStatement)currentFileResolveScope).isOnDemand()) {
            return this.renameDirectly(newElementName);
        }
        PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
        String referenceName = importStaticStatement.getReferenceName();
        LOG.assertTrue(referenceName != null);
        PsiElement element = importStaticStatement.getImportReference().resolve();
        if (this.getManager().areElementsEquivalent(element, resolveResult.getElement())) {
            return this.renameDirectly(newElementName);
        }
        PsiClass psiClass = importStaticStatement.resolveTargetClass();
        if (psiClass == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        PsiReferenceExpression expression = (PsiReferenceExpression)factory.createExpressionFromText("X." + newElementName, (PsiElement)this);
        PsiReferenceExpression result = (PsiReferenceExpression)this.replace((PsiElement)expression);
        ((PsiReferenceExpression)result.getQualifierExpression()).bindToElement((PsiElement)psiClass);
        return result;
    }

    private PsiElement renameDirectly(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace((PsiElement)identifier);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.bindToElement must not be null");
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element)) {
            return this;
        }
        PsiManager manager = this.getManager();
        if (element instanceof PsiClass) {
            String qName = ((PsiClass)element).getQualifiedName();
            if (qName == null) {
                qName = ((PsiClass)element).getName();
            } else if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, this.getResolveScope()) == null) {
                return this;
            }
            boolean preserveQualification = CodeStyleSettingsManager.getSettings((Project)this.getProject()).USE_FQ_CLASS_NAMES && PsiReferenceExpressionImpl.isFullyQualified(this);
            CharTable table = SharedImplUtil.findCharTableByTree(this.getTreeParent());
            TreeElement ref = ExpressionParsing.parseExpressionText(manager, qName, 0, qName.length(), table);
            this.getTreeParent().replaceChildInternal(this, ref);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)manager.getProject());
            if (!preserveQualification) {
                ref = (TreeElement)SourceTreeToPsiMap.psiElementToTree(codeStyleManager.shortenClassReferences(SourceTreeToPsiMap.treeElementToPsi(ref), 8192));
            }
            return SourceTreeToPsiMap.treeElementToPsi(ref);
        }
        if (element instanceof PsiPackage) {
            String qName = ((PsiPackage)element).getQualifiedName();
            if (qName.length() == 0) {
                throw new IncorrectOperationException();
            }
            CharTable table = SharedImplUtil.findCharTableByTree(this.getTreeParent());
            CompositeElement ref = ExpressionParsing.parseExpressionText(manager, qName, 0, qName.length(), table);
            this.getTreeParent().replaceChildInternal(this, ref);
            return SourceTreeToPsiMap.treeElementToPsi(ref);
        }
        if ((element instanceof PsiField || element instanceof PsiMethod) && ((PsiMember)element).hasModifierProperty("static")) {
            if (!this.isPhysical()) {
                return this;
            }
            PsiMember member = (PsiMember)element;
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            CharTable table = SharedImplUtil.findCharTableByTree(this.getTreeParent());
            CompositeElement ref = ExpressionParsing.parseExpressionText(manager, qName, 0, qName.length(), table);
            this.getTreeParent().replaceChildInternal(this, ref);
            return SourceTreeToPsiMap.treeElementToPsi(ref);
        }
        throw new IncorrectOperationException(element.toString());
    }

    private static boolean isFullyQualified(CompositeElement classRef) {
        ASTNode qualifier = classRef.findChildByRole(54);
        if (qualifier == null) {
            return false;
        }
        if (qualifier.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
            return false;
        }
        PsiElement refElement = ((PsiReference)qualifier).resolve();
        return refElement instanceof PsiPackage || PsiReferenceExpressionImpl.isFullyQualified((CompositeElement)qualifier);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.deleteChildInternal must not be null");
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByRole(55);
            super.deleteChildInternal(child);
            this.deleteChildInternal(dot);
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                if (this.getChildRole(this.getLastChildNode()) == role) {
                    return this.getLastChildNode();
                }
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                if (this.getChildRole(this.getFirstChildNode()) == 54) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaTokenType.IDENTIFIER || i == JavaTokenType.THIS_KEYWORD || i == JavaTokenType.SUPER_KEYWORD) {
            return 53;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 54;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceExpression((PsiReferenceExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }

    public TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.findChildByRole(53);
        if (nameChild == null) {
            TreeElement dot = (TreeElement)this.findChildByRole(55);
            if (dot == null) {
                LOG.error(this.toString());
            }
            return new TextRange(dot.getStartOffsetInParent() + dot.getTextLength(), this.getTextLength());
        }
        return new TextRange(nameChild.getStartOffsetInParent(), this.getTextLength());
    }

    public PsiElement getElement() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] psiTypeArray;
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
            if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getTypeParameters must not return null");
            return psiTypeArray;
        }
        PsiTypeElement[] typeElements = parameterList.getTypeParameterElements();
        PsiType[] types = new PsiType[typeElements.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = typeElements[i].getType();
        }
        psiTypeArray = types;
        if (types != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getTypeParameters must not return null");
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName((String)this.getCachedTextSkipWhiteSpaceAndComments(), (boolean)false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(PsiClass targetClass) {
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getChildRole(this.getFirstChildNode()) == 54;
    }

    private String getCachedTextSkipWhiteSpaceAndComments() {
        String whiteSpaceAndComments = this.myCachedTextSkipWhiteSpaceAndComments;
        if (whiteSpaceAndComments == null) {
            this.myCachedTextSkipWhiteSpaceAndComments = whiteSpaceAndComments = SourceUtil.getTextSkipWhiteSpaceAndComments(this);
        }
        return whiteSpaceAndComments;
    }

    private static class TypeEvaluator
    implements Function<PsiReferenceExpressionImpl, PsiType> {
        private TypeEvaluator() {
        }

        public PsiType fun(PsiReferenceExpressionImpl expr) {
            PsiType ret;
            JavaResolveResult result = expr.advancedResolve(false);
            PsiElement resolve = result.getElement();
            if (resolve == null) {
                PsiType type;
                ASTNode qualifier;
                ASTNode refName = expr.findChildByRole(53);
                if (refName != null && refName.getText().equals(PsiReferenceExpressionImpl.LENGTH) && (qualifier = expr.findChildByRole(54)) != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getElementType()) && (type = ((PsiExpression)SourceTreeToPsiMap.treeElementToPsi(qualifier)).getType()) instanceof PsiArrayType) {
                    return PsiType.INT;
                }
                return null;
            }
            PsiMethod owner = null;
            if (resolve instanceof PsiVariable) {
                PsiType type = ((PsiVariable)resolve).getType();
                PsiType psiType = ret = type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type;
                if (resolve instanceof PsiField && !((PsiField)resolve).hasModifierProperty("static")) {
                    owner = ((PsiField)resolve).getContainingClass();
                }
            } else if (resolve instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)resolve;
                ret = method.getReturnType();
                owner = method;
            } else {
                return null;
            }
            if (ret == null) {
                return null;
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)expr);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (languageLevel.compareTo((Enum)LanguageLevel.JDK_1_5) >= 0) {
                if (owner != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)owner, (PsiSubstitutor)result.getSubstitutor())) {
                    return TypeConversionUtil.erasure((PsiType)ret);
                }
                PsiType substitutedType = result.getSubstitutor().substitute(ret);
                return PsiImplUtil.normalizeWildcardTypeByPosition(substitutedType, (PsiExpression)expr);
            }
            return TypeConversionUtil.erasure((PsiType)ret);
        }
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiJavaReference> {
        public static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        private static JavaResolveResult[] _resolve(boolean incompleteCode, PsiReferenceExpressionImpl expression) {
            CompositeElement treeParent = expression.getTreeParent();
            IElementType parentType = treeParent != null ? treeParent.getElementType() : null;
            JavaResolveResult[] result = expression.resolve(parentType);
            if (incompleteCode && parentType != JavaElementType.REFERENCE_EXPRESSION && result.length == 0) {
                return expression.resolve(JavaElementType.REFERENCE_EXPRESSION);
            }
            return result;
        }

        @Override
        public JavaResolveResult[] resolve(PsiJavaReference ref, boolean incompleteCode) {
            JavaResolveResult[] result = OurGenericsResolver._resolve(incompleteCode, (PsiReferenceExpressionImpl)ref);
            if (result.length > 0 && result[0].getElement() instanceof PsiClass) {
                PsiType[] parameters = ((PsiJavaCodeReferenceElement)ref).getTypeParameters();
                JavaResolveResult[] newResult = new JavaResolveResult[result.length];
                for (int i = 0; i < result.length; ++i) {
                    CandidateInfo resolveResult = (CandidateInfo)result[i];
                    newResult[i] = new CandidateInfo(resolveResult, resolveResult.getSubstitutor().putAll((PsiClass)resolveResult.getElement(), parameters));
                }
                return newResult;
            }
            return result;
        }
    }
}

