/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class SchemaPrefixReference
extends PsiReferenceBase<XmlElement> {
    private final SchemaPrefix myPrefix;
    private final PsiElement myElement;
    private final String myName;

    public SchemaPrefixReference(XmlElement element, TextRange range, String name) {
        super((PsiElement)element, range, true);
        this.myElement = element;
        this.myName = name;
        if (this.myElement instanceof XmlAttribute && ((XmlAttribute)this.myElement).isNamespaceDeclaration()) {
            this.myPrefix = new SchemaPrefix(element, range, name);
        } else {
            PsiElement declaration = XmlUtil.findNamespaceDeclaration(element.getContainingFile(), name);
            if (declaration instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)declaration;
                String prefix = attribute.getNamespacePrefix();
                TextRange textRange = TextRange.from((int)(prefix.length() + 1), (int)name.length());
                this.myPrefix = new SchemaPrefix((XmlElement)attribute, textRange, name);
            } else {
                this.myPrefix = null;
            }
        }
    }

    public PsiElement resolve() {
        return this.myPrefix;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/SchemaPrefixReference.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof SchemaPrefix && element.getContainingFile() == this.myElement.getContainingFile() && this.myName.equals(((SchemaPrefix)element).getName()) && this.myName.length() > 0;
    }

    public PsiElement handleElementRename(String name) throws IncorrectOperationException {
        if (this.myElement instanceof XmlAttribute) {
            XmlAttribute attr = (XmlAttribute)this.myElement;
            return "xmlns".equals(attr.getNamespacePrefix()) ? attr.setName(attr.getNamespacePrefix() + ":" + name) : attr.setName(name + ":" + attr.getLocalName());
        }
        if (this.myElement instanceof XmlTag) {
            XmlTag tag = (XmlTag)this.myElement;
            return tag.setName(name + ":" + tag.getLocalName());
        }
        return super.handleElementRename(name);
    }
}

