/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inCallers;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.inCallers.MethodNode;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class CallerChooser
extends DialogWrapper {
    PsiMethod myMethod;
    private final Alarm myAlarm = new Alarm();
    private MethodNode myRoot;
    private final Project myProject;
    private Tree myTree;
    private TreeSelectionListener myTreeSelectionListener;
    private Editor myCallerEditor;
    private Editor myCalleeEditor;

    public Tree getTree() {
        return this.myTree;
    }

    public CallerChooser(PsiMethod method, String title, Tree previousTree) {
        super(true);
        this.myMethod = method;
        this.myProject = this.myMethod.getProject();
        this.myTree = previousTree;
        this.setTitle(title);
        this.init();
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(false, 0.6f);
        JPanel result = new JPanel(new BorderLayout());
        if (this.myTree == null) {
            this.myTree = this.createTree();
        } else {
            CheckedTreeNode root = (CheckedTreeNode)this.myTree.getModel().getRoot();
            this.myRoot = (MethodNode)((Object)root.getFirstChild());
        }
        this.myTreeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                if (path != null) {
                    final MethodNode node = (MethodNode)((Object)path.getLastPathComponent());
                    CallerChooser.this.myAlarm.cancelAllRequests();
                    CallerChooser.this.myAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            CallerChooser.this.updateEditorTexts(node);
                        }
                    }, 300);
                }
            }
        };
        this.myTree.getSelectionModel().addTreeSelectionListener(this.myTreeSelectionListener);
        JScrollPane scrollPane = new JScrollPane((Component)this.myTree);
        splitter.setFirstComponent((JComponent)scrollPane);
        JComponent callSitesViewer = this.createCallSitesViewer();
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            selectionPath = new TreePath(this.myRoot.getPath());
            this.myTree.getSelectionModel().addSelectionPath(selectionPath);
        }
        MethodNode node = (MethodNode)((Object)selectionPath.getLastPathComponent());
        this.updateEditorTexts(node);
        splitter.setSecondComponent(callSitesViewer);
        result.add((Component)splitter);
        return result;
    }

    private void updateEditorTexts(MethodNode node) {
        PsiMethod callee;
        MethodNode parentNode = (MethodNode)((Object)node.getParent());
        final String callerText = node != this.myRoot ? this.getText(node.getMethod()) : "";
        final Document callerDocument = this.myCallerEditor.getDocument();
        final String calleeText = node != this.myRoot ? this.getText(parentNode.getMethod()) : "";
        final Document calleeDocument = this.myCalleeEditor.getDocument();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                callerDocument.setText((CharSequence)callerText);
                calleeDocument.setText((CharSequence)calleeText);
            }
        });
        PsiMethod caller = node.getMethod();
        PsiMethod psiMethod = callee = parentNode != null ? parentNode.getMethod() : null;
        if (caller != null && caller.isPhysical() && callee != null) {
            HighlightManager highlighter = HighlightManager.getInstance((Project)this.myProject);
            EditorColorsManager colorManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
            int start = this.getStartOffset(caller);
            for (PsiReference ref : ReferencesSearch.search((PsiElement)callee, (SearchScope)new LocalSearchScope((PsiElement)caller), (boolean)false)) {
                PsiElement element = ref.getElement();
                if (element == null) continue;
                highlighter.addRangeHighlight(this.myCallerEditor, element.getTextRange().getStartOffset() - start, element.getTextRange().getEndOffset() - start, attributes, false, null);
            }
        }
    }

    public void dispose() {
        this.myTree.removeTreeSelectionListener(this.myTreeSelectionListener);
        EditorFactory.getInstance().releaseEditor(this.myCallerEditor);
        EditorFactory.getInstance().releaseEditor(this.myCalleeEditor);
        super.dispose();
    }

    private String getText(PsiMethod method) {
        if (method == null) {
            return "";
        }
        PsiFile file = method.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document != null) {
            int start = document.getLineStartOffset(document.getLineNumber(method.getTextRange().getStartOffset()));
            int end = document.getLineEndOffset(document.getLineNumber(method.getTextRange().getEndOffset()));
            return document.getText().substring(start, end);
        }
        return "";
    }

    private int getStartOffset(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/changeSignature/inCallers/CallerChooser.getStartOffset must not be null");
        }
        PsiFile file = method.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        return document.getLineStartOffset(document.getLineNumber(method.getTextRange().getStartOffset()));
    }

    private JComponent createCallSitesViewer() {
        Splitter splitter = new Splitter(true);
        this.myCallerEditor = this.createEditor();
        this.myCalleeEditor = this.createEditor();
        JComponent callerComponent = this.myCallerEditor.getComponent();
        callerComponent.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"caller.chooser.caller.method")));
        splitter.setFirstComponent(callerComponent);
        JComponent calleeComponent = this.myCalleeEditor.getComponent();
        calleeComponent.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"caller.chooser.callee.method")));
        splitter.setSecondComponent(calleeComponent);
        splitter.setBorder(IdeBorderFactory.createBorder());
        return splitter;
    }

    private Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Editor editor = editorFactory.createViewer(document, this.myProject);
        ((EditorEx)editor).setHighlighter(HighlighterFactory.createHighlighter((Project)this.myProject, (FileType)StdFileTypes.JAVA));
        return editor;
    }

    private Tree createTree() {
        Runnable cancelCallback = new Runnable(){

            @Override
            public void run() {
                CallerChooser.this.close(1);
            }
        };
        MethodNode root = new MethodNode(null, (Set<PsiMethod>)new HashSet(), cancelCallback);
        this.myRoot = new MethodNode(this.myMethod, (Set<PsiMethod>)new HashSet(), cancelCallback);
        root.add((MutableTreeNode)((Object)this.myRoot));
        CheckboxTree.CheckboxTreeCellRenderer cellRenderer = new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MethodNode) {
                    ((MethodNode)((Object)value)).customizeRenderer(this.getTextRenderer());
                }
            }
        };
        CheckboxTree tree = new CheckboxTree(cellRenderer, root, new CheckboxTreeBase.CheckPolicy(false, false, true, false));
        tree.getSelectionModel().setSelectionMode(1);
        tree.getSelectionModel().setSelectionPath(new TreePath(this.myRoot.getPath()));
        return tree;
    }

    private void getSelectedMethods(Set<PsiMethod> methods) {
        MethodNode node = this.myRoot;
        CallerChooser.getSelectedMethodsInner(node, methods);
        methods.remove(node.getMethod());
    }

    private static void getSelectedMethodsInner(MethodNode node, Set<PsiMethod> allMethods) {
        if (node.isChecked()) {
            PsiMethod method = node.getMethod();
            PsiMethod[] superMethods = method.findDeepestSuperMethods();
            if (superMethods.length == 0) {
                allMethods.add(method);
            } else {
                for (PsiMethod superMethod : superMethods) {
                    allMethods.add(superMethod);
                }
            }
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                CallerChooser.getSelectedMethodsInner((MethodNode)((Object)children.nextElement()), allMethods);
            }
        }
    }

    protected void doOKAction() {
        HashSet selectedMethods = new HashSet();
        this.getSelectedMethods((Set<PsiMethod>)selectedMethods);
        this.callersChosen((Set<PsiMethod>)selectedMethods);
        super.doOKAction();
    }

    protected abstract void callersChosen(Set<PsiMethod> var1);
}

