/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractMemberInfoStorage<T extends PsiElement, C extends PsiElement, M extends MemberInfoBase<T>> {
    protected final HashMap<C, LinkedHashSet<C>> myClassToSubclassesMap = new HashMap();
    private final HashMap<C, Set<C>> myTargetClassToExtendingMap = new HashMap();
    private final HashMap<C, List<M>> myClassToMemberInfoMap = new HashMap();
    protected final C myClass;
    protected final MemberInfoBase.Filter<T> myFilter;
    private final HashMap<C, List<M>> myTargetClassToMemberInfosMap = new HashMap();
    private final HashMap<C, LinkedHashSet<M>> myTargetClassToMemberInfosListMap = new HashMap();
    private final HashMap<C, HashSet<M>> myTargetClassToDuplicatedMemberInfosMap = new HashMap();

    public AbstractMemberInfoStorage(C aClass, MemberInfoBase.Filter<T> memberInfoFilter) {
        this.myClass = aClass;
        this.buildSubClassesMap(aClass);
        this.myFilter = memberInfoFilter;
    }

    private Set<C> getAllClasses() {
        return this.myClassToSubclassesMap.keySet();
    }

    public Set<C> getExtending(C baseClass) {
        HashSet<Object> result = (HashSet<Object>)this.myTargetClassToExtendingMap.get(baseClass);
        if (result == null) {
            result = new HashSet<Object>();
            result.add(baseClass);
            Set<C> allClasses = this.getAllClasses();
            for (PsiElement aClass : allClasses) {
                if (!this.isInheritor(baseClass, aClass)) continue;
                result.add(aClass);
            }
            this.myTargetClassToExtendingMap.put(baseClass, result);
        }
        return result;
    }

    protected abstract boolean isInheritor(C var1, C var2);

    protected abstract void buildSubClassesMap(C var1);

    public List<M> getClassMemberInfos(C aClass) {
        List result = (List)this.myClassToMemberInfoMap.get(aClass);
        if (result == null) {
            ArrayList temp = new ArrayList();
            this.extractClassMembers(aClass, temp);
            result = Collections.unmodifiableList(temp);
            this.myClassToMemberInfoMap.put(aClass, result);
        }
        return result;
    }

    protected abstract void extractClassMembers(C var1, ArrayList<M> var2);

    public List<M> getMemberInfosList(C baseClass) {
        List<M> result = (List<M>)this.myTargetClassToMemberInfosMap.get(baseClass);
        if (result == null) {
            Set<M> list = this.getIntermediateClassesMemberInfosList(baseClass);
            result = Collections.unmodifiableList(new ArrayList<M>(list));
            this.myTargetClassToMemberInfosMap.put(baseClass, result);
        }
        return result;
    }

    private Set<M> getIntermediateClassesMemberInfosList(C targetClass) {
        LinkedHashSet<M> result = (LinkedHashSet<M>)this.myTargetClassToMemberInfosListMap.get(targetClass);
        if (result == null) {
            result = new LinkedHashSet<M>();
            LinkedHashSet<C> subclasses = this.getSubclasses(targetClass);
            for (PsiElement subclass : subclasses) {
                List<M> memberInfos = this.getClassMemberInfos(subclass);
                result.addAll(memberInfos);
            }
            for (PsiElement subclass : subclasses) {
                result.addAll(this.getIntermediateClassesMemberInfosList(subclass));
            }
            this.myTargetClassToMemberInfosListMap.put(targetClass, result);
        }
        return result;
    }

    protected LinkedHashSet<C> getSubclasses(C aClass) {
        LinkedHashSet result = (LinkedHashSet)this.myClassToSubclassesMap.get(aClass);
        if (result == null) {
            result = new LinkedHashSet();
            this.myClassToSubclassesMap.put(aClass, result);
        }
        return result;
    }

    public Set<M> getDuplicatedMemberInfos(C baseClass) {
        HashSet<M> result = (HashSet<M>)this.myTargetClassToDuplicatedMemberInfosMap.get(baseClass);
        if (result == null) {
            result = this.buildDuplicatedMemberInfos(baseClass);
            this.myTargetClassToDuplicatedMemberInfosMap.put(baseClass, result);
        }
        return result;
    }

    private HashSet<M> buildDuplicatedMemberInfos(C baseClass) {
        HashSet<MemberInfoBase> result = new HashSet<MemberInfoBase>();
        List<M> memberInfos = this.getMemberInfosList(baseClass);
        for (int i = 0; i < memberInfos.size(); ++i) {
            MemberInfoBase memberInfo = (MemberInfoBase)memberInfos.get(i);
            PsiElement member = memberInfo.getMember();
            for (int j = 0; j < i; ++j) {
                MemberInfoBase memberInfo1 = (MemberInfoBase)memberInfos.get(j);
                PsiElement member1 = memberInfo1.getMember();
                if (!this.memberConflict(member1, member)) continue;
                result.add(memberInfo);
            }
        }
        return result;
    }

    protected abstract boolean memberConflict(PsiElement var1, PsiElement var2);
}

