/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveDirectoryWithClassesProcessor
extends BaseRefactoringProcessor {
    private final PsiDirectory[] myDirectories;
    private PsiDirectory myTargetDirectory;
    private boolean mySearchInComments;
    private boolean mySearchInNonJavaFiles;
    private Map<PsiFile, TargetDirectoryWrapper> myFilesToMove;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private MoveCallback myMoveCallback;

    public MoveDirectoryWithClassesProcessor(Project project, PsiDirectory[] directories, PsiDirectory targetDirectory, boolean searchInComments, boolean searchInNonJavaFiles, boolean includeSelf, MoveCallback moveCallback) {
        super(project);
        this.myDirectories = directories;
        this.myTargetDirectory = targetDirectory;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
        this.myFilesToMove = new HashMap<PsiFile, TargetDirectoryWrapper>();
        for (PsiDirectory dir : directories) {
            MoveDirectoryWithClassesProcessor.collectFiles2Move(this.myFilesToMove, dir, includeSelf ? dir.getParentDirectory() : dir, this.getTargetDirectory(dir));
        }
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        PsiElement[] elements = new PsiElement[this.myFilesToMove.size()];
        PsiFile[] classes = this.myFilesToMove.keySet().toArray(new PsiFile[this.myFilesToMove.keySet().size()]);
        System.arraycopy(classes, 0, elements, 0, classes.length);
        return new MoveClassesOrPackagesViewDescriptor(elements, false, false, this.getTargetName());
    }

    protected String getTargetName() {
        return RefactoringUIUtil.getDescription((PsiElement)this.getTargetDirectory(null).getTargetDirectory(), false);
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        ArrayList<RemoveOnDemandImportStatementsUsageInfo> usages = new ArrayList<RemoveOnDemandImportStatementsUsageInfo>();
        HashSet<String> packageNames = new HashSet<String>();
        for (PsiFile psiFile : this.myFilesToMove.keySet()) {
            PsiClass[] classes;
            if (!(psiFile instanceof PsiClassOwner)) continue;
            for (PsiClass aClass : classes = ((PsiClassOwner)psiFile).getClasses()) {
                Collections.addAll(usages, MoveClassesOrPackagesUtil.findUsages((PsiElement)aClass, this.mySearchInComments, this.mySearchInNonJavaFiles, aClass.getName()));
            }
            packageNames.add(((PsiClassOwner)psiFile).getPackageName());
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        for (String packageName : packageNames) {
            PsiPackage aPackage = psiFacade.findPackage(packageName);
            if (aPackage == null) continue;
            boolean remainsNothing = true;
            for (PsiDirectory packageDirectory : aPackage.getDirectories()) {
                if (this.isUnderRefactoring(packageDirectory)) continue;
                remainsNothing = false;
                break;
            }
            if (!remainsNothing) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aPackage)) {
                PsiElement element = reference.getElement();
                PsiImportStatementBase statementBase = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatementBase.class);
                if (statementBase == null || !statementBase.isOnDemand()) continue;
                usages.add(new RemoveOnDemandImportStatementsUsageInfo(statementBase));
            }
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usages.toArray(new UsageInfo[usages.size()]));
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    private boolean isUnderRefactoring(PsiDirectory packageDirectory) {
        for (PsiDirectory directory : this.myDirectories) {
            if (!PsiTreeUtil.isAncestor((PsiElement)directory, (PsiElement)packageDirectory, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        for (PsiFile psiFile : this.myFilesToMove.keySet()) {
            try {
                this.myFilesToMove.get(psiFile).checkMove(psiFile);
            }
            catch (IncorrectOperationException e) {
                conflicts.putValue((Object)psiFile, (Object)e.getMessage());
            }
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
    }

    @Override
    public void performRefactoring(UsageInfo[] usages) {
        try {
            for (PsiDirectory directory : this.myDirectories) {
                this.getTargetDirectory(directory).findOrCreateTargetDirectory();
            }
            for (PsiFile psiFile : this.myFilesToMove.keySet()) {
                this.myFilesToMove.get(psiFile).findOrCreateTargetDirectory();
            }
        }
        catch (IncorrectOperationException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            return;
        }
        HashMap<PsiElement, PsiElement> oldToNewElementsMapping = new HashMap<PsiElement, PsiElement>();
        for (PsiFile psiFile : this.myFilesToMove.keySet()) {
            ChangeContextUtil.encodeContextInfo((PsiElement)psiFile, true);
            RefactoringElementListener listener = this.getTransaction().getElementListener((PsiElement)psiFile);
            PsiDirectory psiDirectory = this.myFilesToMove.get(psiFile).getTargetDirectory();
            if (psiFile instanceof PsiClassOwner) {
                for (PsiClass psiClass : ((PsiClassOwner)psiFile).getClasses()) {
                    PsiClass newClass = MoveClassesOrPackagesUtil.doMoveClass(psiClass, psiDirectory);
                    oldToNewElementsMapping.put((PsiElement)psiClass, (PsiElement)newClass);
                    listener.elementMoved((PsiElement)newClass);
                }
                continue;
            }
            if (psiDirectory.equals(psiFile.getContainingDirectory())) continue;
            psiFile.getManager().moveFile(psiFile, psiDirectory);
            listener.elementMoved((PsiElement)psiFile);
        }
        for (PsiElement newElement : oldToNewElementsMapping.values()) {
            ChangeContextUtil.decodeContextInfo(newElement, null, null);
        }
        this.myNonCodeUsages = MoveClassesOrPackagesProcessor.retargetUsages(usages, oldToNewElementsMapping);
        for (UsageInfo usageInfo : usages) {
            PsiElement element;
            if (!(usageInfo instanceof RemoveOnDemandImportStatementsUsageInfo) || (element = usageInfo.getElement()) == null) continue;
            element.delete();
        }
        for (UsageInfo usageInfo : this.myDirectories) {
            usageInfo.delete();
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        if (this.myMoveCallback != null) {
            this.myMoveCallback.refactoringCompleted();
        }
    }

    private static void collectFiles2Move(Map<PsiFile, TargetDirectoryWrapper> files2Move, PsiDirectory directory, PsiDirectory rootDirectory, @NotNull TargetDirectoryWrapper targetDirectory) {
        if (targetDirectory == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor.collectFiles2Move must not be null");
        }
        PsiElement[] children = directory.getChildren();
        String relativePath = VfsUtil.getRelativePath((VirtualFile)directory.getVirtualFile(), (VirtualFile)rootDirectory.getVirtualFile(), (char)'/');
        TargetDirectoryWrapper newTargetDirectory = relativePath.length() == 0 ? targetDirectory : targetDirectory.findOrCreateChild(relativePath);
        for (PsiElement child : children) {
            if (child instanceof PsiFile) {
                files2Move.put((PsiFile)child, newTargetDirectory);
                continue;
            }
            if (!(child instanceof PsiDirectory)) continue;
            MoveDirectoryWithClassesProcessor.collectFiles2Move(files2Move, (PsiDirectory)child, directory, newTargetDirectory);
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"moving.directories.command");
    }

    public TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
        return new TargetDirectoryWrapper(this.myTargetDirectory);
    }

    public static class TargetDirectoryWrapper {
        private TargetDirectoryWrapper myParentDirectory;
        private PsiDirectory myTargetDirectory;
        private String myRelativePath;

        public TargetDirectoryWrapper(PsiDirectory targetDirectory) {
            this.myTargetDirectory = targetDirectory;
        }

        public TargetDirectoryWrapper(TargetDirectoryWrapper parentDirectory, String relativePath) {
            this.myParentDirectory = parentDirectory;
            this.myRelativePath = relativePath;
        }

        public TargetDirectoryWrapper(PsiDirectory parentDirectory, String relativePath) {
            this.myTargetDirectory = parentDirectory.findSubdirectory(relativePath);
            this.myParentDirectory = new TargetDirectoryWrapper(parentDirectory);
            this.myRelativePath = relativePath;
        }

        public PsiDirectory findOrCreateTargetDirectory() throws IncorrectOperationException {
            if (this.myTargetDirectory == null) {
                PsiDirectory root = this.myParentDirectory.findOrCreateTargetDirectory();
                this.myTargetDirectory = root.findSubdirectory(this.myRelativePath);
                if (this.myTargetDirectory == null) {
                    this.myTargetDirectory = root.createSubdirectory(this.myRelativePath);
                }
            }
            return this.myTargetDirectory;
        }

        @Nullable
        public PsiDirectory getTargetDirectory() {
            return this.myTargetDirectory;
        }

        public TargetDirectoryWrapper findOrCreateChild(String relativePath) {
            PsiDirectory psiDirectory;
            if (this.myTargetDirectory != null && (psiDirectory = this.myTargetDirectory.findSubdirectory(relativePath)) != null) {
                return new TargetDirectoryWrapper(psiDirectory);
            }
            return new TargetDirectoryWrapper(this, relativePath);
        }

        public void checkMove(PsiFile psiFile) throws IncorrectOperationException {
            if (this.myTargetDirectory != null) {
                psiFile.getManager().checkMove((PsiElement)psiFile, (PsiElement)this.myTargetDirectory);
            }
        }
    }

    private static class RemoveOnDemandImportStatementsUsageInfo
    extends UsageInfo {
        public RemoveOnDemandImportStatementsUsageInfo(PsiImportStatementBase statementBase) {
            super((PsiElement)statementBase);
        }
    }
}

