/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.tools.ToolsProcessor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolManager
implements ExportableApplicationComponent {
    private final ActionManagerEx myActionManager;
    private final SchemesManager<ToolsGroup, ToolsGroup> mySchemesManager;

    public static ToolManager getInstance() {
        return (ToolManager)ApplicationManager.getApplication().getComponent(ToolManager.class);
    }

    public ToolManager(ActionManagerEx actionManagerEx, SchemesManagerFactory factory) {
        this.myActionManager = actionManagerEx;
        this.mySchemesManager = factory.createSchemesManager("$ROOT_CONFIG$/tools", (SchemeProcessor)new ToolsProcessor(), RoamingType.PER_USER);
        this.mySchemesManager.loadSchemes();
        this.registerActions();
    }

    @Nullable
    public static String convertString(String s) {
        if (s != null && s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{this.mySchemesManager.getRootDirectory()};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/tools/ToolManager.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ToolsBundle.message("tools.settings", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/tools/ToolManager.getPresentableName must not return null");
        }
        return string;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public Tool[] getTools() {
        ArrayList result = new ArrayList();
        for (ToolsGroup group : this.mySchemesManager.getAllSchemes()) {
            result.addAll(group.getElements());
        }
        return result.toArray(new Tool[result.size()]);
    }

    public Tool[] getTools(String group) {
        ArrayList list = new ArrayList();
        ToolsGroup groupByName = (ToolsGroup)this.mySchemesManager.findSchemeByName(group);
        if (groupByName != null) {
            list.addAll(groupByName.getElements());
        }
        return list.toArray(new Tool[list.size()]);
    }

    String[] getGroups(Tool[] tools) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tools.length; ++i) {
            Tool tool = tools[i];
            if (list.contains(tool.getGroup())) continue;
            list.add(tool.getGroup());
        }
        return ArrayUtil.toStringArray(list);
    }

    public String getGroupByActionId(String actionId) {
        for (Tool tool : this.getTools()) {
            if (!Comparing.equal((String)actionId, (String)tool.getActionId())) continue;
            return tool.getGroup();
        }
        return null;
    }

    public ToolsGroup[] getGroups() {
        List groups = this.mySchemesManager.getAllSchemes();
        return groups.toArray(new ToolsGroup[groups.size()]);
    }

    public void setTools(ToolsGroup[] tools) {
        this.mySchemesManager.clearAllSchemes();
        for (ToolsGroup newGroup : tools) {
            this.mySchemesManager.addNewScheme((Scheme)newGroup, true);
        }
        this.registerActions();
    }

    void registerActions() {
        this.unregisterActions();
        HashSet<String> registeredIds = new HashSet<String>();
        Tool[] tools = this.getTools();
        for (int i = 0; i < tools.length; ++i) {
            Tool tool = tools[i];
            String actionId = tool.getActionId();
            if (registeredIds.contains(actionId)) continue;
            registeredIds.add(actionId);
            this.myActionManager.registerAction(actionId, new ToolAction(tool));
        }
    }

    private void unregisterActions() {
        String[] oldIds = this.myActionManager.getActionIds("Tool_");
        for (int i = 0; i < oldIds.length; ++i) {
            String oldId = oldIds[i];
            this.myActionManager.unregisterAction(oldId);
        }
    }

    public String getComponentName() {
        return "ToolManager";
    }
}

