/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.tabs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

public abstract class TabbedContentAction
extends AnAction
implements DumbAware {
    protected final ContentManager myManager;
    protected final ShadowAction myShadow;

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction shortcutTemplate, @NotNull String text) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/tabs/TabbedContentAction.<init> must not be null");
        }
        if (shortcutTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/content/tabs/TabbedContentAction.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ui/content/tabs/TabbedContentAction.<init> must not be null");
        }
        super(text);
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, shortcutTemplate, manager.getComponent(), new Presentation(text));
    }

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction template) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/tabs/TabbedContentAction.<init> must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/content/tabs/TabbedContentAction.<init> must not be null");
        }
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, template, manager.getComponent());
    }

    public static class MyPreviousTabAction
    extends TabbedContentAction {
        public MyPreviousTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("PreviousTab"));
        }

        public void actionPerformed(AnActionEvent e) {
            this.myManager.selectPreviousContent();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myManager.getContentCount() > 1);
        }
    }

    public static class MyNextTabAction
    extends TabbedContentAction {
        public MyNextTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("NextTab"));
        }

        public void actionPerformed(AnActionEvent e) {
            this.myManager.selectNextContent();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myManager.getContentCount() > 1);
        }
    }

    public static class CloseAllAction
    extends TabbedContentAction {
        public CloseAllAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("CloseAllEditors"), UIBundle.message((String)"tabbed.pane.close.all.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (!content.isCloseable()) continue;
                this.myManager.removeContent(content, true);
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(this.myManager.canCloseAllContents());
            presentation.setVisible(this.myManager.canCloseAllContents());
        }
    }

    public static class CloseAllButThisAction
    extends ForContent {
        public CloseAllButThisAction(Content content) {
            super(content, ActionManager.getInstance().getAction("CloseAllEditorsButActive"), UIBundle.message((String)"tabbed.pane.close.all.but.this.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (this.myContent == content || !content.isCloseable()) continue;
                this.myManager.removeContent(content, true);
            }
            this.myManager.setSelectedContent(this.myContent);
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setText(this.myManager.getCloseAllButThisActionName());
            presentation.setEnabled(this.myContent != null && this.myManager.canCloseContents() && this.myManager.getContentCount() > 1);
            presentation.setVisible(this.myManager.canCloseContents() && this.hasCloseableContents());
        }

        private boolean hasCloseableContents() {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (this.myContent == content || !content.isCloseable()) continue;
                return true;
            }
            return false;
        }
    }

    public static class CloseAction
    extends ForContent {
        public CloseAction(Content content) {
            super(content, ActionManager.getInstance().getAction("CloseActiveTab"));
        }

        public void actionPerformed(AnActionEvent e) {
            this.myManager.removeContent(this.myContent, true);
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(this.myContent != null && this.myManager.canCloseContents() && this.myContent.isCloseable() && this.myManager.isSelected(this.myContent));
            presentation.setVisible(this.myManager.canCloseContents() && this.myContent.isCloseable());
            presentation.setText(this.myManager.getCloseActionName());
        }
    }

    public static abstract class ForContent
    extends TabbedContentAction {
        protected final Content myContent;

        public ForContent(@NotNull Content content, @NotNull AnAction shortcutTemplate, String text) {
            if (content == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/tabs/TabbedContentAction$ForContent.<init> must not be null");
            }
            if (shortcutTemplate == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/content/tabs/TabbedContentAction$ForContent.<init> must not be null");
            }
            super(content.getManager(), shortcutTemplate, text);
            this.myContent = content;
            Disposer.register((Disposable)content, (Disposable)this.myShadow);
        }

        public ForContent(@NotNull Content content, AnAction template) {
            if (content == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/tabs/TabbedContentAction$ForContent.<init> must not be null");
            }
            super(content.getManager(), template);
            this.myContent = content;
            Disposer.register((Disposable)content, (Disposable)this.myShadow);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myManager.getIndexOfContent(this.myContent) >= 0);
        }
    }
}

