/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.growl;

import com.intellij.ui.growl.Foundation;
import com.intellij.ui.growl.ID;
import com.intellij.ui.growl.Selector;
import org.jetbrains.annotations.NotNull;

public class Growl {
    private static final String GROWL_APPLICATION_REGISTRATION_NOTIFICATION = "GrowlApplicationRegistrationNotification";
    private static final String GROWL_APP_NAME = "ApplicationName";
    private static final String GROWL_APP_ICON = "ApplicationIcon";
    private static final String GROWL_DEFAULT_NOTIFICATIONS = "DefaultNotifications";
    private static final String GROWL_ALL_NOTIFICATIONS = "AllNotifications";
    private static final String GROWL_NOTIFICATION_NAME = "NotificationName";
    private static final String GROWL_NOTIFICATION_TITLE = "NotificationTitle";
    private static final String GROWL_NOTIFICATION_DESCRIPTION = "NotificationDescription";
    private static final String GROWL_NOTIFICATION = "GrowlNotification";
    private final String myProductName;
    private String[] myAllNotifications;
    private String[] myDefaultNotification;

    public Growl(@NotNull String productName) {
        if (productName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/growl/Growl.<init> must not be null");
        }
        this.myProductName = productName;
    }

    public void register() {
        ID autoReleasePool = Growl.createAutoReleasePool();
        ID applicationIcon = Growl.getApplicationIcon();
        ID defaultNotifications = Growl.fillArray(this.myDefaultNotification);
        ID allNotifications = Growl.fillArray(this.myAllNotifications);
        ID userDict = Growl.createDict(new String[]{GROWL_APP_NAME, GROWL_APP_ICON, GROWL_DEFAULT_NOTIFICATIONS, GROWL_ALL_NOTIFICATIONS}, new Object[]{this.myProductName, applicationIcon, defaultNotifications, allNotifications});
        ID center = Growl.invoke("NSDistributedNotificationCenter", "defaultCenter", new Object[0]);
        Object notificationName = Foundation.cfString(GROWL_APPLICATION_REGISTRATION_NOTIFICATION).toNative();
        Growl.invoke(center, "postNotificationName:object:userInfo:deliverImmediately:", new Object[]{notificationName, null, userDict, true});
        Growl.invoke(autoReleasePool, "release", new Object[0]);
    }

    public void notifyGrowlOf(String notification, String title, String description) {
        ID autoReleasePool = Growl.createAutoReleasePool();
        ID dict = Growl.createDict(new String[]{GROWL_NOTIFICATION_NAME, GROWL_NOTIFICATION_TITLE, GROWL_NOTIFICATION_DESCRIPTION, GROWL_APP_NAME}, new Object[]{notification, title, description, this.myProductName});
        ID center = Growl.invoke("NSDistributedNotificationCenter", "defaultCenter", new Object[0]);
        Object notificationName = Foundation.cfString(GROWL_NOTIFICATION).toNative();
        Growl.invoke(center, "postNotificationName:object:userInfo:deliverImmediately:", new Object[]{notificationName, null, dict, true});
        Growl.invoke(autoReleasePool, "release", new Object[0]);
    }

    public void setAllowedNotifications(String[] allNotifications) {
        this.myAllNotifications = allNotifications;
    }

    public void setDefaultNotifications(String[] defaultNotification) {
        this.myDefaultNotification = defaultNotification;
    }

    private static ID createAutoReleasePool() {
        return Growl.invoke("NSAutoreleasePool", "new", new Object[0]);
    }

    private static ID fillArray(Object[] a) {
        ID result = Growl.invoke("NSMutableArray", "array", new Object[0]);
        for (Object s : a) {
            Growl.invoke(result, "addObject:", Growl.convertType(s));
        }
        return result;
    }

    private static ID createDict(@NotNull String[] keys, @NotNull Object[] values) {
        if (keys == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/growl/Growl.createDict must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/growl/Growl.createDict must not be null");
        }
        ID nsKeys = Growl.invoke("NSArray", "arrayWithObjects:", Growl.convertTypes(keys));
        ID nsData = Growl.invoke("NSArray", "arrayWithObjects:", Growl.convertTypes(values));
        return Growl.invoke("NSDictionary", "dictionaryWithObjects:forKeys:", new Object[]{nsData, nsKeys});
    }

    private static Object convertType(Object o) {
        if (o instanceof ID) {
            return o;
        }
        if (o instanceof String) {
            return Foundation.cfString((String)o).toNative();
        }
        throw new IllegalArgumentException("Unsupported type! " + o.getClass());
    }

    private static Object[] convertTypes(@NotNull Object[] v) {
        if (v == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/growl/Growl.convertTypes must not be null");
        }
        Object[] result = new Object[v.length];
        for (int i = 0; i < v.length; ++i) {
            result[i] = Growl.convertType(v[i]);
        }
        return result;
    }

    private static ID getApplicationIcon() {
        ID sharedApp = Growl.invoke("NSApplication", "sharedApplication", new Object[0]);
        ID nsImage = Growl.invoke(sharedApp, "applicationIconImage", new Object[0]);
        return Growl.invoke(nsImage, "TIFFRepresentation", new Object[0]);
    }

    private static ID invoke(@NotNull String className, @NotNull String selector, Object ... args) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/growl/Growl.invoke must not be null");
        }
        if (selector == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/growl/Growl.invoke must not be null");
        }
        return Growl.invoke(Foundation.getClass(className), selector, args);
    }

    private static ID invoke(@NotNull ID id, @NotNull String selector, Object ... args) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/growl/Growl.invoke must not be null");
        }
        if (selector == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/growl/Growl.invoke must not be null");
        }
        return Growl.invoke(id, Foundation.createSelector(selector), args);
    }

    private static ID invoke(@NotNull ID id, @NotNull Selector selector, Object ... args) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/growl/Growl.invoke must not be null");
        }
        if (selector == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/growl/Growl.invoke must not be null");
        }
        return Foundation.invoke(id, selector, args);
    }
}

