/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.notification.impl.ui.StickyButton;
import com.intellij.notification.impl.ui.StickyButtonUI;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileColorConfigurationEditDialog
extends DialogWrapper {
    private FileColorConfiguration myConfiguration;
    private JComboBox myScopeComboBox;
    private FileColorManagerImpl myManager;
    private HashMap<String, AbstractButton> myColorToButtonMap;

    public FileColorConfigurationEditDialog(@NotNull FileColorManagerImpl manager, @Nullable FileColorConfiguration configuration) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorConfigurationEditDialog.<init> must not be null");
        }
        super(true);
        this.setTitle(configuration == null ? "Add color label" : "Edit color label");
        this.setResizable(false);
        this.myManager = manager;
        this.myConfiguration = configuration;
        this.init();
        this.updateOKButton();
    }

    protected JComponent createNorthPanel() {
        NamedScopesHolder[] scopeHolders;
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        ArrayList<String> scopeNames = new ArrayList<String>();
        for (NamedScopesHolder scopeHolder : scopeHolders = NamedScopeManager.getAllNamedScopeHolders((Project)this.myManager.getProject())) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = scopeHolder.getScopes()) {
                scopeNames.add(scope.getName());
            }
        }
        this.myScopeComboBox = new JComboBox<String>(ArrayUtil.toStringArray(scopeNames));
        this.myScopeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileColorConfigurationEditDialog.this.updateOKButton();
            }
        });
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new BorderLayout());
        JLabel pathLabel = new JLabel("Scope:");
        pathLabel.setDisplayedMnemonic('S');
        pathLabel.setLabelFor(this.myScopeComboBox);
        pathPanel.add((Component)pathLabel, "West");
        pathPanel.add((Component)this.myScopeComboBox, "Center");
        result.add(pathPanel);
        JPanel colorPanel = new JPanel();
        colorPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        JLabel colorLabel = new JLabel("Color:");
        colorPanel.add(colorLabel);
        colorPanel.add(this.createColorButtonsPanel(this.myConfiguration));
        colorPanel.add(Box.createHorizontalGlue());
        result.add(colorPanel);
        return result;
    }

    protected void doOKAction() {
        this.close(0);
        if (this.myConfiguration != null) {
            this.myConfiguration.setScopeName((String)this.myScopeComboBox.getSelectedItem());
            this.myConfiguration.setColorName(this.getColorName());
        } else {
            this.myConfiguration = new FileColorConfiguration((String)this.myScopeComboBox.getSelectedItem(), this.getColorName());
        }
    }

    public FileColorConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    private JComponent createColorButtonsPanel(FileColorConfiguration configuration) {
        AbstractButton button;
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel inner = new JPanel();
        inner.setLayout(new BoxLayout(inner, 0));
        inner.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        inner.setBackground(Color.WHITE);
        result.add((Component)inner, "Center");
        ButtonGroup group = new ButtonGroup();
        this.myColorToButtonMap = new HashMap();
        Collection<String> names = this.myManager.getColorNames();
        for (String name : names) {
            ColorButton colorButton = new ColorButton(name, this.myManager.getColor(name));
            colorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileColorConfigurationEditDialog.this.updateOKButton();
                }
            });
            colorButton.setBackground(Color.WHITE);
            colorButton.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            group.add(colorButton);
            inner.add(colorButton);
            this.myColorToButtonMap.put((Object)name, (Object)colorButton);
            inner.add(Box.createHorizontalStrut(5));
        }
        if (configuration != null && (button = (AbstractButton)this.myColorToButtonMap.get((Object)configuration.getColorName())) != null) {
            button.setSelected(true);
        }
        return result;
    }

    private String getColorName() {
        for (String name : this.myColorToButtonMap.keySet()) {
            AbstractButton button = (AbstractButton)this.myColorToButtonMap.get((Object)name);
            if (!button.isSelected()) continue;
            return name;
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myScopeComboBox;
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    public boolean isOKActionEnabled() {
        String scopeName = (String)this.myScopeComboBox.getSelectedItem();
        return scopeName != null && scopeName.length() > 0 && this.getColorName() != null;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private class ColorButtonUI
    extends StickyButtonUI<ColorButton> {
        private ColorButtonUI() {
        }

        @Override
        protected Color getBackgroundColor(ColorButton button) {
            return button.getColor();
        }

        @Override
        protected Color getFocusColor(ColorButton button) {
            return button.getColor().darker();
        }

        @Override
        protected Color getSelectionColor(ColorButton button) {
            return button.getColor();
        }

        @Override
        protected Color getRolloverColor(ColorButton button) {
            return button.getColor();
        }

        @Override
        protected int getArcSize() {
            return 20;
        }
    }

    private class ColorButton
    extends StickyButton {
        private Color myColor;

        private ColorButton(String text, Color color) {
            super(text);
            this.setUI(new ColorButtonUI());
            this.myColor = color;
        }

        Color getColor() {
            return this.myColor;
        }

        @Override
        public Color getForeground() {
            if (this.getModel().isSelected()) {
                return Color.BLACK;
            }
            if (this.getModel().isRollover()) {
                return Color.GRAY;
            }
            return this.getColor();
        }

        @Override
        protected ButtonUI createUI() {
            return new ColorButtonUI();
        }
    }
}

