/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.util.Collection;

public class FileBasedIndexProjectHandler
extends AbstractProjectComponent
implements IndexableFileSet {
    private final FileBasedIndex myIndex;
    private final ProjectRootManagerEx myRootManager;
    private final FileTypeManager myFileTypeManager;

    public FileBasedIndexProjectHandler(final FileBasedIndex index, final Project project, final ProjectRootManagerEx rootManager, FileTypeManager ftManager, final ProjectManager projectManager) {
        super(project);
        this.myIndex = index;
        this.myRootManager = rootManager;
        this.myFileTypeManager = ftManager;
        final StartupManagerEx startupManager = (StartupManagerEx)StartupManager.getInstance((Project)project);
        if (startupManager != null) {
            startupManager.registerPreStartupActivity(new Runnable(){

                @Override
                public void run() {
                    final RefreshCacheUpdater refreshUpdater = new RefreshCacheUpdater();
                    final UnindexedFilesUpdater rootsChangeUpdater = new UnindexedFilesUpdater(project, index);
                    startupManager.registerCacheUpdater(rootsChangeUpdater);
                    rootManager.registerRootsChangeUpdater(rootsChangeUpdater);
                    rootManager.registerRefreshUpdater(refreshUpdater);
                    FileBasedIndexProjectHandler.this.myIndex.registerIndexableSet(FileBasedIndexProjectHandler.this);
                    projectManager.addProjectManagerListener(project, (ProjectManagerListener)new ProjectManagerAdapter(){

                        public void projectClosing(Project project) {
                            rootManager.unregisterRefreshUpdater(refreshUpdater);
                            rootManager.unregisterRootsChangeUpdater(rootsChangeUpdater);
                            FileBasedIndexProjectHandler.this.myIndex.removeIndexableSet(FileBasedIndexProjectHandler.this);
                        }
                    });
                }
            });
        }
    }

    @Override
    public boolean isInSet(VirtualFile file) {
        ProjectFileIndex index = this.myRootManager.getFileIndex();
        if (index.isInContent(file) || index.isInLibraryClasses(file) || index.isInLibrarySource(file)) {
            return !this.myFileTypeManager.isFileIgnored(file.getName());
        }
        return false;
    }

    @Override
    public void iterateIndexableFilesIn(VirtualFile file, ContentIterator iterator) {
        if (!this.isInSet(file)) {
            return;
        }
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                this.iterateIndexableFilesIn(child, iterator);
            }
        } else {
            iterator.processFile(file);
        }
    }

    public void disposeComponent() {
        this.myIndex.removeIndexableSet(this);
    }

    private class RefreshCacheUpdater
    implements CacheUpdater {
        private RefreshCacheUpdater() {
        }

        public int getNumberOfPendingUpdateJobs() {
            return FileBasedIndexProjectHandler.this.myIndex.getNumberOfPendingInvalidations();
        }

        public VirtualFile[] queryNeededFiles() {
            Collection<VirtualFile> files = FileBasedIndexProjectHandler.this.myIndex.getFilesToUpdate(FileBasedIndexProjectHandler.this.myProject);
            return VfsUtil.toVirtualFileArray(files);
        }

        public void processFile(FileContent fileContent) {
            FileBasedIndexProjectHandler.this.myIndex.processRefreshedFile(FileBasedIndexProjectHandler.this.myProject, fileContent);
        }

        public void updatingDone() {
        }

        public void canceled() {
        }
    }
}

