/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.reference.SoftReference;
import com.intellij.xml.actions.ValidateXmlActionHandler;
import com.intellij.xml.util.XmlResourceResolver;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.xml.sax.SAXParseException;

public class ExternalDocumentValidator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.impl.ExternalDocumentValidator");
    private static final Key<SoftReference<ExternalDocumentValidator>> validatorInstanceKey = Key.create((String)"validatorInstance");
    private ValidateXmlActionHandler myHandler;
    private Validator.ValidationHost myHost;
    private long myModificationStamp;
    private PsiFile myFile;
    @NonNls
    private static final String CANNOT_FIND_DECLARATION_ERROR_PREFIX = "Cannot find the declaration of element";
    @NonNls
    private static final String ELEMENT_ERROR_PREFIX = "Element";
    @NonNls
    private static final String ROOT_ELEMENT_ERROR_PREFIX = "Document root element";
    @NonNls
    private static final String CONTENT_OF_ELEMENT_TYPE_ERROR_PREFIX = "The content of element type";
    @NonNls
    private static final String VALUE_ERROR_PREFIX = "Value ";
    @NonNls
    private static final String ATTRIBUTE_ERROR_PREFIX = "Attribute ";
    @NonNls
    private static final String STRING_ERROR_PREFIX = "The string";
    @NonNls
    private static final String ATTRIBUTE_MESSAGE_PREFIX = "cvc-attribute.";
    private WeakReference<List<ValidationInfo>> myInfos;

    private void runJaxpValidation(XmlElement element, Validator.ValidationHost host) {
        Project project;
        Document document;
        final PsiFile file = element.getContainingFile();
        if (this.myFile == file && file != null && this.myModificationStamp == file.getModificationStamp() && !ValidateXmlActionHandler.isValidationDependentFilesOutOfDate((XmlFile)file) && this.myInfos != null && this.myInfos.get() != null) {
            ExternalDocumentValidator.addAllInfos(host, (List)this.myInfos.get());
            return;
        }
        if (this.myHandler == null) {
            this.myHandler = new ValidateXmlActionHandler(false);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = element.getProject())).getDocument(file)) == null) {
            return;
        }
        final LinkedList<ValidationInfo> results = new LinkedList<ValidationInfo>();
        this.myHost = new Validator.ValidationHost(){

            @Override
            public void addMessage(PsiElement context, String message, int type) {
                ValidationInfo o = new ValidationInfo();
                results.add(o);
                o.element = context;
                o.message = message;
                o.type = type;
            }

            @Override
            public void addMessage(PsiElement context, String message, Validator.ValidationHost.ErrorType type, IntentionAction ... fixes) {
                this.addMessage(context, message, type.ordinal());
            }
        };
        ValidateXmlActionHandler validateXmlActionHandler = this.myHandler;
        validateXmlActionHandler.getClass();
        this.myHandler.setErrorReporter(new ValidateXmlActionHandler.ErrorReporter(validateXmlActionHandler){

            @Override
            public boolean isStopOnUndeclaredResource() {
                return true;
            }

            @Override
            public void processError(final SAXParseException e, final boolean warning) {
                try {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiElement currentElement;
                            if (e.getPublicId() != null) {
                                return;
                            }
                            VirtualFile errorFile = ExternalDocumentValidator.this.myHandler.getFile(e.getPublicId(), e.getSystemId());
                            if (errorFile != file.getVirtualFile() && errorFile != null) {
                                return;
                            }
                            if (document.getLineCount() < e.getLineNumber() || e.getLineNumber() <= 0) {
                                return;
                            }
                            int offset = Math.max(0, document.getLineStartOffset(e.getLineNumber() - 1) + e.getColumnNumber() - 2);
                            if (offset >= document.getTextLength()) {
                                return;
                            }
                            PsiElement originalElement = currentElement = PsiDocumentManager.getInstance((Project)project).getPsiFile(document).findElementAt(offset);
                            String elementText = currentElement.getText();
                            if (elementText.equals("</")) {
                                currentElement = currentElement.getNextSibling();
                            } else if (elementText.equals(">") || elementText.equals("=")) {
                                currentElement = currentElement.getPrevSibling();
                            }
                            String localizedMessage = e.getLocalizedMessage();
                            int endIndex = localizedMessage.indexOf(58);
                            if (endIndex < localizedMessage.length() - 1 && localizedMessage.charAt(endIndex + 1) == '/') {
                                endIndex = -1;
                            }
                            String messageId = endIndex != -1 ? localizedMessage.substring(0, endIndex) : "";
                            if ((localizedMessage = localizedMessage.substring(endIndex + 1).trim()).startsWith(ExternalDocumentValidator.CANNOT_FIND_DECLARATION_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.ELEMENT_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.ROOT_ELEMENT_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.CONTENT_OF_ELEMENT_TYPE_ERROR_PREFIX)) {
                                ExternalDocumentValidator.this.addProblemToTagName(currentElement, originalElement, localizedMessage, warning);
                            } else if (localizedMessage.startsWith(ExternalDocumentValidator.VALUE_ERROR_PREFIX)) {
                                ExternalDocumentValidator.this.addProblemToTagName(currentElement, originalElement, localizedMessage, warning);
                            } else if (messageId.startsWith(ExternalDocumentValidator.ATTRIBUTE_MESSAGE_PREFIX)) {
                                String prefix = "of attribute ";
                                int i = localizedMessage.indexOf(prefix);
                                if (i != -1) {
                                    int messagePrefixLength = prefix.length() + i;
                                    int nextQuoteIndex = localizedMessage.indexOf(localizedMessage.charAt(messagePrefixLength), messagePrefixLength + 1);
                                    String attrName = nextQuoteIndex == -1 ? null : localizedMessage.substring(messagePrefixLength + 1, nextQuoteIndex);
                                    XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
                                    currentElement = parent.getAttribute(attrName, null);
                                    if (currentElement != null) {
                                        currentElement = ((XmlAttribute)currentElement).getValueElement();
                                    }
                                }
                                if (currentElement != null) {
                                    ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                                    ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, warning ? 0 : 1);
                                } else {
                                    ExternalDocumentValidator.this.addProblemToTagName(originalElement, originalElement, localizedMessage, warning);
                                }
                            } else if (localizedMessage.startsWith(ExternalDocumentValidator.ATTRIBUTE_ERROR_PREFIX)) {
                                int messagePrefixLength = ExternalDocumentValidator.ATTRIBUTE_ERROR_PREFIX.length();
                                if (localizedMessage.charAt(messagePrefixLength) == '\"' || localizedMessage.charAt(messagePrefixLength) == '\'') {
                                    int nextQuoteIndex = localizedMessage.indexOf(localizedMessage.charAt(messagePrefixLength), messagePrefixLength + 1);
                                    String attrName = nextQuoteIndex == -1 ? null : localizedMessage.substring(messagePrefixLength + 1, nextQuoteIndex);
                                    XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
                                    currentElement = parent.getAttribute(attrName, null);
                                    if (currentElement != null) {
                                        currentElement = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(SourceTreeToPsiMap.psiElementToTree(currentElement)));
                                    }
                                } else {
                                    currentElement = PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class, (boolean)false);
                                }
                                if (currentElement != null) {
                                    ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                                    ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, warning ? 0 : 1);
                                } else {
                                    ExternalDocumentValidator.this.addProblemToTagName(originalElement, originalElement, localizedMessage, warning);
                                }
                            } else if (localizedMessage.startsWith(ExternalDocumentValidator.STRING_ERROR_PREFIX)) {
                                if (currentElement != null) {
                                    ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, 0);
                                }
                            } else {
                                currentElement = ExternalDocumentValidator.getNodeForMessage(currentElement != null ? currentElement : originalElement);
                                ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                                if (currentElement != null) {
                                    ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, warning ? 0 : 1);
                                }
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    if (ex instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)((Object)ex);
                    }
                    if (ex instanceof XmlResourceResolver.IgnoredResourceException) {
                        throw (XmlResourceResolver.IgnoredResourceException)ex;
                    }
                    LOG.error((Throwable)ex);
                }
            }
        });
        this.myHandler.doValidate(project, element.getContainingFile());
        this.myFile = file;
        this.myModificationStamp = this.myFile.getModificationStamp();
        this.myInfos = new WeakReference(results);
        ExternalDocumentValidator.addAllInfos(host, results);
    }

    private static PsiElement getNodeForMessage(PsiElement currentElement) {
        PsiElement parentOfType = PsiTreeUtil.getNonStrictParentOfType((PsiElement)currentElement, (Class[])new Class[]{XmlTag.class, XmlProcessingInstruction.class, XmlElementDecl.class, XmlMarkupDecl.class, XmlEntityRef.class, XmlDoctype.class});
        if (parentOfType == null) {
            parentOfType = currentElement instanceof XmlToken ? currentElement.getParent() : currentElement;
        }
        return parentOfType;
    }

    private static void addAllInfos(Validator.ValidationHost host, List<ValidationInfo> highlightInfos) {
        for (ValidationInfo info : highlightInfos) {
            host.addMessage(info.element, info.message, info.type);
        }
    }

    private PsiElement addProblemToTagName(PsiElement currentElement, PsiElement originalElement, String localizedMessage, boolean warning) {
        if ((currentElement = PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class, (boolean)false)) == null) {
            currentElement = PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlElementDecl.class, (boolean)false);
        }
        if (currentElement == null) {
            currentElement = originalElement;
        }
        ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
        if (currentElement != null) {
            this.myHost.addMessage(currentElement, localizedMessage, warning ? 0 : 1);
        }
        return currentElement;
    }

    private static void assertValidElement(PsiElement currentElement, PsiElement originalElement, String message) {
        if (currentElement == null) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
            LOG.error("The validator message:" + message + " is bound to null node,\n" + "initial element:" + originalElement.getText() + ",\n" + "parent:" + originalElement.getParent() + ",\n" + "tag:" + (tag != null ? tag.getText() : "null") + ",\n" + "offset in tag: " + (originalElement.getTextOffset() - (tag == null ? 0 : tag.getTextOffset())));
        }
    }

    public static synchronized void doValidation(XmlDocument document, Validator.ValidationHost host) {
        ExternalDocumentValidator validator;
        XmlTag rootTag;
        PsiFile containingFile = document.getContainingFile();
        if (containingFile == null) {
            return;
        }
        if (containingFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            return;
        }
        FileType fileType = containingFile.getViewProvider().getVirtualFile().getFileType();
        if (fileType != XmlFileType.INSTANCE && fileType != XHtmlFileType.INSTANCE) {
            return;
        }
        for (Language lang : containingFile.getViewProvider().getLanguages()) {
            if (!"ANT".equals(lang.getID())) continue;
            return;
        }
        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
        if (rootTag == null) {
            return;
        }
        if ("http://ant.apache.org/schema.xsd".equals(rootTag.getNamespace())) {
            return;
        }
        Project project = document.getProject();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)profile.getInspectionTool("CheckXmlFileWithXercesValidator", (PsiElement)containingFile);
        if (toolWrapper == null) {
            return;
        }
        if (!profile.isToolEnabled(HighlightDisplayKey.find((String)"CheckXmlFileWithXercesValidator"), (PsiElement)containingFile)) {
            return;
        }
        SoftReference validatorReference = (SoftReference)project.getUserData(validatorInstanceKey);
        ExternalDocumentValidator externalDocumentValidator = validator = validatorReference != null ? (ExternalDocumentValidator)validatorReference.get() : null;
        if (validator == null) {
            validator = new ExternalDocumentValidator();
            project.putUserData(validatorInstanceKey, (Object)new SoftReference((Object)validator));
        }
        validator.runJaxpValidation((XmlElement)document, host);
    }

    private static class ValidationInfo {
        PsiElement element;
        String message;
        int type;

        private ValidationInfo() {
        }
    }
}

