/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNamespaceIndex
extends XmlIndex<String> {
    private static final ID<String, String> NAME = ID.create((String)"XmlNamespaces");

    @Nullable
    public static String getNamespace(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/index/XmlNamespaceIndex.getNamespace must not be null");
        }
        List<String> list = FileBasedIndex.getInstance().getValues(NAME, file.getUrl(), XmlNamespaceIndex.createFilter(project));
        return list.size() == 0 ? null : list.get(0);
    }

    public static List<IndexedRelevantResource<String, String>> getResourcesByNamespace(String namespace, Project project, Module module) {
        List<IndexedRelevantResource<String, String>> resources = IndexedRelevantResource.getResources(NAME, namespace, module, project);
        Collections.sort(resources);
        return resources;
    }

    @Override
    public ID<String, String> getName() {
        return NAME;
    }

    @Override
    public DataIndexer<String, String, FileContent> getIndexer() {
        return new DataIndexer<String, String, FileContent>(){

            @Override
            @NotNull
            public Map<String, String> map(FileContent inputData) {
                String ns = XsdNamespaceBuilder.computeNamespace(new ByteArrayInputStream(inputData.getContent()));
                HashMap<String, String> map = new HashMap<String, String>(2);
                if (ns != null) {
                    map.put(ns, "");
                }
                map.put(inputData.getFile().getUrl(), ns == null ? "" : ns);
                HashMap<String, String> hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/xml/index/XmlNamespaceIndex$1.map must not return null");
                }
                return hashMap;
            }
        };
    }

    @Override
    public DataExternalizer<String> getValueExternalizer() {
        return KEY_DESCRIPTOR;
    }
}

