/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;

public class XIncludeProvider
extends FileIncludeProvider {
    @Override
    @NotNull
    public String getId() {
        if ("XInclude" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XIncludeProvider.getId must not return null");
        }
        return "XInclude";
    }

    @Override
    public boolean acceptFile(VirtualFile file) {
        FileType fileType = file.getFileType();
        return fileType == XmlFileType.INSTANCE && !ProjectUtil.isProjectOrWorkspaceFile(file, fileType);
    }

    @Override
    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        final ArrayList infos = new ArrayList();
        NanoXmlUtil.parse((InputStream)new ByteArrayInputStream(content.getContent()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
            boolean isXInclude;

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                this.isXInclude = "http://www.w3.org/2001/XInclude".equals(nsURI) && "include".equals(name);
            }

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                if (this.isXInclude && "href".equals(key)) {
                    infos.add(new FileIncludeInfo(value));
                }
            }

            public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                this.isXInclude = false;
            }
        });
        FileIncludeInfo[] fileIncludeInfoArray = infos.toArray(new FileIncludeInfo[infos.size()]);
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XIncludeProvider.getIncludeInfos must not return null");
        }
        return fileIncludeInfoArray;
    }
}

