/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public class IdeaPluginConverter
extends ResolvingConverter<IdeaPlugin> {
    @NonNls
    private static final Set<String> PLATFORM_MODULES = CollectionFactory.newTroveSet((Object[])new String[]{"com.intellij.modules.platform", "com.intellij.modules.lang", "com.intellij.modules.vcs", "com.intellij.modules.xdebugger", "com.intellij.modules.xml"});

    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(ConvertContext context) {
        Collection<IdeaPlugin> collection = IdeaPluginConverter.collectAllVisiblePlugins(context.getFile());
        if (collection == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter.getVariants must not return null");
        }
        return collection;
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter.getAdditionalVariants must not be null");
        }
        Set<String> set = PLATFORM_MODULES;
        if (set == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter.getAdditionalVariants must not return null");
        }
        return set;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return DevKitBundle.message("error.cannot.resolve.plugin", s);
    }

    public static Collection<IdeaPlugin> collectAllVisiblePlugins(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter.collectAllVisiblePlugins must not be null");
        }
        Project project = xmlFile.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        List files = DomService.getInstance().getFileElements(IdeaPlugin.class, project, scope);
        return ContainerUtil.map((Iterable)files, (Function)new Function<DomFileElement<IdeaPlugin>, IdeaPlugin>(){

            public IdeaPlugin fun(DomFileElement<IdeaPlugin> ideaPluginDomFileElement) {
                return (IdeaPlugin)ideaPluginDomFileElement.getRootElement();
            }
        });
    }

    public IdeaPlugin fromString(@Nullable @NonNls String s, ConvertContext context) {
        for (IdeaPlugin ideaPlugin : this.getVariants(context)) {
            String otherId = ideaPlugin.getPluginId();
            if (otherId == null || !otherId.equals(s)) continue;
            return ideaPlugin;
        }
        return null;
    }

    public String toString(@Nullable IdeaPlugin ideaPlugin, ConvertContext context) {
        return ideaPlugin != null ? ideaPlugin.getPluginId() : null;
    }
}

