/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DescriptionNotFoundInspection;

public class CreateHtmlDescriptionFix
implements LocalQuickFix,
Iconable {
    private final String myFilename;
    private final Module myModule;
    @NonNls
    private static final String DESCRIPTIONS_FOLDER = "inspectionDescriptions";
    @NonNls
    private static final String TEMPLATE_NAME = "InspectionDescription.html";
    private static final Icon NEW_HTML_ICON = IconLoader.getIcon((String)"/new_html.png");

    public CreateHtmlDescriptionFix(String filename, Module module) {
        this.myModule = module;
        this.myFilename = filename + ".html";
    }

    @NotNull
    public String getName() {
        String string = DevKitBundle.message("create.description.file", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("DevKit" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix.getFamilyName must not return null");
        }
        return "DevKit";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix.applyFix must not be null");
        }
        List<VirtualFile> virtualFiles = DescriptionNotFoundInspection.getPotentialRoots(this.myModule);
        final VirtualFile[] roots = CreateHtmlDescriptionFix.prepare(VfsUtil.toVirtualFileArray(virtualFiles));
        if (roots.length == 1) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CreateHtmlDescriptionFix.this.createDescription(roots[0]);
                }
            });
        } else {
            ArrayList<String> options = new ArrayList<String>();
            for (VirtualFile file : roots) {
                options.add(file.getPresentableUrl() + File.separator + DESCRIPTIONS_FOLDER + File.separator + this.myFilename);
            }
            final JList<String> files = new JList<String>(ArrayUtil.toStringArray(options));
            PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(files);
            JBPopup popup = builder.setTitle(DevKitBundle.message("select.target.location.of.description", this.myFilename)).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    final int index = files.getSelectedIndex();
                    if (0 <= index && index < roots.length) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                CreateHtmlDescriptionFix.this.createDescription(roots[index]);
                            }
                        });
                    }
                }
            }).createPopup();
            Editor editor = FileEditorManager.getInstance((Project)this.myModule.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            popup.showInBestPositionFor(editor);
        }
    }

    private void createDescription(VirtualFile root) {
        if (!root.isDirectory()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        PsiDirectory psiRoot = psiManager.findDirectory(root);
        PsiDirectory descrRoot = null;
        if (psiRoot == null) {
            return;
        }
        for (PsiDirectory dir : psiRoot.getSubdirectories()) {
            if (!DESCRIPTIONS_FOLDER.equals(dir.getName())) continue;
            descrRoot = dir;
            break;
        }
        try {
            VirtualFile file;
            descrRoot = descrRoot == null ? psiRoot.createSubdirectory(DESCRIPTIONS_FOLDER) : descrRoot;
            FileTemplate descrTemplate = FileTemplateManager.getInstance().getJ2eeTemplate(TEMPLATE_NAME);
            PsiElement template = FileTemplateUtil.createFromTemplate((FileTemplate)descrTemplate, (String)this.myFilename, null, (PsiDirectory)descrRoot);
            if (template instanceof PsiFile && (file = ((PsiFile)template).getVirtualFile()) != null) {
                FileEditorManager.getInstance((Project)this.myModule.getProject()).openFile(file, true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Icon getIcon(int flags) {
        return NEW_HTML_ICON;
    }

    private static VirtualFile[] prepare(VirtualFile[] roots) {
        ArrayList<VirtualFile> found = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            if (!CreateHtmlDescriptionFix.containsDescriptionDir(root)) continue;
            found.add(root);
        }
        return found.size() > 0 ? VfsUtil.toVirtualFileArray(found) : roots;
    }

    private static boolean containsDescriptionDir(VirtualFile root) {
        if (!root.isDirectory()) {
            return false;
        }
        for (VirtualFile file : root.getChildren()) {
            if (!file.isDirectory() || !DESCRIPTIONS_FOLDER.equals(file.getName())) continue;
            return true;
        }
        return false;
    }
}

