/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.annotator;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectProblem;

public class MavenDomAnnotator
implements DomElementsAnnotator {
    public void annotate(DomElement element, DomElementAnnotationHolder holder) {
        if (element instanceof MavenDomProjectModel) {
            this.addProblems(element, (MavenDomProjectModel)element, holder, MavenProjectProblem.ProblemType.STRUCTURE, MavenProjectProblem.ProblemType.SETTINGS_OR_PROFILES);
        } else if (element instanceof MavenDomParent) {
            this.addProblems(element, (MavenDomProjectModel)DomUtil.getParentOfType((DomElement)element, MavenDomProjectModel.class, (boolean)true), holder, MavenProjectProblem.ProblemType.PARENT);
        }
    }

    private void addProblems(DomElement element, MavenDomProjectModel model, DomElementAnnotationHolder holder, MavenProjectProblem.ProblemType ... types) {
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null) {
            for (MavenProjectProblem each : mavenProject.getProblems()) {
                MavenProjectProblem.ProblemType type = each.getType();
                if (!Arrays.asList(types).contains((Object)type)) continue;
                VirtualFile problemFile = each.findFile();
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                if (problemFile != null && mavenProject.getFile() != problemFile) {
                    fixes = new LocalQuickFix[]{new OpenProblemFileFix(problemFile)};
                }
                holder.createProblem(element, HighlightSeverity.ERROR, each.getDescription(), fixes);
            }
        }
    }

    private static class OpenProblemFileFix
    implements LocalQuickFix {
        private final VirtualFile myFile;

        private OpenProblemFileFix(VirtualFile file) {
            this.myFile = file;
        }

        @NotNull
        public String getName() {
            String string = MavenDomBundle.message("fix.open.file", this.myFile.getName());
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/annotator/MavenDomAnnotator$OpenProblemFileFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/annotator/MavenDomAnnotator$OpenProblemFileFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomAnnotator$OpenProblemFileFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/annotator/MavenDomAnnotator$OpenProblemFileFix.applyFix must not be null");
            }
            new OpenFileDescriptor(project, this.myFile).navigate(true);
        }
    }
}

