/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.utils.Strings;

public abstract class MavenRunnerParametersConfigurable
implements Configurable {
    private JPanel panel;
    protected LabeledComponent<TextFieldWithBrowseButton> workingDirComponent;
    protected LabeledComponent<JTextField> goalsComponent;
    private LabeledComponent<JTextField> profilesComponent;

    public MavenRunnerParametersConfigurable() {
        this.$$$setupUI$$$();
        ((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).addBrowseFolderListener(RunnerBundle.message("maven.select.maven.project.file", new Object[0]), "", null, new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                if (!super.isFileSelectable(file)) {
                    return false;
                }
                return file.findChild("pom.xml") != null;
            }
        });
    }

    public JComponent createComponent() {
        return this.panel;
    }

    public void disposeUIResources() {
    }

    public String getDisplayName() {
        return RunnerBundle.message("maven.runner.parameters.title", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    public boolean isModified() {
        MavenRunnerParameters formParameters = new MavenRunnerParameters();
        this.setData(formParameters);
        return !formParameters.equals(this.getParameters());
    }

    public void apply() throws ConfigurationException {
        this.setData(this.getParameters());
    }

    public void reset() {
        this.getData(this.getParameters());
    }

    private void setData(MavenRunnerParameters data) {
        data.setWorkingDirPath(((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).getText());
        data.setGoals(Strings.tokenize(((JTextField)this.goalsComponent.getComponent()).getText(), " "));
        data.setProfiles(Strings.tokenize(((JTextField)this.profilesComponent.getComponent()).getText(), " "));
    }

    private void getData(MavenRunnerParameters data) {
        ((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).setText(data.getWorkingDirPath());
        ((JTextField)this.goalsComponent.getComponent()).setText(Strings.detokenize(data.getGoals(), ' '));
        ((JTextField)this.profilesComponent.getComponent()).setText(Strings.detokenize(data.getProfiles(), ' '));
    }

    protected abstract MavenRunnerParameters getParameters();

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.workingDirComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setLabelLocation("North");
        labeledComponent3.setText("Working &directory");
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.goalsComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setLabelLocation("North");
        labeledComponent2.setText("&Goals (separated with space)");
        labeledComponent2.setComponentClass("javax.swing.JTextField");
        jPanel.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.profilesComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setLabelLocation("North");
        labeledComponent.setText("&Profiles (separated with space)");
        labeledComponent.setComponentClass("javax.swing.JTextField");
        jPanel.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

