/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenImportingSettingsForm {
    private JPanel myPanel;
    private JCheckBox mySearchRecursivelyCheckBox;
    private JLabel myProjectFormatLabel;
    private JComboBox myProjectFormatComboBox;
    private ProjectFormatPanel myProjectFormatPanel;
    private JCheckBox mySeparateModulesDirCheckBox;
    private TextFieldWithBrowseButton mySeparateModulesDirChooser;
    private JCheckBox myImportAutomaticallyBox;
    private JCheckBox myCreateModulesForAggregators;
    private JCheckBox myCreateGroupsCheckBox;
    private JComboBox myUpdateFoldersOnImportPhaseComboBox;
    private JCheckBox myUseMavenOutputCheckBox;
    private JCheckBox myDownloadSourcesCheckBox;
    private JCheckBox myDownloadDocsCheckBox;

    public MavenImportingSettingsForm(boolean isImportStep) {
        this.$$$setupUI$$$();
        if (!isImportStep) {
            this.mySearchRecursivelyCheckBox.setVisible(false);
            this.myProjectFormatLabel.setVisible(false);
            this.myProjectFormatComboBox.setVisible(false);
            this.mySeparateModulesDirCheckBox.setVisible(false);
            this.mySeparateModulesDirChooser.setVisible(false);
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenImportingSettingsForm.this.updateControls();
            }
        };
        this.mySeparateModulesDirCheckBox.addActionListener(listener);
        this.mySeparateModulesDirChooser.addBrowseFolderListener(ProjectBundle.message("maven.import.title.module.dir", new Object[0]), "", null, new FileChooserDescriptor(false, true, false, false, false, false));
        this.myUpdateFoldersOnImportPhaseComboBox.setModel(new DefaultComboBoxModel<String>(MavenImportingSettings.UPDATE_FOLDERS_PHASES));
    }

    private void createUIComponents() {
        this.myProjectFormatPanel = new ProjectFormatPanel();
        this.myProjectFormatComboBox = this.myProjectFormatPanel.getStorageFormatComboBox();
    }

    private void updateControls() {
        boolean useSeparateDir = this.mySeparateModulesDirCheckBox.isSelected();
        this.mySeparateModulesDirChooser.setEnabled(useSeparateDir);
        if (useSeparateDir && StringUtil.isEmptyOrSpaces((String)this.mySeparateModulesDirChooser.getText())) {
            this.mySeparateModulesDirChooser.setText(FileUtil.toSystemDependentName((String)this.getDefaultModuleDir()));
        }
    }

    public String getDefaultModuleDir() {
        return "";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void getData(MavenImportingSettings data) {
        data.setLookForNested(this.mySearchRecursivelyCheckBox.isSelected());
        data.setDedicatedModuleDir(this.mySeparateModulesDirCheckBox.isSelected() ? this.mySeparateModulesDirChooser.getText() : "");
        data.setImportAutomatically(this.myImportAutomaticallyBox.isSelected());
        data.setCreateModulesForAggregators(this.myCreateModulesForAggregators.isSelected());
        data.setCreateModuleGroups(this.myCreateGroupsCheckBox.isSelected());
        data.setUseMavenOutput(this.myUseMavenOutputCheckBox.isSelected());
        data.setUpdateFoldersOnImportPhase((String)this.myUpdateFoldersOnImportPhaseComboBox.getSelectedItem());
        data.setDownloadSourcesAutomatically(this.myDownloadSourcesCheckBox.isSelected());
        data.setDownloadDocsAutomatically(this.myDownloadDocsCheckBox.isSelected());
    }

    public void setData(MavenImportingSettings data) {
        this.mySearchRecursivelyCheckBox.setSelected(data.isLookForNested());
        this.mySeparateModulesDirCheckBox.setSelected(!StringUtil.isEmptyOrSpaces((String)data.getDedicatedModuleDir()));
        this.mySeparateModulesDirChooser.setText(data.getDedicatedModuleDir());
        this.myImportAutomaticallyBox.setSelected(data.isImportAutomatically());
        this.myCreateModulesForAggregators.setSelected(data.isCreateModulesForAggregators());
        this.myCreateGroupsCheckBox.setSelected(data.isCreateModuleGroups());
        this.myUseMavenOutputCheckBox.setSelected(data.isUseMavenOutput());
        this.myUpdateFoldersOnImportPhaseComboBox.setSelectedItem(data.getUpdateFoldersOnImportPhase());
        this.myDownloadSourcesCheckBox.setSelected(data.isDownloadSourcesAutomatically());
        this.myDownloadDocsCheckBox.setSelected(data.isDownloadDocsAutomatically());
        this.updateControls();
    }

    public boolean isModified(MavenImportingSettings settings) {
        MavenImportingSettings formData = new MavenImportingSettings();
        this.getData(formData);
        return !formData.equals(settings);
    }

    public void updateData(WizardContext wizardContext) {
        this.myProjectFormatPanel.updateData(wizardContext);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JLabel jLabel;
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySeparateModulesDirCheckBox = jCheckBox8 = new JCheckBox();
        jCheckBox8.setMargin(new Insets(2, 0, 10, 3));
        jCheckBox8.setText("Keep project files in");
        jCheckBox8.setMnemonic('K');
        jCheckBox8.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox8, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(142, 18), null));
        this.myCreateModulesForAggregators = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox7.setText("Create IDEA modules for aggregator projects (with 'pom' packaging)");
        jCheckBox7.setMnemonic('M');
        jCheckBox7.setDisplayedMnemonicIndex(12);
        jPanel.add((Component)jCheckBox7, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myCreateGroupsCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox6.setText("Create module groups for multi-module Maven projects");
        jCheckBox6.setMnemonic('G');
        jCheckBox6.setDisplayedMnemonicIndex(14);
        jPanel.add((Component)jCheckBox6, new GridConstraints(5, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.mySeparateModulesDirChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 3, 1, 1, 7, 0, null, new Dimension(28, 18), null));
        this.myUpdateFoldersOnImportPhaseComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(7, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myProjectFormatLabel = jLabel = new JLabel();
        jLabel.setText("Project format");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(13);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = this.myProjectFormatComboBox;
        jPanel.add((Component)jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 2, 1, 2, 0, 1, 2, 1, null, null, null));
        this.mySearchRecursivelyCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 0, 10, 3));
        jCheckBox5.setText("Search for projects recursively");
        jCheckBox5.setMnemonic('S');
        jCheckBox5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myUseMavenOutputCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 0, 10, 3));
        jCheckBox4.setText("Use Maven output directories");
        jCheckBox4.setMnemonic('O');
        jCheckBox4.setDisplayedMnemonicIndex(10);
        jPanel.add((Component)jCheckBox4, new GridConstraints(6, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Phase to be used for folders update");
        jLabel2.setDisplayedMnemonic('U');
        jLabel2.setDisplayedMnemonicIndex(29);
        jPanel.add((Component)jLabel2, new GridConstraints(7, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        Font font = jLabel3.getFont();
        jLabel3.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        jLabel3.setText("<html>IDEA needs to execute one of the listed phases in order to discover all source folders<br>that are configured via Maven plugins.<br><b>Note</b> that all test-* phases firstly generate and compile production sources.</html>");
        jPanel.add((Component)jLabel3, new GridConstraints(8, 0, 1, 4, 8, 0, 0, 0, null, null, null, 1));
        this.myImportAutomaticallyBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox3.setText("Import Maven projects automatically");
        jCheckBox3.setMnemonic('A');
        jCheckBox3.setDisplayedMnemonicIndex(22);
        jPanel.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel2.setFocusable(true);
        jPanel.add((Component)jPanel2, new GridConstraints(9, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Automatically download");
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadSourcesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox2.setText("Sources");
        jCheckBox2.setMnemonic('R');
        jCheckBox2.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDownloadDocsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Documentation");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 7, 0, null, null, null));
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

