/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.execution.RunManagerEx;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;
import org.jetbrains.idea.maven.tasks.MavenCompilerTask;
import org.jetbrains.idea.maven.tasks.MavenTasksManagerState;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.SimpleProjectComponent;

@State(name="MavenCompilerTasksManager", storages={@Storage(id="default", file="$PROJECT_FILE$")})
public class MavenTasksManager
extends SimpleProjectComponent
implements PersistentStateComponent<MavenTasksManagerState> {
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private MavenTasksManagerState myState = new MavenTasksManagerState();
    private final MavenProjectsManager myProjectsManager;
    private final MavenRunner myRunner;
    private final List<Listener> myListeners = ContainerUtil.createEmptyCOWList();

    public static MavenTasksManager getInstance(Project project) {
        return (MavenTasksManager)((Object)project.getComponent(MavenTasksManager.class));
    }

    public MavenTasksManager(Project project, MavenProjectsManager projectsManager, MavenRunner runner) {
        super(project);
        this.myProjectsManager = projectsManager;
        this.myRunner = runner;
    }

    public synchronized MavenTasksManagerState getState() {
        MavenTasksManagerState result = new MavenTasksManagerState();
        result.afterCompileTasks = new THashSet(this.myState.afterCompileTasks);
        result.beforeCompileTasks = new THashSet(this.myState.beforeCompileTasks);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(MavenTasksManagerState state) {
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState = state;
        }
        if (this.isInitialized.get()) {
            this.fireTasksChanged();
        }
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        compilerManager.addBeforeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                return MavenTasksManager.this.doExecute(true, context);
            }
        });
        compilerManager.addAfterTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                return MavenTasksManager.this.doExecute(false, context);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecute(boolean before, CompileContext context) {
        ArrayList<MavenRunnerParameters> parametersList;
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            parametersList = new ArrayList<MavenRunnerParameters>();
            Set<MavenCompilerTask> tasks = before ? this.myState.beforeCompileTasks : this.myState.afterCompileTasks;
            for (MavenCompilerTask each : tasks) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(each.getProjectPath());
                if (file == null) continue;
                parametersList.add(new MavenRunnerParameters(true, file.getParent().getPath(), Arrays.asList(each.getGoal()), this.myProjectsManager.getExplicitProfiles()));
            }
        }
        return this.myRunner.runBatch(parametersList, null, null, TasksBundle.message("maven.tasks.executing", new Object[0]), context.getProgressIndicator());
    }

    public synchronized boolean isBeforeCompileTask(MavenCompilerTask task) {
        return this.myState.beforeCompileTasks.contains(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeforeCompileTasks(List<MavenCompilerTask> tasks) {
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState.beforeCompileTasks.addAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeforeCompileTasks(List<MavenCompilerTask> tasks) {
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState.beforeCompileTasks.removeAll(tasks);
        }
        this.fireTasksChanged();
    }

    public synchronized boolean isAfterCompileTask(MavenCompilerTask task) {
        return this.myState.afterCompileTasks.contains(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfterCompileTasks(List<MavenCompilerTask> tasks) {
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState.afterCompileTasks.addAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAfterCompileTasks(List<MavenCompilerTask> tasks) {
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState.afterCompileTasks.removeAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(MavenProject project, String goal) {
        ArrayList<String> result = new ArrayList<String>();
        MavenCompilerTask compilerTask = new MavenCompilerTask(project.getPath(), goal);
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            if (this.myState.beforeCompileTasks.contains(compilerTask)) {
                result.add(TasksBundle.message("maven.tasks.goal.before.compile", new Object[0]));
            }
            if (this.myState.afterCompileTasks.contains(compilerTask)) {
                result.add(TasksBundle.message("maven.tasks.goal.after.compile", new Object[0]));
            }
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        for (MavenBeforeRunTask each : runManager.getBeforeRunTasks(MavenBeforeRunTasksProvider.TASK_ID, true)) {
            if (!each.isFor(project, goal)) continue;
            result.add(TasksBundle.message("maven.tasks.goal.before.run", new Object[0]));
            break;
        }
        return StringUtil.join(result, (String)", ");
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void fireTasksChanged() {
        for (Listener each : this.myListeners) {
            each.compileTasksChanged();
        }
    }

    public static interface Listener {
        public void compileTasksChanged();
    }
}

