/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsAdd;

import com.intellij.cvsSupport2.application.CvsStorageComponent;
import com.intellij.cvsSupport2.application.CvsStorageSupportingDeletionComponent;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionListWithSelection;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.ListWithSelection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class AddedFileInfo
extends DefaultMutableTreeNode {
    private final VirtualFile myAddedFile;
    private ListWithSelection mySubstitution;
    private boolean myIncluded;
    private AddedFileInfo myParent;
    private final MyComparator myComparator;
    @NotNull
    private final Project myProject;
    private final MyObservable myExcludedObservable;
    private static final Icon OPEN_ICON = IconLoader.getIcon((String)"/nodes/folderOpen.png");
    private static final Icon COLLAPSED_ICON = IconLoader.getIcon((String)"/nodes/folder.png");

    public AddedFileInfo(VirtualFile addedFile, @NotNull Project project, CvsConfiguration config) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/cvsSupport2/cvsoperations/cvsAdd/AddedFileInfo.<init> must not be null");
        }
        this.mySubstitution = new ListWithSelection();
        this.myIncluded = true;
        this.myComparator = new MyComparator();
        this.myExcludedObservable = new MyObservable();
        this.myAddedFile = addedFile;
        this.mySubstitution = KeywordSubstitutionListWithSelection.createOnFileName(this.myAddedFile.getName(), config);
        this.myProject = project;
    }

    public KeywordSubstitution getKeywordSubstitution() {
        if (this.myAddedFile.isDirectory()) {
            return null;
        }
        return ((KeywordSubstitutionWrapper)this.mySubstitution.getSelection()).getSubstitution();
    }

    public VirtualFile getFile() {
        return this.myAddedFile;
    }

    public boolean included() {
        return this.myIncluded;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/cvsoperations/cvsAdd/AddedFileInfo.getProject must not return null");
        }
        return project;
    }

    public void setIncluded(boolean aBoolean) {
        if (this.myIncluded == aBoolean) {
            return;
        }
        this.myIncluded = aBoolean;
        if (!this.myIncluded) {
            this.excludeAllChildren();
        } else {
            this.encludeAllParents();
        }
        this.myExcludedObservable.setChanged();
        this.myExcludedObservable.notifyObservers();
    }

    private void encludeAllParents() {
        if (this.myParent != null) {
            this.myParent.setIncluded(true);
        }
    }

    private void excludeAllChildren() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((AddedFileInfo)this.getChildAt(i)).setIncluded(false);
        }
    }

    public void setParent(AddedFileInfo parent) {
        this.myParent = parent;
        this.myParent.add(this);
    }

    public String getPresentableText() {
        if (this.myParent == null) {
            return VcsPathPresenter.getInstance((Project)this.myProject).getPresentableRelativePathFor(this.myAddedFile);
        }
        return this.myAddedFile.getName();
    }

    public Icon getIcon(boolean expanded) {
        if (this.myAddedFile.isDirectory()) {
            return expanded ? OPEN_ICON : COLLAPSED_ICON;
        }
        return IconUtil.getIcon((VirtualFile)this.myAddedFile, (int)0, (Project)this.myProject);
    }

    public Collection<AddedFileInfo> collectAllIncludedFiles() {
        ArrayList<AddedFileInfo> result = new ArrayList<AddedFileInfo>();
        if (!this.myIncluded) {
            return result;
        }
        result.add(this);
        for (int i = 0; i < this.getChildCount(); ++i) {
            result.addAll(((AddedFileInfo)this.getChildAt(i)).collectAllIncludedFiles());
        }
        return result;
    }

    public void sort() {
        if (this.children == null) {
            return;
        }
        Collections.sort(this.children, this.myComparator);
        Iterator each = this.children.iterator();
        while (each.hasNext()) {
            ((AddedFileInfo)each.next()).sort();
        }
    }

    public ListWithSelection getKeywordSubstitutionsWithSelection() {
        return this.mySubstitution;
    }

    public void setKeywordSubstitution(KeywordSubstitution s) {
        this.mySubstitution.select((Object)KeywordSubstitutionWrapper.getValue(s));
    }

    public File getPresentableFile() {
        return new File(this.getPresentableText());
    }

    public void addIncludedObserver(Observer observer) {
        this.myExcludedObservable.addObserver(observer);
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((AddedFileInfo)this.getChildAt(i)).addIncludedObserver(observer);
        }
    }

    public void removeIncludedObserver(Observer observer) {
        this.myExcludedObservable.deleteObserver(observer);
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((AddedFileInfo)this.getChildAt(i)).removeIncludedObserver(observer);
        }
    }

    public boolean hasIncludedNodes() {
        if (this.myIncluded) {
            return true;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            AddedFileInfo child = (AddedFileInfo)this.getChildAt(i);
            if (!child.hasIncludedNodes()) continue;
            return true;
        }
        return false;
    }

    public void clearAllCvsAdminDirectoriesInIncludedDirectories() {
        if (!this.myIncluded) {
            return;
        }
        if (!this.myAddedFile.isDirectory()) {
            return;
        }
        CvsStorageComponent cvsStorageComponent = CvsStorageSupportingDeletionComponent.getInstance(this.myProject);
        cvsStorageComponent.deleteIfAdminDirCreated(this.myAddedFile);
    }

    private static class MyObservable
    extends Observable {
        private MyObservable() {
        }

        @Override
        public synchronized void setChanged() {
            super.setChanged();
        }
    }

    private static class MyComparator
    implements Comparator {
        private MyComparator() {
        }

        public int compare(Object o1, Object o2) {
            AddedFileInfo info1 = (AddedFileInfo)o1;
            AddedFileInfo info2 = (AddedFileInfo)o2;
            if (info1.getFile().isDirectory() && !info2.getFile().isDirectory()) {
                return -1;
            }
            if (!info1.getFile().isDirectory() && info2.getFile().isDirectory()) {
                return 1;
            }
            return info1.getPresentableText().compareTo(info2.getPresentableText());
        }
    }
}

