/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsContent;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CompositeOperaton;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.common.RepositoryPathProvider;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentListener;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentProvider;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminReaderOnStoredRepositoryPath;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminWriterStoringRepositoryPath;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.ConstantLocalFileReader;
import com.intellij.cvsSupport2.javacvsImpl.io.DeafLocalFileWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.file.ILocalFileReader;
import org.netbeans.lib.cvsclient.file.ILocalFileWriter;

public class GetModuleContentOperation
extends CompositeOperaton
implements DirectoryContentProvider {
    private final DirectoryContentListener myDirectoryContentListener = new DirectoryContentListener();
    private final AdminWriterStoringRepositoryPath myAdminWriterStoringRepositoryPath;
    private String myModuleLocation;
    @NonNls
    private static final Pattern UPDATING_PATTERN = Pattern.compile("cvs .*: Updating (.+)");

    public GetModuleContentOperation(CvsEnvironment environment, String moduleName) {
        this.myAdminWriterStoringRepositoryPath = new AdminWriterStoringRepositoryPath(moduleName, environment.getCvsRootAsString());
        this.addOperation(this.createExpandingRepositoryPathOperation(this.myAdminWriterStoringRepositoryPath, environment, moduleName));
        this.addOperation(this.createGetModuleContentOperation(this.myAdminWriterStoringRepositoryPath, environment, moduleName));
    }

    private LocalPathIndifferentOperation createGetModuleContentOperation(RepositoryPathProvider adminWriter, CvsEnvironment environment, final String moduleName) {
        return new LocalPathIndifferentOperation(new AdminReaderOnStoredRepositoryPath(adminWriter), environment){
            private boolean myIsInModule;
            {
                super(x0, x1);
                this.myIsInModule = false;
            }

            @Override
            protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
                CheckoutCommand result = new CheckoutCommand(null);
                result.addModule(moduleName);
                result.setRecursive(true);
                return result;
            }

            @Override
            protected ILocalFileReader createLocalFileReader() {
                return ConstantLocalFileReader.FOR_EXISTING_FILE;
            }

            @Override
            protected String getOperationName() {
                return "checkout";
            }

            @Override
            protected ILocalFileWriter createLocalFileWriter(String cvsRoot, UpdatedFilesManager mergedFilesCollector, CvsExecutionEnvironment cvsExecutionEnvironment) {
                return DeafLocalFileWriter.INSTANCE;
            }

            @Override
            public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
                super.messageSent(message, byteMessage, error, tagged);
                GetModuleContentOperation.this.myDirectoryContentListener.setModulePath(GetModuleContentOperation.this.myAdminWriterStoringRepositoryPath.getModulePath());
                Matcher matcher = UPDATING_PATTERN.matcher(message);
                if (matcher.matches()) {
                    if (GetModuleContentOperation.this.myModuleLocation != null && GetModuleContentOperation.this.myModuleLocation.equals(matcher.group(1))) {
                        this.myIsInModule = true;
                    } else {
                        GetModuleContentOperation.this.myDirectoryContentListener.messageSent(message);
                        this.myIsInModule = false;
                    }
                } else if (DirectoryContentListener.moduleMessage_ver1(message)) {
                    this.myIsInModule = true;
                }
                if (this.myIsInModule) {
                    GetModuleContentOperation.this.myDirectoryContentListener.messageSent(message);
                }
            }

            @Override
            public void modifyOptions(GlobalOptions options) {
                super.modifyOptions(options);
                options.setDoNoChanges(true);
            }
        };
    }

    private LocalPathIndifferentOperation createExpandingRepositoryPathOperation(AdminWriterStoringRepositoryPath adminWriter, CvsEnvironment environment, final String moduleName) {
        return new LocalPathIndifferentOperation(adminWriter, environment){

            @Override
            protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
                CheckoutCommand result = new CheckoutCommand(null);
                result.addModule(moduleName);
                result.setRecursive(false);
                return result;
            }

            @Override
            protected ILocalFileWriter createLocalFileWriter(String cvsRoot, UpdatedFilesManager mergedFilesCollector, CvsExecutionEnvironment cvsExecutionEnvironment) {
                return DeafLocalFileWriter.INSTANCE;
            }

            @Override
            protected String getOperationName() {
                return "checkout";
            }

            @Override
            public void moduleExpanded(String module) {
                super.moduleExpanded(module);
                if (GetModuleContentOperation.this.myModuleLocation == null) {
                    GetModuleContentOperation.this.myModuleLocation = module;
                    GetModuleContentOperation.this.myDirectoryContentListener.setModuleName(GetModuleContentOperation.this.myModuleLocation);
                }
            }
        };
    }

    @Override
    public DirectoryContent getDirectoryContent() {
        return this.myDirectoryContentListener.getDirectoryContent();
    }
}

