/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IRootContainer;
import org.jetbrains.annotations.NotNull;

public class OneButtonGroupInspection
extends BaseFormInspection {
    public OneButtonGroupInspection() {
        super("OneButtonGroup");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = UIDesignerBundle.message("inspection.one.button.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/inspections/OneButtonGroupInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected void checkComponentProperties(Module module, IComponent component, FormErrorCollector collector) {
        IRootContainer root = FormEditingUtil.getRoot(component);
        if (root == null) {
            return;
        }
        String groupName = root.getButtonGroupName(component);
        if (groupName != null) {
            String[] sameGroupComponents;
            for (String id : sameGroupComponents = root.getButtonGroupComponentIds(groupName)) {
                IComponent otherComponent = FormEditingUtil.findComponent((IComponent)root, id);
                if (otherComponent == null || otherComponent == component) continue;
                return;
            }
            collector.addError(this.getID(), component, null, UIDesignerBundle.message("inspection.one.button.group.error", new Object[0]), null);
        }
    }
}

