/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.uiDesigner.compiler.FormLayoutCodeGenerator;
import com.intellij.uiDesigner.compiler.FormLayoutUtils;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.make.FormSourceCodeGenerator;
import com.intellij.uiDesigner.make.LayoutSourceGenerator;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Insets;
import org.jetbrains.annotations.NonNls;

public class FormLayoutSourceGenerator
extends LayoutSourceGenerator {
    private boolean myHaveCc = false;

    @Override
    public void generateContainerLayout(LwContainer component, FormSourceCodeGenerator generator, String variable) {
        FormLayout layout = (FormLayout)component.getLayout();
        generator.startMethodCall(variable, "setLayout");
        generator.startConstructor(FormLayout.class.getName());
        generator.push(FormLayoutUtils.getEncodedColumnSpecs((FormLayout)layout));
        generator.push(FormLayoutUtils.getEncodedRowSpecs((FormLayout)layout));
        generator.endConstructor();
        generator.endMethod();
        FormLayoutSourceGenerator.generateGroups(generator, variable, "setRowGroups", layout.getRowGroups());
        FormLayoutSourceGenerator.generateGroups(generator, variable, "setColumnGroups", layout.getColumnGroups());
    }

    private static void generateGroups(FormSourceCodeGenerator generator, String variable, @NonNls String methodName, int[][] groups) {
        if (groups.length == 0) {
            return;
        }
        generator.startMethodCall("((com.jgoodies.forms.layout.FormLayout) " + variable + ".getLayout())", methodName);
        StringBuilder groupBuilder = new StringBuilder("new int[][] {");
        for (int i = 0; i < groups.length; ++i) {
            if (i > 0) {
                groupBuilder.append(", ");
            }
            groupBuilder.append("new int[] { ");
            for (int j = 0; j < groups[i].length; ++j) {
                if (j > 0) {
                    groupBuilder.append(", ");
                }
                groupBuilder.append(groups[i][j]);
            }
            groupBuilder.append(" }");
        }
        groupBuilder.append(" }");
        generator.pushVar(groupBuilder.toString());
        generator.endMethod();
    }

    @Override
    public void generateComponentLayout(LwComponent component, FormSourceCodeGenerator generator, String variable, String parentVariable) {
        boolean haveInsets;
        if (!this.myHaveCc) {
            generator.append("com.jgoodies.forms.layout.CellConstraints cc = new com.jgoodies.forms.layout.CellConstraints();\n");
            this.myHaveCc = true;
        }
        generator.startMethodCall(parentVariable, "add");
        generator.pushVar(variable);
        CellConstraints cc = (CellConstraints)component.getCustomLayoutConstraints();
        GridConstraints constraints = component.getConstraints();
        boolean bl = haveInsets = !cc.insets.equals(new Insets(0, 0, 0, 0));
        if (haveInsets) {
            generator.startConstructor(CellConstraints.class.getName());
        } else if (constraints.getColSpan() == 1 && constraints.getRowSpan() == 1) {
            generator.startMethodCall("cc", "xy");
        } else if (constraints.getRowSpan() == 1) {
            generator.startMethodCall("cc", "xyw");
        } else {
            generator.startMethodCall("cc", "xywh");
        }
        generator.push(constraints.getColumn() + 1);
        generator.push(constraints.getRow() + 1);
        if (constraints.getColSpan() > 1 || constraints.getRowSpan() > 1 || haveInsets) {
            generator.push(constraints.getColSpan());
        }
        if (constraints.getRowSpan() > 1 || haveInsets) {
            generator.push(constraints.getRowSpan());
        }
        if (cc.hAlign != CellConstraints.DEFAULT || cc.vAlign != CellConstraints.DEFAULT || haveInsets) {
            String hAlign = cc.hAlign == CellConstraints.DEFAULT ? "DEFAULT" : FormLayoutCodeGenerator.HORZ_ALIGN_FIELDS[Utils.alignFromConstraints((GridConstraints)constraints, (boolean)true)];
            String vAlign = cc.vAlign == CellConstraints.DEFAULT ? "DEFAULT" : FormLayoutCodeGenerator.VERT_ALIGN_FIELDS[Utils.alignFromConstraints((GridConstraints)constraints, (boolean)false)];
            generator.pushVar("com.jgoodies.forms.layout.CellConstraints." + hAlign);
            generator.pushVar("com.jgoodies.forms.layout.CellConstraints." + vAlign);
        }
        if (haveInsets) {
            generator.newInsets(cc.insets);
        }
        generator.endMethod();
        generator.endMethod();
    }
}

